/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.porting.TSJMSObjects;
import com.sun.ts.lib.porting.TSJMSObjectsInterface;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.naming.NamingException;

public class JmsTool {
    private Queue testQueue = null;
    private QueueConnection qConnection = null;
    private QueueSession qSession = null;
    private QueueReceiver qReceiver = null;
    private QueueSender qSender = null;
    private Topic testTopic = null;
    private TopicConnection tConnection = null;
    private TopicSession tSession = null;
    private TopicSubscriber tSubscriber = null;
    private TopicPublisher tPublisher = null;
    private Destination testDestination = null;
    private Connection conn = null;
    private Session sess = null;
    private MessageConsumer receiver = null;
    private MessageProducer sender = null;
    private boolean durableTopic = false;
    private boolean transacted = false;
    private int ttype = 0;
    private int ftype = 5;
    private String username = null;
    private String password = null;
    private String jndiLookupName = null;
    public static final int QUEUE = 0;
    public static final int TOPIC = 1;
    public static final int TX_QUEUE = 2;
    public static final int TX_TOPIC = 3;
    public static final int DURABLE_TOPIC = 4;
    public static final int DURABLE_TX_TOPIC = 5;
    public static final int FACTORIES_ONLY = 6;
    public static final int QUEUE_FACTORY = 7;
    public static final int TOPIC_FACTORY = 8;
    public static final int DURABLE_TOPIC_FACTORY = 9;
    public static final int FACTORY_Q = 10;
    public static final int FACTORY_T = 11;
    public static final int FACTORY_DT = 12;
    public static final int COMMON_Q = 13;
    public static final int COMMON_T = 14;
    public static final int COMMON_QTX = 15;
    public static final int COMMON_TTX = 16;
    public static final int COMMON_FACTORY = 17;
    public static final String JMS_VERSION = "3.1";
    public static final int JMS_MAJOR_VERSION = 3;
    public static final int JMS_MINOR_VERSION = 1;
    public static final String TCKTESTQUEUENAME = "MY_QUEUE";
    public static final String TCKTESTTOPICNAME = "MY_TOPIC";
    public static final String TCKCONNECTIONFACTORY = "MyConnectionFactory";
    public static final String TCKQUEUECONNECTIONFACTORY = "MyQueueConnectionFactory";
    public static final String TCKTOPICCONNECTIONFACTORY = "MyTopicConnectionFactory";
    public static final String TCKDURABLETOPICCONNECTIONFACTORY = "DURABLE_SUB_CONNECTION_FACTORY";
    public static final String TESTQUEUENAME = "java:comp/env/jms/MY_QUEUE";
    public static final String TESTTOPICNAME = "java:comp/env/jms/MY_TOPIC";
    public static final String CONNECTIONFACTORY = "java:comp/env/jms/MyConnectionFactory";
    public static final String QUEUECONNECTIONFACTORY = "java:comp/env/jms/MyQueueConnectionFactory";
    public static final String TOPICCONNECTIONFACTORY = "java:comp/env/jms/MyTopicConnectionFactory";
    public static final String DURABLETOPICCONNECTIONFACTORY = "java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY";
    public static final String JMSDEFAULT = "jmsDefault";
    private TSNamingContext jndiContext = null;
    private QueueConnectionFactory qcf = null;
    private TopicConnectionFactory tcf = null;
    private TopicConnectionFactory tcf2 = null;
    private ConnectionFactory cf = null;
    private ConnectionFactory cf2 = null;
    private TSJMSObjectsInterface jmsObjects = null;
    private String mode = "jakartaEE";

    public JmsTool(int type, String m) throws Exception {
        this(type, JMSDEFAULT, JMSDEFAULT, m);
    }

    public JmsTool(int type, String user, String pw, String lookup, String m) throws Exception {
        this.username = user;
        this.password = pw;
        this.ttype = type;
        this.mode = m;
        if (this.mode.equals("jakartaEE")) {
            this.getJNDIContext();
        } else {
            this.jmsObjects = TSJMSObjects.getJMSObjectsInstance();
        }
        if (type == 1) {
            this.transacted = false;
            this.createTopicSetup(lookup);
        } else if (type == 3) {
            this.transacted = true;
            this.createTopicSetup(lookup);
        } else if (type == 4) {
            this.transacted = false;
            this.createTopicSetup(lookup);
        } else if (type == 5) {
            this.transacted = true;
            this.createTopicSetup(lookup);
        } else if (type == 14) {
            this.transacted = false;
            this.createCommonTSetup(lookup);
        } else if (type == 16) {
            this.transacted = true;
            this.createCommonTSetup(lookup);
        } else {
            String eMsg = "Type must be JmsTool.TOPIC, JmsTool.TX_TOPIC, JmsTool.DURABLE_TOPIC, JmsTool.DURABLE_TX_TOPIC, JmsTool.COMMON_T, JmsTool.COMMON_TTX.";
            throw new Exception(eMsg);
        }
    }

    public JmsTool(int type, String user, String pw, String m) throws Exception {
        this.username = user;
        this.password = pw;
        this.ttype = type;
        this.mode = m;
        if (this.mode.equals("jakartaEE")) {
            this.getJNDIContext();
        } else {
            this.jmsObjects = TSJMSObjects.getJMSObjectsInstance();
        }
        if (type == 0) {
            this.transacted = false;
            this.createQueueSetup();
        } else if (type == 2) {
            this.transacted = true;
            this.createQueueSetup();
        } else if (type == 1) {
            this.durableTopic = false;
            this.transacted = false;
            this.createTopicSetup();
        } else if (type == 3) {
            this.durableTopic = false;
            this.transacted = true;
            this.createTopicSetup();
        } else if (type == 4) {
            this.durableTopic = true;
            this.transacted = false;
            this.createTopicSetup();
        } else if (type == 5) {
            this.durableTopic = true;
            this.transacted = true;
            this.createTopicSetup();
        } else if (type == 13) {
            this.transacted = false;
            this.createCommonQSetup();
        } else if (type == 14) {
            this.transacted = false;
            this.createCommonTSetup();
        } else if (type == 15) {
            this.transacted = true;
            this.createCommonQSetup();
        } else if (type == 16) {
            this.transacted = true;
            this.createCommonTSetup();
        } else if (type == 6 || type == 7 || type == 9 || type == 8 || type == 17 || type == 10 || type == 12 || type == 11) {
            this.getConnectionFactoriesOnly(type);
        } else {
            String eMsg = "Type must be JmsTool.QUEUE, JmsTool.TOPIC, JmsTool.TX_QUEUE, JmsTool.TX_TOPIC, JmsTool.DURABLE_TOPIC, JmsTool.DURABLE_TX_TOPIC, JmsTool.FACTORIES_ONLY, JmsTool.QUEUE_FACTORY, JmsTool.TOPIC_FACTORY, JmsTool.COMMON_FACTORY, JmsTool.FACTORY_Q, JmsTool.FACTORY_T, JmsTool.FACTORY_DT, JmsTool.DURABLE_TOPIC_FACTORY, JmsTool.COMMON_Q, JmsTool.COMMON_T, JmsTool.COMMON_QTX, or JmsTool.COMMON_TTX.";
            throw new Exception(eMsg);
        }
    }

    private void getJNDIContext() throws Exception {
        if (this.jndiContext == null) {
            try {
                TestUtil.logTrace((String)"Getting initial context");
                this.jndiContext = new TSNamingContext();
            }
            catch (NamingException ne) {
                TestUtil.logErr((String)"Could not create JNDI context because: ", (Throwable)ne);
                throw ne;
            }
        }
    }

    private void getConnectionFactoriesOnly(int factype) throws Exception {
        try {
            this.ftype = factype;
            this.getConnectionFactoriesOnly();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
    }

    private void getConnectionFactoriesOnly() throws Exception {
        if (this.ftype == 7 || this.ftype == 6) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting QueueConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
                    this.qcf = (QueueConnectionFactory)this.jndiContext.lookup(QUEUECONNECTIONFACTORY);
                    this.jndiLookupName = QUEUECONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting QueueConnectionFactory MyQueueConnectionFactory");
                    this.qcf = this.jmsObjects.getQueueConnectionFactory(TCKQUEUECONNECTIONFACTORY);
                    this.jndiLookupName = TCKQUEUECONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                TestUtil.printStackTrace((Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 8 || this.ftype == 6) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting TopicConnectionFactory java:comp/env/jms/MyTopicConnectionFactory");
                    this.tcf = (TopicConnectionFactory)this.jndiContext.lookup(TOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TOPICCONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting TopicConnectionFactory MyTopicConnectionFactory");
                    this.tcf = this.jmsObjects.getTopicConnectionFactory(TCKTOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TCKTOPICCONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                TestUtil.printStackTrace((Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 9) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY");
                    this.tcf = (TopicConnectionFactory)this.jndiContext.lookup(DURABLETOPICCONNECTIONFACTORY);
                    this.jndiLookupName = DURABLETOPICCONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory DURABLE_SUB_CONNECTION_FACTORY");
                    this.tcf = this.jmsObjects.getTopicConnectionFactory(TCKDURABLETOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TCKDURABLETOPICCONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                TestUtil.printStackTrace((Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 17) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting ConnectionFactory java:comp/env/jms/MyConnectionFactory");
                    this.cf = (ConnectionFactory)this.jndiContext.lookup(CONNECTIONFACTORY);
                    this.jndiLookupName = CONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting ConnectionFactory MyConnectionFactory");
                    this.cf = this.jmsObjects.getConnectionFactory(TCKCONNECTIONFACTORY);
                    this.jndiLookupName = TCKCONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 11 || this.ftype == 6) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting TopicConnectionFactory as a ConnectionFactory java:comp/env/jms/MyTopicConnectionFactory");
                    this.cf = (ConnectionFactory)this.jndiContext.lookup(TOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TOPICCONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting TopicConnectionFactory as a ConnectionFactory MyTopicConnectionFactory");
                    this.cf = this.jmsObjects.getTopicConnectionFactory(TCKTOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TCKTOPICCONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 12) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory as a ConnectionFactory java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY");
                    this.cf = (ConnectionFactory)this.jndiContext.lookup(DURABLETOPICCONNECTIONFACTORY);
                    this.jndiLookupName = DURABLETOPICCONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory as a ConnectionFactory DURABLE_SUB_CONNECTION_FACTORY");
                    this.cf = this.jmsObjects.getTopicConnectionFactory(TCKDURABLETOPICCONNECTIONFACTORY);
                    this.jndiLookupName = TCKDURABLETOPICCONNECTIONFACTORY;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                throw e;
            }
        }
        if (this.ftype == 10 || this.ftype == 6) {
            try {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting QueueConnectionFactory as a ConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
                    this.cf = (ConnectionFactory)this.jndiContext.lookup(QUEUECONNECTIONFACTORY);
                    this.jndiLookupName = QUEUECONNECTIONFACTORY;
                } else {
                    TestUtil.logTrace((String)"Getting QueueConnectionFactory as a ConnectionFactory MyQueueConnectionFactory");
                    this.cf = this.jmsObjects.getQueueConnectionFactory(TCKQUEUECONNECTIONFACTORY);
                    this.jndiLookupName = TCKQUEUECONNECTIONFACTORY;
                }
                this.qcf = (QueueConnectionFactory)this.cf;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Failed to lookup connection factory using name " + this.jndiLookupName + " because: "), (Throwable)e);
                throw e;
            }
        }
    }

    private void createQueueSetup() throws Exception {
        Object eMsg = "";
        try {
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting QueueConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
                this.qcf = (QueueConnectionFactory)this.jndiContext.lookup(QUEUECONNECTIONFACTORY);
                eMsg = "Failed to lookup QueueConnectionFactory using name java:comp/env/jms/MyQueueConnectionFactory";
            } else {
                TestUtil.logTrace((String)"Getting QueueConnectionFactory MyQueueConnectionFactory");
                this.qcf = this.jmsObjects.getQueueConnectionFactory(TCKQUEUECONNECTIONFACTORY);
                eMsg = "Failed to lookup QueueConnectionFactory using name MyQueueConnectionFactory";
            }
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting Queue java:comp/env/jms/MY_QUEUE");
                this.testQueue = (Queue)this.jndiContext.lookup(TESTQUEUENAME);
                eMsg = "Failed to lookup Queue java:comp/env/jms/MY_QUEUE";
            } else {
                TestUtil.logTrace((String)"Getting Queue MY_QUEUE");
                this.testQueue = this.jmsObjects.getQueue(TCKTESTQUEUENAME);
                eMsg = "Failed to lookup Queue MY_QUEUE";
            }
            TestUtil.logTrace((String)"Creating QueueConnection");
            eMsg = "Failed to create queue connection using username, " + this.username + " password, " + this.password;
            this.qConnection = (QueueConnection)this.createNewConnection(this.ttype, this.username, this.password);
            TestUtil.logTrace((String)"Creating QueueSession");
            eMsg = "Failed to create queue session";
            this.qSession = this.qConnection.createQueueSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating receiver");
            eMsg = "Failed to create receiver for queue " + this.testQueue;
            this.qReceiver = this.qSession.createReceiver(this.testQueue);
            TestUtil.logTrace((String)"Creating sender");
            eMsg = "Failed to create sender for queue " + this.testQueue;
            this.qSender = this.qSession.createSender(this.testQueue);
            TestUtil.logTrace((String)"Success - Queue Setup done");
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
    }

    private void createTopicSetup() throws Exception {
        Object eMsg = "";
        try {
            if (this.durableTopic) {
                if (this.mode.equals("jakartaEE")) {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY");
                    this.tcf = (TopicConnectionFactory)this.jndiContext.lookup(DURABLETOPICCONNECTIONFACTORY);
                    eMsg = "Failed to lookup TopicConnectionFactory using name java:comp/env/jms/DURABLE_SUB_CONNECTION_FACTORY";
                } else {
                    TestUtil.logTrace((String)"Getting Durable TopicConnectionFactory DURABLE_SUB_CONNECTION_FACTORY");
                    this.tcf = this.jmsObjects.getTopicConnectionFactory(TCKDURABLETOPICCONNECTIONFACTORY);
                    eMsg = "Failed to lookup TopicConnectionFactory using name DURABLE_SUB_CONNECTION_FACTORY";
                }
            } else if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting TopicConnectionFactory java:comp/env/jms/MyTopicConnectionFactory");
                this.tcf = (TopicConnectionFactory)this.jndiContext.lookup(TOPICCONNECTIONFACTORY);
                eMsg = "Failed to lookup TopicConnectionFactory using name java:comp/env/jms/MyTopicConnectionFactory";
            } else {
                TestUtil.logTrace((String)"Getting TopicConnectionFactory MyTopicConnectionFactory");
                this.tcf = this.jmsObjects.getTopicConnectionFactory(TCKTOPICCONNECTIONFACTORY);
                eMsg = "Failed to lookup TopicConnectionFactory using name MyTopicConnectionFactory";
            }
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting Topic java:comp/env/jms/MY_TOPIC");
                this.testTopic = (Topic)this.jndiContext.lookup(TESTTOPICNAME);
                eMsg = "Failed to lookup Topic java:comp/env/jms/MY_TOPIC";
            } else {
                TestUtil.logTrace((String)"Getting Topic MY_TOPIC");
                this.testTopic = this.jmsObjects.getTopic(TCKTESTTOPICNAME);
                eMsg = "Failed to lookup Topic MY_TOPIC";
            }
            TestUtil.logTrace((String)"Creating TopicConnection");
            eMsg = "Failed to create topic connection using username, " + this.username + " password, " + this.password;
            this.tConnection = (TopicConnection)this.createNewConnection(this.ttype, this.username, this.password);
            TestUtil.logTrace((String)"Creating TopicSession");
            eMsg = "Failed to create topic session";
            this.tSession = this.tConnection.createTopicSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating subscriber");
            eMsg = "Failed to create subscriber for topic " + this.testTopic;
            this.tSubscriber = this.tSession.createSubscriber(this.testTopic);
            TestUtil.logTrace((String)"Creating publisher");
            eMsg = "Failed to create publisher for topic " + this.testTopic;
            this.tPublisher = this.tSession.createPublisher(this.testTopic);
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            throw e;
        }
    }

    private void createTopicSetup(String lookup) throws Exception {
        Object eMsg = "";
        try {
            TestUtil.logTrace((String)("Getting TopicConnectionFactory " + lookup));
            if (this.mode.equals("jakartaEE")) {
                this.tcf = (TopicConnectionFactory)this.jndiContext.lookup("java:comp/env/jms/" + lookup);
                eMsg = "Failed to lookup TopicConnectionFactory using name java:comp/env/jms/" + lookup;
            } else {
                this.tcf = this.jmsObjects.getTopicConnectionFactory(lookup);
                eMsg = "Failed to lookup TopicConnectionFactory using name " + lookup;
            }
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting Topic java:comp/env/jms/MY_TOPIC");
                this.testTopic = (Topic)this.jndiContext.lookup(TESTTOPICNAME);
                eMsg = "Failed to lookup Topic java:comp/env/jms/MY_TOPIC";
            } else {
                TestUtil.logTrace((String)"Getting Topic MY_TOPIC");
                this.testTopic = this.jmsObjects.getTopic(TCKTESTTOPICNAME);
                eMsg = "Failed to lookup Topic MY_TOPIC";
            }
            TestUtil.logTrace((String)"Creating TopicConnection");
            eMsg = "Failed to create topic connection using username, " + this.username + " password, " + this.password;
            this.tConnection = (TopicConnection)this.createNewConnection(this.ttype, this.username, this.password);
            TestUtil.logTrace((String)"Creating TopicSession");
            eMsg = "Failed to create topic session";
            this.tSession = this.tConnection.createTopicSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating subscriber");
            eMsg = "Failed to create subscriber for topic " + this.testTopic;
            this.tSubscriber = this.tSession.createSubscriber(this.testTopic);
            TestUtil.logTrace((String)"Creating publisher");
            eMsg = "Failed to create publisher for topic " + this.testTopic;
            this.tPublisher = this.tSession.createPublisher(this.testTopic);
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            throw e;
        }
    }

    private void createCommonQSetup() throws Exception {
        Object eMsg = "";
        try {
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting ConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
                this.cf = (ConnectionFactory)this.jndiContext.lookup(QUEUECONNECTIONFACTORY);
                eMsg = "Failed to lookup ConnectionFactory using name java:comp/env/jms/MyQueueConnectionFactory";
            } else {
                TestUtil.logTrace((String)"Getting ConnectionFactory MyQueueConnectionFactory");
                this.cf = this.jmsObjects.getQueueConnectionFactory(TCKQUEUECONNECTIONFACTORY);
                eMsg = "Failed to lookup ConnectionFactory using name MyQueueConnectionFactory";
            }
            this.qcf = (QueueConnectionFactory)this.cf;
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting Queue java:comp/env/jms/MY_QUEUE");
                this.testDestination = (Destination)this.jndiContext.lookup(TESTQUEUENAME);
                eMsg = "Failed to lookup Queue java:comp/env/jms/MY_QUEUE";
            } else {
                TestUtil.logTrace((String)"Getting Queue MY_QUEUE");
                this.testDestination = this.jmsObjects.getQueue(TCKTESTQUEUENAME);
                eMsg = "Failed to lookup Queue MY_QUEUE";
            }
            TestUtil.logTrace((String)"Creating Connection");
            eMsg = "Failed to create connection using username, " + this.username + " password, " + this.password;
            this.conn = this.cf.createConnection(this.username, this.password);
            TestUtil.logTrace((String)"Creating Session");
            eMsg = "Failed to create session";
            this.sess = this.conn.createSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating messageProducer");
            eMsg = "Failed to create producer for destination " + this.testDestination;
            this.sender = this.sess.createProducer(this.testDestination);
            TestUtil.logTrace((String)"Creating MessageConsumer");
            eMsg = "Failed to create consumer for destination " + this.testDestination;
            this.receiver = this.sess.createConsumer(this.testDestination);
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            throw e;
        }
    }

    private void createCommonTSetup() throws Exception {
        Object eMsg = "";
        try {
            if (this.mode.equals("jakartaEE")) {
                TestUtil.logTrace((String)"Getting ConnectionFactory java:comp/env/jms/MyTopicConnectionFactory");
                this.cf = (ConnectionFactory)this.jndiContext.lookup(TOPICCONNECTIONFACTORY);
                eMsg = "Failed to lookup ConnectionFactory using name java:comp/env/jms/MyTopicConnectionFactory";
            } else {
                TestUtil.logTrace((String)"Getting ConnectionFactory MyTopicConnectionFactory");
                this.cf = this.jmsObjects.getTopicConnectionFactory(TCKTOPICCONNECTIONFACTORY);
                eMsg = "Failed to lookup ConnectionFactory using name MyTopicConnectionFactory";
            }
            TestUtil.logTrace((String)"Getting Topic java:comp/env/jms/MY_TOPIC");
            if (this.mode.equals("jakartaEE")) {
                this.testDestination = (Destination)this.jndiContext.lookup(TESTTOPICNAME);
                eMsg = "Failed to lookup Topic java:comp/env/jms/MY_TOPIC";
            } else {
                this.testDestination = this.jmsObjects.getTopic(TCKTESTTOPICNAME);
                eMsg = "Failed to lookup Topic MY_TOPIC";
            }
            TestUtil.logTrace((String)"Creating Connection");
            eMsg = "Failed to create connection using username, " + this.username + " password, " + this.password;
            this.conn = this.cf.createConnection(this.username, this.password);
            TestUtil.logTrace((String)"Creating Session");
            eMsg = "Failed to create session";
            this.sess = this.conn.createSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating messageProducer");
            eMsg = "Failed to create producer for destination " + this.testDestination;
            this.sender = this.sess.createProducer(this.testDestination);
            TestUtil.logTrace((String)"Creating MessageConsumer");
            eMsg = "Failed to create consumer for destination " + this.testDestination;
            this.receiver = this.sess.createConsumer(this.testDestination);
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            throw e;
        }
    }

    private void createCommonTSetup(String lookup) throws Exception {
        Object eMsg = "";
        try {
            TestUtil.logTrace((String)("Getting ConnectionFactory " + lookup));
            if (this.mode.equals("jakartaEE")) {
                this.cf = (ConnectionFactory)this.jndiContext.lookup("java:comp/env/jms/" + lookup);
                eMsg = "Failed to lookup ConnectionFactory using name java:comp/env/jms/" + lookup;
            } else {
                this.cf = this.jmsObjects.getTopicConnectionFactory(lookup);
                eMsg = "Failed to lookup ConnectionFactory using name " + lookup;
            }
            TestUtil.logTrace((String)"Getting Topic java:comp/env/jms/MY_TOPIC");
            if (this.mode.equals("jakartaEE")) {
                this.testDestination = (Destination)this.jndiContext.lookup(TESTTOPICNAME);
                eMsg = "Failed to lookup Topic java:comp/env/jms/MY_TOPIC";
            } else {
                this.testDestination = this.jmsObjects.getTopic(TCKTESTTOPICNAME);
                eMsg = "Failed to lookup Topic MY_TOPIC";
            }
            TestUtil.logTrace((String)"Creating Connection");
            eMsg = "Failed to create connection using username, " + this.username + " password, " + this.password;
            this.conn = this.cf.createConnection(this.username, this.password);
            TestUtil.logTrace((String)"Creating Session");
            eMsg = "Failed to create session";
            this.sess = this.conn.createSession(this.transacted, 1);
            TestUtil.logTrace((String)"Creating messageProducer");
            eMsg = "Failed to create producer for destination " + this.testDestination;
            this.sender = this.sess.createProducer(this.testDestination);
            TestUtil.logTrace((String)"Creating MessageConsumer");
            eMsg = "Failed to create consumer for destination " + this.testDestination;
            this.receiver = this.sess.createConsumer(this.testDestination);
        }
        catch (Exception e) {
            TestUtil.logErr((String)((String)eMsg + "due to "), (Throwable)e);
            throw e;
        }
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        return this.cf;
    }

    public Connection getDefaultConnection() throws Exception {
        return this.conn;
    }

    public Session getDefaultSession() throws Exception {
        return this.sess;
    }

    public MessageProducer getDefaultProducer() throws Exception {
        return this.sender;
    }

    public MessageConsumer getDefaultConsumer() throws Exception {
        return this.receiver;
    }

    public Destination getDefaultDestination() throws Exception {
        return this.testDestination;
    }

    public Topic createNewTopic(String topicName) throws Exception {
        Topic testT = null;
        testT = this.mode.equals("jakartaEE") ? (Topic)this.jndiContext.lookup("java:comp/env/jms/" + topicName) : this.jmsObjects.getTopic(topicName);
        return testT;
    }

    public Queue createNewQueue(String queueName) throws Exception {
        Queue testQ = null;
        testQ = this.mode.equals("jakartaEE") ? (Queue)this.jndiContext.lookup("java:comp/env/jms/" + queueName) : this.jmsObjects.getQueue(queueName);
        return testQ;
    }

    public void closeAllResources() throws Exception {
        try {
            if (this.qSession != null) {
                this.qSession.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.qSender != null) {
                this.qSender.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.qReceiver != null) {
                this.qReceiver.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.qSession = null;
        this.qReceiver = null;
        this.qSender = null;
        try {
            if (this.tSession != null) {
                this.tSession.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.tPublisher != null) {
                this.tPublisher.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.tSubscriber != null) {
                this.tSubscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.tSession = null;
        this.tSubscriber = null;
        this.tPublisher = null;
        try {
            if (this.sess != null) {
                this.sess.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.sender != null) {
                this.sender.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.receiver != null) {
                this.receiver.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.sess = null;
        this.receiver = null;
        this.sender = null;
    }

    public void closeAllConnections(ArrayList connections) throws Exception {
        try {
            this.closeDefaultConnections();
            if (connections != null && !connections.isEmpty()) {
                for (int i = 0; i < connections.size(); ++i) {
                    ((Connection)connections.get(i)).close();
                    TestUtil.logTrace((String)"Closing non default connection");
                }
            }
        }
        catch (JMSException e) {
            TestUtil.logErr((String)"Problem closing connections", (Throwable)e);
        }
    }

    public void closeDefaultConnections() throws Exception {
        try {
            if (this.conn != null) {
                TestUtil.logTrace((String)"JmstTool: Closing default Connection");
                this.conn.close();
            }
            if (this.qConnection != null) {
                TestUtil.logTrace((String)"JmstTool: Closing default QueueConnection");
                this.qConnection.close();
            }
            if (this.tConnection != null) {
                TestUtil.logTrace((String)"JmsTool: Closing default TopicConnection");
                this.tConnection.close();
            }
        }
        catch (JMSException e) {
            TestUtil.logErr((String)"Problem closing connections", (Throwable)e);
        }
    }

    public QueueConnectionFactory getQueueConnectionFactory() {
        return this.qcf;
    }

    public QueueConnection getDefaultQueueConnection() {
        return this.qConnection;
    }

    public QueueSession getDefaultQueueSession() {
        return this.qSession;
    }

    public QueueReceiver getDefaultQueueReceiver() {
        return this.qReceiver;
    }

    public QueueSender getDefaultQueueSender() {
        return this.qSender;
    }

    public Queue getDefaultQueue() {
        return this.testQueue;
    }

    public Destination getQueueDestination(String lookup) throws Exception {
        Object dest = null;
        dest = this.mode.equals("jakartaEE") ? (Destination)this.jndiContext.lookup("java:comp/env/jms/" + lookup) : this.jmsObjects.getQueue(lookup);
        return dest;
    }

    public TopicConnectionFactory getTopicConnectionFactory() {
        return this.tcf;
    }

    public TopicConnection getDefaultTopicConnection() {
        return this.tConnection;
    }

    public TopicSession getDefaultTopicSession() {
        return this.tSession;
    }

    public TopicSubscriber getDefaultTopicSubscriber() {
        return this.tSubscriber;
    }

    public TopicPublisher getDefaultTopicPublisher() {
        return this.tPublisher;
    }

    public Topic getDefaultTopic() {
        return this.testTopic;
    }

    public Destination getTopicDestination(String lookup) throws Exception {
        Object dest = null;
        dest = this.mode.equals("jakartaEE") ? (Destination)this.jndiContext.lookup("java:comp/env/jms/" + lookup) : this.jmsObjects.getTopic(lookup);
        return dest;
    }

    public void doClientQueueTestCleanup(ArrayList connections, ArrayList queues) {
        try {
            this.closeAllConnections(connections);
            this.flushQueue(queues);
            if (queues != null) {
                queues.clear();
            }
            if (connections != null) {
                connections.clear();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDestination() throws Exception {
        Connection cC = null;
        MessageConsumer receiver = null;
        MessageProducer sender = null;
        Session sess = null;
        ObjectMessage msg = null;
        int priority = 0;
        int numMsgsFlushed = 0;
        try {
            if (this.conn != null) {
                TestUtil.logTrace((String)"Closing default connection in flushDestination()");
                try {
                    this.conn.close();
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Error closing default connection", (Throwable)ex);
                }
            }
            TestUtil.logTrace((String)"Create new Connection,Session,MessageProducer,MessageConsumer to flush Destination");
            cC = this.createNewConnection(this.ttype, this.username, this.password);
            sess = cC.createSession(false, 1);
            cC.start();
            sender = sess.createProducer(this.testDestination);
            receiver = sess.createConsumer(this.testDestination);
            msg = sess.createObjectMessage();
            msg.setObject((Serializable)((Object)"Flush Destination"));
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "flushDestination");
            TestUtil.logTrace((String)"Send low priority message to Destination to signal the last message");
            sender.send((Message)msg, 2, priority, 0L);
            TestUtil.logTrace((String)"Now flush the Destination");
            Message rmsg = receiver.receive(5000L);
            while (rmsg != null) {
                String tname = rmsg.getStringProperty("COM_SUN_JMS_TESTNAME");
                if (tname != null && tname.equals("flushDestination")) {
                    rmsg = receiver.receiveNoWait();
                    if (rmsg != null) {
                        ++numMsgsFlushed;
                    }
                } else {
                    ++numMsgsFlushed;
                }
                rmsg = receiver.receive(1000L);
            }
            if (numMsgsFlushed > 0) {
                TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
            } else {
                TestUtil.logTrace((String)"No messages to flush");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error attempting to flush Destination: " + e.toString()));
        }
        finally {
            try {
                cC.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error closing Connection in flushDestination()" + e.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue(ArrayList qToFlush) throws Exception {
        QueueConnection qc = null;
        QueueReceiver qr = null;
        QueueSession qs = null;
        Object qsndr = null;
        Object msg = null;
        Enumeration msgs = null;
        boolean priority = false;
        int numMsgsFlushed = 0;
        int numMsgs = 0;
        try {
            if (this.getDefaultQueue() != null) {
                qToFlush.add(this.getDefaultQueue());
            }
            TestUtil.logTrace((String)"Create new QueueConnection,QueueSession to flush Queue");
            qc = (QueueConnection)this.createNewConnection(0, this.username, this.password);
            qs = qc.createQueueSession(false, 1);
            qc.start();
            for (int i = 0; i < qToFlush.size(); ++i) {
                TestUtil.logTrace((String)"Create QueueBrowser to count number of messages left on Queue");
                QueueBrowser qBrowser = qs.createBrowser((Queue)qToFlush.get(i));
                msgs = qBrowser.getEnumeration();
                while (msgs.hasMoreElements()) {
                    msgs.nextElement();
                    ++numMsgs;
                }
                if (numMsgs == 0) {
                    TestUtil.logTrace((String)("No Messages left on Queue " + ((Queue)qToFlush.get(i)).getQueueName()));
                    continue;
                }
                TestUtil.logTrace((String)(numMsgs + " Messages left on Queue " + ((Queue)qToFlush.get(i)).getQueueName()));
                TestUtil.logTrace((String)"Create new QueueReceiver to flush messages in Queue");
                qr = qs.createReceiver((Queue)qToFlush.get(i));
                TestUtil.logTrace((String)"Now flush the Queue");
                Message rmsg = qr.receive(5000L);
                while (rmsg != null) {
                    ++numMsgsFlushed;
                    rmsg = qr.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = qr.receive(1000L);
                }
                if (numMsgsFlushed <= 0) continue;
                TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error attempting to flush Queue: " + e.toString()));
        }
        finally {
            try {
                qc.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error closing QueueConnection in flushQueue(Array)" + e.toString()));
            }
        }
    }

    public void flushQueue() throws Exception {
        int numMsgsFlushed = 0;
        int numMsgs = 0;
        Enumeration msgs = null;
        try {
            TestUtil.logTrace((String)"Create QueueBrowser to count number of messages left on Queue");
            QueueBrowser qBrowser = this.getDefaultQueueSession().createBrowser(this.getDefaultQueue());
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            if (numMsgs == 0) {
                TestUtil.logTrace((String)("No Messages left on Queue " + this.getDefaultQueue().getQueueName()));
            } else {
                TestUtil.logTrace((String)(numMsgs + " Messages left on Queue " + this.getDefaultQueue().getQueueName()));
                if (this.getDefaultQueueReceiver() != null) {
                    Message msg = this.getDefaultQueueReceiver().receive(5000L);
                    while (msg != null) {
                        ++numMsgsFlushed;
                        msg = this.getDefaultQueueReceiver().receiveNoWait();
                        if (msg != null) continue;
                        msg = this.getDefaultQueueReceiver().receive(1000L);
                    }
                    if (numMsgsFlushed > 0) {
                        TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
                    }
                    if (numMsgsFlushed > 0 && this.getDefaultQueueSession().getTransacted()) {
                        this.getDefaultQueueSession().commit();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection createNewConnection(int type, String username, String password) throws Exception {
        QueueConnection qC = null;
        TopicConnection tC = null;
        if (type == 0 || type == 2) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                qC = this.qcf.createQueueConnection();
                return qC;
            }
            qC = this.qcf.createQueueConnection(username, password);
            return qC;
        }
        if (type == 1 || type == 3) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                tC = this.tcf.createTopicConnection();
                return tC;
            }
            tC = this.tcf.createTopicConnection(username, password);
            return tC;
        }
        if (type == 4 || type == 5) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                tC = this.tcf.createTopicConnection();
                return tC;
            }
            tC = this.tcf.createTopicConnection(username, password);
            return tC;
        }
        if (type == 13 || type == 14 || type == 15 || type == 16) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                this.conn = this.cf.createConnection();
                return this.conn;
            }
            this.conn = this.cf.createConnection(username, password);
            return this.conn;
        }
        throw new Exception("Failed to create new Connection");
    }

    public Connection getNewConnection(int type, String username, String password) throws Exception {
        QueueConnection qC = null;
        Connection cC = null;
        if (type == 0 || type == 2) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                qC = this.qcf.createQueueConnection();
                return qC;
            }
            qC = this.qcf.createQueueConnection(username, password);
            return qC;
        }
        if (type == 13) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                cC = this.cf.createConnection();
                return cC;
            }
            cC = this.cf.createConnection(username, password);
            return cC;
        }
        throw new Exception("Failed to get new Connection");
    }

    public Connection getNewConnection(int type, String username, String password, String lookup) throws Exception {
        TopicConnection tC = null;
        Connection cC = null;
        if (type == 1 || type == 3) {
            this.tcf2 = this.mode.equals("jakartaEE") ? (TopicConnectionFactory)this.jndiContext.lookup("java:comp/env/jms/" + lookup) : this.jmsObjects.getTopicConnectionFactory(lookup);
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                tC = this.tcf2.createTopicConnection();
                return tC;
            }
            tC = this.tcf2.createTopicConnection(username, password);
            return tC;
        }
        if (type == 4 || type == 5) {
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                tC = this.tcf.createTopicConnection();
                return tC;
            }
            tC = this.tcf.createTopicConnection(username, password);
            return tC;
        }
        if (type == 14 || type == 16) {
            this.cf2 = this.mode.equals("jakartaEE") ? (TopicConnectionFactory)this.jndiContext.lookup("java:comp/env/jms/" + lookup) : this.jmsObjects.getTopicConnectionFactory(lookup);
            if (username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT)) {
                cC = this.cf2.createConnection();
                return cC;
            }
            cC = this.cf2.createConnection(username, password);
            return cC;
        }
        throw new Exception("Failed to get new Connection");
    }

    public Connection getNewConnection(int type) throws Exception {
        return this.getNewConnection(type, JMSDEFAULT, JMSDEFAULT);
    }

    public int getType() {
        return this.ttype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDestinationJMSContext() throws Exception {
        JMSConsumer consumer = null;
        JMSContext context = null;
        int numMsgsFlushed = 0;
        try {
            if (this.getDefaultConnection() != null) {
                TestUtil.logTrace((String)"Closing default connection in flushDestinationJMSContext()");
                try {
                    this.getDefaultConnection().close();
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Error closing default connection", (Throwable)ex);
                }
            }
            TestUtil.logTrace((String)"Create new JMSContext and JMSConsumer to flush Destination");
            context = this.createNewJMSContext(this.ttype, this.username, this.password);
            consumer = context.createConsumer(this.testDestination);
            TestUtil.logTrace((String)"Now flush the Destination");
            Message rmsg = consumer.receive(5000L);
            while (rmsg != null) {
                ++numMsgsFlushed;
                rmsg = consumer.receiveNoWait();
                if (rmsg != null) continue;
                rmsg = consumer.receive(1000L);
            }
            if (numMsgsFlushed > 0) {
                TestUtil.logTrace((String)("Flushed " + numMsgsFlushed + " messages"));
            } else {
                TestUtil.logTrace((String)"No messages to flush");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error attempting to flush Destination: " + e.toString()));
        }
        finally {
            try {
                consumer.close();
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    private JMSContext createNewJMSContext(int type, String username, String password) throws Exception {
        JMSContext context = null;
        if (type == 0 || type == 2) {
            context = username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT) ? this.qcf.createContext() : this.qcf.createContext(username, password);
        } else if (type == 1 || type == 3 || type == 4 || type == 5) {
            context = username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT) ? this.tcf.createContext() : this.tcf.createContext(username, password);
        } else if (type == 13 || type == 14 || type == 15 || type == 16) {
            context = username.equals(JMSDEFAULT) || password.equals(JMSDEFAULT) ? this.cf.createContext() : this.cf.createContext(username, password);
        } else {
            throw new Exception("Failed to create new JMSContext");
        }
        return context;
    }
}

