/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.messageProducer;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;

public class MessageProducerTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.messageProducer.MessageProducerTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;

    public static void main(String[] args) {
        MessageProducerTests theTests = new MessageProducerTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        if (this.tool != null) {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    TestUtil.logTrace((String)"Closing default Connection");
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error closing Connection in cleanup: ", (Throwable)e);
            }
        }
    }

    private void flushTheQueue() throws EETest.Fault {
        try {
            if (this.tool != null && this.tool.getDefaultConnection() != null) {
                this.cleanup();
            }
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            TestUtil.logTrace((String)"Closing default Connection");
            this.tool.getDefaultConnection().close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error closing connection and creating JmsTool: ", (Throwable)e);
        }
        finally {
            try {
                this.tool.flushDestination();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flush Destination: ", (Throwable)e);
            }
        }
    }

    public void sendQueueTest1() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest1";
            String testMessage = "Just a test from sendQueueTest1";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.tool.getDefaultConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flushing Queue", (Throwable)e);
            }
        }
    }

    public void sendQueueTest2() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest2";
            String testMessage = "Just a test from sendQueueTest2";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.tool.getDefaultConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent, 1, 3, 0L);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                this.logErr("didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                this.logErr("didn't get the right message.");
                this.logErr("text =" + messageReceived.getText());
                this.logErr("DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                this.logErr("Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new EETest.Fault(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flushing Queue", (Throwable)e);
            }
        }
    }

    public void sendQueueTest3() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest3";
            String testMessage = "Just a test from sendQueueTest3";
            boolean pass = true;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultConnection().start();
            if (!((Queue)this.tool.getDefaultProducer().getDestination()).getQueueName().equals(((Queue)this.tool.getDefaultDestination()).getQueueName())) {
                pass = false;
                this.logErr("getDestination test failed: " + ((Queue)this.tool.getDefaultProducer().getDestination()).getQueueName());
            }
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent, 1, 3, 0L);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                this.logErr("didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                this.logErr("didn't get the right message.");
                this.logErr("text =" + messageReceived.getText());
                this.logErr("DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                this.logErr("Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new EETest.Fault(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error flushing Queue", (Throwable)e);
            }
        }
    }

    public void sendTopicTest4() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest4";
            String testMessage = "Just a test from sendTopicTest4";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.tool.getDefaultConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void sendTopicTest5() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest5";
            String testMessage = "Just a test from sendTopicTest5";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.tool.getDefaultConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent, 1, 3, 0L);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                this.logErr("didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                this.logErr("didn't get the right message.");
                this.logErr("text =" + messageReceived.getText());
                this.logErr("DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                this.logErr("Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new EETest.Fault(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void sendTopicTest6() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest6";
            String testMessage = "Just a test from sendTopicTest6";
            boolean pass = true;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultConnection().start();
            if (!((Topic)this.tool.getDefaultProducer().getDestination()).getTopicName().equals(((Topic)this.tool.getDefaultDestination()).getTopicName())) {
                pass = false;
                this.logErr("getDestination test failed: " + ((Topic)this.tool.getDefaultProducer().getDestination()).getTopicName());
            }
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logMsg("Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent, 1, 3, 0L);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                this.logErr("didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                this.logErr("didn't get the right message.");
                this.logErr("text =" + messageReceived.getText());
                this.logErr("DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                this.logErr("Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new EETest.Fault(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }
}

