/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.bmp.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestLocal;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestLocalHome;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestRoleRefLocal;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestRoleRefLocalHome;
import com.sun.ts.tests.ejb.ee.sec.bmp.util.DBSupport2;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.sql.SQLException;
import java.util.Properties;

public class lTestEJB
implements EntityBean {
    private static final String ejb1name = "java:comp/env/ejb/SecTestLocal";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRefLocal";
    private SecTestLocalHome ejb1home = null;
    private SecTestLocal ejb1ref = null;
    private SecTestRoleRefLocalHome ejb2home = null;
    private SecTestRoleRefLocal ejb2ref = null;
    private EntityContext ectx = null;
    private static final String user1 = "user1";
    private static final String password1 = "password1";
    private String ctsuser = null;
    private String ctspassword = null;
    private TSNamingContext nctx = null;
    private boolean newTable = true;
    private float cofPrice = 0.0f;

    public void TestEJB() throws CreateException {
        TestUtil.logTrace((String)"TestEJB ejbCreate OK!");
    }

    public Integer ejbCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        DBSupport2 db = null;
        try {
            TestUtil.init((Properties)p);
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            TestUtil.logMsg((String)"Initialize DBSupport2 in ejbCreate");
            db = new DBSupport2(this.ectx);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            if (newTable) {
                db.tableInit();
            }
            db.createNewRow(cofID, cofPrice, cofName);
        }
        catch (RemoteLoggingInitException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new CreateException(re.getMessage());
        }
        catch (SQLException se) {
            TestUtil.logErr((String)"SQL Exception in create: ", (Throwable)se);
            throw new CreateException("SQL Exception in create" + se.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Unable to initialize DBSupport2");
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
        return new Integer(cofID);
    }

    public void ejbRemove() throws RemoveException, EJBException {
        TestUtil.logTrace((String)"ejbRemove");
        DBSupport2 db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport2");
            db = new DBSupport2(this.ectx);
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            db.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new RemoveException("SQL Exception in remove");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("Unable to initialize DBSupport2");
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        DBSupport2 db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport2");
            db = new DBSupport2(this.ectx);
            TestUtil.logMsg((String)"Get DB Connection");
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            boolean foundKey = db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Unable to obtain naming context");
            }
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        DBSupport2 db = null;
        try {
            TestUtil.logMsg((String)"Initialize DBSupport2");
            db = new DBSupport2(this.ectx);
            TestUtil.logMsg((String)"Get DB Connection");
            this.ctsuser = TestUtil.getProperty((String)user1);
            this.ctspassword = TestUtil.getProperty((String)password1);
            db.getDBConnection(this.ctsuser, this.ctspassword);
            boolean foundKey = db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Unable to obtain naming context");
            }
        }
        finally {
            try {
                db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)("SQL Exception in create when close DBConnection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void ejbPostCreate(Properties p, boolean newTable, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"In ejbPostCreate !!");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void setEntityContext(EntityContext sc) {
        this.ectx = sc;
    }

    private void initSetup() {
        try {
            this.nctx = new TSNamingContext();
            this.ejb1home = (SecTestLocalHome)this.nctx.lookup(ejb1name);
            this.ejb2home = (SecTestRoleRefLocalHome)this.nctx.lookup(ejb2name);
        }
        catch (Exception ne) {
            TestUtil.logErr((String)("Exception ... " + ne), (Throwable)ne);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean IsCallerB1(String caller) {
        String name = this.ectx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    public boolean IsCallerB2(String caller, Properties props) {
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.IsCaller(caller);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean InRole(String role, Properties props) {
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbNotAuthz(Properties props) {
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected jakarta.ejb.EJBException");
            this.ejb1ref.remove();
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught jakarta.ejb.EJBException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    private void cleanup(SecTestLocal ejbref) {
        if (ejbref != null) {
            try {
                ejbref.remove();
                ejbref = null;
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Cannot remove the bean: ", (Throwable)ex);
            }
        } else {
            TestUtil.logMsg((String)"ejbref == null");
        }
    }

    public boolean EjbIsAuthz(Properties props) {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean EjbSecRoleRef(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRef1(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRefScope(String role, Properties props) {
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
            this.ejb2ref = this.ejb2home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            this.ejb2ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2, Properties props) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            this.ejb1ref.remove();
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            this.ejb1ref.remove();
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    public boolean checktest1(Properties props) {
        TestUtil.logMsg((String)"Starting unchecked test1");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.checktest1();
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"checktest1 failed with Exception: ", (Throwable)e);
            return false;
        }
    }

    public boolean excludetest1(Properties props) {
        TestUtil.logMsg((String)"Starting exclude test1");
        this.initSetup();
        try {
            this.ejb1ref = this.ejb1home.create(props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.excludetest1();
            this.ejb1ref.remove();
            return false;
        }
        catch (EJBException ex) {
            TestUtil.logMsg((String)"Got expected exception.");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"excludetest1 failed with Exception: ", (Throwable)e);
            return false;
        }
    }
}

