/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.callbacklistener;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.callbacklistener.OverridenCallBack;
import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void postLoad() throws EETest.Fault {
        boolean pass3 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        TestUtil.logTrace((String)("persisted entity" + entity));
        try {
            pass3 = this.checkLoadCallBacks();
            if (!pass3) {
                throw new EETest.Fault("Test failed while testing postLoad method");
            }
            TestUtil.logTrace((String)"testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception thrown while testing postLoad" + e);
        }
    }

    public void preAndPostPersist() throws EETest.Fault {
        boolean pass1 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        TestUtil.logTrace((String)("persisted entity" + entity));
        try {
            pass1 = this.checkPersistCallBacks();
            if (!pass1) {
                throw new EETest.Fault("Test failed while testing prepersist and postpersist methods");
            }
            TestUtil.logTrace((String)"testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception thrown while testing preAndPostPersist" + e);
        }
    }

    public void preAndPostRemove() throws EETest.Fault {
        boolean pass2 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
        TestUtil.logTrace((String)("persisted entity" + entity));
        try {
            pass2 = this.checkRemoveCallBacks();
            if (!pass2) {
                throw new EETest.Fault("Test failed while testing preremove and postremove methods");
            }
            TestUtil.logTrace((String)"testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception thrown while testing preAndPostRemove" + e);
        }
    }

    private boolean checkPersistCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersistFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws EETest.Fault {
        String thisTestId = callBackName;
        boolean pass = false;
        int count = CallBackCounts.getCount((String)callBackName);
        if (count == expectedCount) {
            TestUtil.logTrace((String)("test passed in test method" + thisTestId));
            pass = true;
        } else {
            TestUtil.logErr((String)("test failed in test method" + thisTestId));
            TestUtil.logTrace((String)("in CallBackName =" + callBackName));
            TestUtil.logTrace((String)("in expectedCount =" + expectedCount));
            TestUtil.logTrace((String)("in ActualCount =" + count));
        }
        return pass;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

