/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queuetests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class QueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.queuetests.QueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    public static void main(String[] args) {
        QueueTests theTests = new QueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(10);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Cleanup: Closing Queue Connections");
            this.tool.doClientQueueTestCleanup(this.connections, this.queues);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"An error occurred while cleaning", (Throwable)e);
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void emptyMsgsQueueTest() throws EETest.Fault {
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Send generic Message to Queue.");
            Message msg = this.tool.getDefaultQueueSession().createMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send(msg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            TestUtil.logMsg((String)"Send BytesMessage to Queue.");
            BytesMessage bMsg = this.tool.getDefaultQueueSession().createBytesMessage();
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)bMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            TestUtil.logMsg((String)"Send MapMessage to Queue.");
            MapMessage mMsg = this.tool.getDefaultQueueSession().createMapMessage();
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)mMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            TestUtil.logMsg((String)"Send ObjectMessage to Queue.");
            ObjectMessage oMsg = this.tool.getDefaultQueueSession().createObjectMessage();
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)oMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            TestUtil.logMsg((String)"Send SreamMessage to Queue.");
            StreamMessage sMsg = this.tool.getDefaultQueueSession().createStreamMessage();
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)sMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            TestUtil.logMsg((String)"Send TextMessage to Queue.");
            TextMessage tMsg = this.tool.getDefaultQueueSession().createTextMessage();
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)tMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("emptyMsgsQueueTest failed");
        }
    }

    public void autoAckQueueTest() throws EETest.Fault {
        try {
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckQueueTest");
            TestUtil.logTrace((String)"send two messages");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageReceived = this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("Did not receive message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                throw new EETest.Fault("Error: received second message first");
            }
            TestUtil.logTrace((String)"Message received. Call recover.");
            this.tool.getDefaultQueueSession().recover();
            messageReceived = this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("Did not receive second message as expected");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new EETest.Fault("Received original message again");
            }
            TestUtil.logMsg((String)"Did not receive message again - GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("autoAckQueueTest");
        }
    }

    public void simpleSendReceiveQueueTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveQueueTest");
            TestUtil.logMsg((String)"Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            TestUtil.logMsg((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            TestUtil.logMsg((String)("Message text: \"" + messageReceived.getText() + "\""));
            TestUtil.logMsg((String)"Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("simpleSendReceiveQueueTest failed");
        }
    }

    public void messageOrderQueueTest() throws EETest.Fault {
        try {
            TextMessage tempMsg;
            int i;
            String[] text = new String[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText(text[i]);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                TestUtil.logTrace((String)("Sent message: " + tempMsg.getText()));
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("cannot receive message");
                }
                TestUtil.logTrace((String)("Received message: " + tempMsg.getText()));
                if (tempMsg.getText().equals(text[i])) continue;
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
                TestUtil.logMsg((String)("Should have: " + text[i]));
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageOrderQueueTest failed");
        }
    }

    public void temporaryQueueNotConsumableTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logMsg((String)"Creating TemporaryQueue");
            TemporaryQueue tempQ = this.tool.getDefaultQueueSession().createTemporaryQueue();
            TestUtil.logMsg((String)"Creating new Connection");
            QueueConnection newQConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newQConn);
            TestUtil.logMsg((String)"Create new Session");
            QueueSession newQSess = newQConn.createQueueSession(false, 1);
            TestUtil.logMsg((String)"Create new sender for TemporaryQueue");
            QueueSender newQSender = newQSess.createSender((Queue)tempQ);
            TestUtil.logMsg((String)"Send message to TemporaryQueue");
            Message msg = this.tool.getDefaultQueueSession().createMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryQueueNotConsumableTest");
            newQSender.send(msg);
            TestUtil.logMsg((String)"Attempt to create receiver for TemporaryQueue from another Session");
            try {
                QueueReceiver newQReceiver = newQSess.createReceiver((Queue)tempQ);
                if (newQReceiver != null) {
                    TestUtil.logTrace((String)("newQReceiver=" + newQReceiver));
                }
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Received expected JMSException -- GOOD");
                passed = true;
            }
            TestUtil.logTrace((String)"Closing new QueueConnection");
            newQConn.close();
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("temporaryQueueNotConsumableTest failed");
        }
    }

    public void messageSelectorMsgRemainsOnQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logMsg((String)"Creating receiver with message selector");
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qSelectiveReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logTrace((String)"Sending two Messages");
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "messageSelectorMsgRemainsOnQueueTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            TestUtil.logTrace((String)"Receiving message with selective receiver");
            messageReceived = qSelectiveReceiver.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"Did not receive any message");
            } else if (!messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                TestUtil.logErr((String)"Received incorrect message");
            } else {
                TestUtil.logMsg((String)"Selective Receiver received correct message");
            }
            qSelectiveReceiver.close();
            QueueReceiver qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived = qRec.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                TestUtil.logErr((String)"Un-received message did not remain on queue");
            } else if (messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                TestUtil.logErr((String)"received incorrect message");
            } else {
                TestUtil.logMsg((String)"Corrected Message left on Queue is received");
            }
            if (!pass) {
                throw new EETest.Fault("messageSelectorMsgRemainsOnQueueTest Failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageSelectorMsgRemainsOnQueueTest failed");
        }
    }

    public void msgSelectorMsgHeaderQueueTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            TestUtil.logMsg((String)"Creating receiver with message selector");
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qSelectiveReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "JMSType = 'test_message'");
            this.tool.getDefaultQueueConnection().start();
            Message m = this.tool.getDefaultQueueSession().createMessage();
            m.setStringProperty("COM_SUN_JMS_TESTNAME", "msgSelectorMsgHeaderQueueTest");
            TestUtil.logTrace((String)"Sending message not matching selector");
            m.setJMSType("foo");
            m.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(m);
            TestUtil.logTrace((String)"Sending test message with header property JMSType");
            m.setJMSType("test_message");
            m.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(m);
            TestUtil.logMsg((String)"Attempt to receive 'good' message");
            Message msg1 = qSelectiveReceiver.receive(this.timeout);
            qSelectiveReceiver.close();
            if (msg1 == null) {
                pass = false;
                TestUtil.logErr((String)"Did not receive any message");
            } else if (msg1.getBooleanProperty("lastMessage")) {
                TestUtil.logMsg((String)"Received correct message -- GOOD");
            } else {
                pass = false;
                TestUtil.logErr((String)"Received message not matching header");
            }
            QueueReceiver qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            msg1 = qRec.receive(this.timeout);
            if (msg1 == null) {
                pass = false;
                TestUtil.logErr((String)"No message received.");
            } else if (!msg1.getBooleanProperty("lastMessage")) {
                TestUtil.logMsg((String)"Received correct message left");
            } else {
                pass = false;
                TestUtil.logErr((String)"Received incorrect message");
            }
            if (!pass) {
                throw new EETest.Fault("msgSelectorMsgHeaderQueueTest failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgSelectorMsgHeaderQueueTest failed");
        }
    }

    public void queueBrowserMsgsRemainOnQueueTest() throws EETest.Fault {
        try {
            TextMessage tempMsg = null;
            QueueReceiver lastMessageReceiver = null;
            QueueReceiver qRec = null;
            QueueBrowser qBrowser = null;
            Enumeration msgs = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            lastMessageReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "lastMessage = TRUE");
            this.tool.getDefaultQueueConnection().start();
            for (int i = 0; i <= 3; ++i) {
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                tempMsg.setText("message" + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueBrowserMsgsRemainOnQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                TestUtil.logTrace((String)("message " + i + " sent"));
            }
            tempMsg = (TextMessage)lastMessageReceiver.receive(this.timeout);
            if (tempMsg == null) {
                throw new EETest.Fault("Did not receive expected message");
            }
            TestUtil.logTrace((String)("Received last sent message, lastMessage=" + tempMsg.getBooleanProperty("lastMessage")));
            lastMessageReceiver.close();
            TestUtil.logTrace((String)"Creating QueueBrowser");
            qBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
            TestUtil.logMsg((String)"Checking for 3 messages with QueueBrowser");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                ++msgCount;
            }
            TestUtil.logTrace((String)("found " + msgCount + " messages total in browser"));
            if (msgCount != 3) {
                TestUtil.logMsg((String)"Warning: browser did not find all messages");
            }
            qBrowser.close();
            qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            TestUtil.logMsg((String)"Receive all remaining messages to verify still in queue");
            for (msgCount = 0; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)qRec.receive(this.timeout);
                if (tempMsg == null) {
                    throw new EETest.Fault("Message " + msgCount + " missing from queue");
                }
                TestUtil.logTrace((String)("received message: " + tempMsg.getText()));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueBrowserMsgsRemainOnQueueTest failed");
        }
    }

    public void inactiveClientReceiveQueueTest() throws EETest.Fault {
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText("message" + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveClientReceiveQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                TestUtil.logTrace((String)("message " + i + " sent"));
            }
            this.tool.getDefaultQueueSession().close();
            QueueSession qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            QueueReceiver qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("Did not receive all messages");
                }
                TestUtil.logTrace((String)("received message " + i));
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("inactiveClientReceiveQueueTest failed");
        }
    }

    public void msgProducerNullDestinationQueueTest() throws EETest.Fault {
        boolean pass = true;
        QueueSender qSender = null;
        Queue nullQ = null;
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logTrace((String)"Creating  1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("test creating a producer without specifying the destination");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgProducerNullDestinationQueueTest");
            TestUtil.logMsg((String)"Test createSender(null) - This is valid");
            try {
                qSender = this.tool.getDefaultQueueSession().createSender(nullQ);
                TestUtil.logTrace((String)"PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"Send a message");
            qSender.send(this.tool.getDefaultQueue(), (Message)messageSent);
            TestUtil.logTrace((String)"Receive a message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
            } else {
                TestUtil.logTrace((String)"Got message - OK");
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during msgProducerNullDestinationQueueTest tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgProducerNullDestinationQueueTest failed");
        }
    }

    public void multipleCloseQueueConnectionTest() throws EETest.Fault {
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            TestUtil.logTrace((String)"Call close on a connection ");
            this.tool.getDefaultQueueConnection().close();
            TestUtil.logTrace((String)"Call close on a connection a second time");
            this.tool.getDefaultQueueConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("multipleCloseQueueConnectionTest failed");
        }
    }

    public void messageOrderDeliveryModeQueueTest() throws EETest.Fault {
        try {
            TextMessage tempMsg;
            int i;
            String[] text = new String[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText(text[i]);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderDeliveryModeQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                TestUtil.logTrace((String)("Sent message: " + tempMsg.getText()));
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("cannot receive message");
                }
                TestUtil.logTrace((String)("Received message: " + tempMsg.getText()));
                if (tempMsg.getText().equals(text[i])) continue;
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
                TestUtil.logMsg((String)("Should have: " + text[i]));
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("messageOrderDeliveryModeQueueTest failed");
        }
    }

    public void tempQueueTests() throws EETest.Fault {
        boolean pass = true;
        String testName = "tempQueueTests";
        String message = "Just a test from tempQueueTests";
        TemporaryQueue tempQ = null;
        Connection newConn = null;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            TestUtil.logMsg((String)"Creating TemporaryQueue");
            tempQ = this.tool.getDefaultSession().createTemporaryQueue();
            TestUtil.logMsg((String)"Create new sender for TemporaryQueue");
            MessageProducer sender = this.tool.getDefaultSession().createProducer((Destination)tempQ);
            MessageConsumer receiver = this.tool.getDefaultSession().createConsumer((Destination)tempQ);
            TestUtil.logMsg((String)"Send message to TemporaryQueue");
            TextMessage msgSent = this.tool.getDefaultSession().createTextMessage();
            msgSent.setText(message);
            msgSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            sender.send((Message)msgSent);
            TextMessage msgReceived = (TextMessage)receiver.receive(this.timeout);
            if (msgReceived == null) {
                pass = false;
                TestUtil.logErr((String)"didnot receive message");
            } else if (!msgReceived.getText().equals(message)) {
                pass = false;
                TestUtil.logErr((String)("Received wrong message=" + msgReceived.getText()));
                TestUtil.logErr((String)("Should have: " + message));
            }
            try {
                tempQ.delete();
                pass = false;
                TestUtil.logErr((String)"Didn't throw expected JMSException calling TemporaryQueue.delete()");
            }
            catch (JMSException em) {
                TestUtil.logTrace((String)"Received expected JMSException: ");
            }
            receiver.close();
            try {
                tempQ.delete();
                TestUtil.logTrace((String)"Succesfully calling TemporaryQueue.delete() after closing Receiver");
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)"Received unexpected Exception: ", (Throwable)e);
            }
            tempQ = this.tool.getDefaultSession().createTemporaryQueue();
            newConn = this.tool.getNewConnection(13, this.user, this.password);
            this.connections.add(newConn);
            Session newSess = newConn.createSession(false, 1);
            TestUtil.logMsg((String)"Attempt to create MessageConsumer for TemporaryQueue from another Connection");
            try {
                MessageConsumer newReceiver = newSess.createConsumer((Destination)tempQ);
                if (newReceiver != null) {
                    TestUtil.logTrace((String)("newReceiver=" + newReceiver));
                }
                this.logTrace("FAIL: expected IllegalStateException");
                TestUtil.logErr((String)"Didn't throw expected JMSException calling Session.createConsumer(TemporaryQueue)");
            }
            catch (JMSException e) {
                TestUtil.logTrace((String)"Received expected JMSException from createConsumer.");
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }
}

