/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.wsi.utils;

import com.sun.ts.lib.harness.EETest;
import java.util.Properties;

public class PropertyUtils {
    public static String getProperty(Properties properties, String key) throws EETest.Fault {
        String value = properties.getProperty(key);
        if (value != null) {
            return value;
        }
        throw new EETest.Fault("Required property '" + key + "' not present.");
    }

    public static int getIntegerProperty(Properties properties, String key) throws EETest.Fault {
        String value = PropertyUtils.getProperty(properties, key);
        try {
            int i = Integer.parseInt(value);
            return i;
        }
        catch (NumberFormatException e) {
            throw new EETest.Fault("Property '" + key + "' value '" + value + "' is not a valid integer.", (Throwable)e);
        }
    }

    public static boolean getBooleanProperty(Properties properties, String key) throws EETest.Fault {
        String value = PropertyUtils.getProperty(properties, key);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new EETest.Fault("Property '" + key + "' value '" + value + "' is not a valid boolean.");
    }

    private PropertyUtils() {
    }
}

