/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.pluggability.jsonbprovidertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;

public class Client
extends ServiceEETest {
    private static final String MY_JSONBROVIDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbProvider";
    private static final String MY_JSONBBUILDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbBuilder";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonbProviderTest1() throws EETest.Fault {
        try {
            JsonbProvider provider = JsonbProvider.provider();
            String providerClass = provider.getClass().getName();
            this.logMsg("provider class=" + providerClass);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonbProviderTest1 Failed: ", e);
        }
    }

    public void jsonbProviderTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonbProvider provider = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS);
            String providerClass = provider.getClass().getName();
            this.logMsg("provider class=" + providerClass);
            if (providerClass.equals(MY_JSONBROVIDER_CLASS)) {
                this.logMsg("Current provider is my provider - expected.");
            } else {
                this.logErr("Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
                Iterator<JsonbProvider> it = loader.iterator();
                ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                this.logMsg("Providers: " + providers);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonbProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonbProviderTest2 Failed");
        }
    }

    public void jsonbProviderTest3() throws EETest.Fault {
        try {
            JsonbBuilder builder = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS).create();
            String providerClass = builder.getClass().getName();
            this.logMsg("jsonb builder class=" + providerClass);
            if (!providerClass.equals(MY_JSONBBUILDER_CLASS)) {
                this.logErr("Current jsonb builder is not my builder - unexpected.");
                throw new EETest.Fault("jsonbProviderTest3 Failed");
            }
            this.logMsg("Current jsonb builder is my builder - expected.");
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonbProviderTest3 Failed: ", e);
        }
    }
}

