/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.busiface;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.busiface.AnnotatedBusinessInterface1;
import com.sun.ts.tests.ejb30.common.busiface.AnnotatedBusinessInterface2;
import com.sun.ts.tests.ejb30.common.busiface.BusinessIF1;
import com.sun.ts.tests.ejb30.common.busiface.BusinessIF2;
import com.sun.ts.tests.ejb30.common.busiface.TestIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import java.rmi.RemoteException;
import java.util.Properties;

public abstract class ClientBase
extends EETest {
    protected Properties props;

    protected abstract BusinessIF1 getBean1();

    protected abstract BusinessIF2 getBean2();

    protected AnnotatedBusinessInterface1 getAnnotatedInterfaceBean1() {
        return null;
    }

    protected AnnotatedBusinessInterface2 getAnnotatedInterfaceBean2() {
        return null;
    }

    protected abstract TestIF getTestBean();

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
    }

    protected void remove() {
        if (this.getBean1() != null) {
            try {
                this.getBean1().remove();
                TLogger.log("bean1 removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove bean1.");
            }
        }
        if (this.getBean2() != null) {
            try {
                this.getBean2().remove2();
                TLogger.log("bean2 removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove bean2.");
            }
        }
        if (this.getAnnotatedInterfaceBean1() != null) {
            try {
                this.getAnnotatedInterfaceBean1().remove();
                TLogger.log("annotatedInterfaceBean1 removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("annotatedInterfaceBean1 to remove bean1.");
            }
        }
        if (this.getAnnotatedInterfaceBean2() != null) {
            try {
                this.getAnnotatedInterfaceBean2().remove();
                TLogger.log("annotatedInterfaceBean2 removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove annotatedInterfaceBean2.");
            }
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    protected void verifyRemoteSemantics(String[] s) throws EETest.Fault {
        if (s == null) {
            throw new EETest.Fault("Unexpected: String[] value is null");
        }
        if (!"value".equals(s[0])) {
            throw new EETest.Fault("Expected value: value, but got " + s[0]);
        }
        TLogger.log("Verified remote semantics");
    }

    protected void verifyLocalSemantics(String[] s) throws EETest.Fault {
        if (s == null) {
            throw new EETest.Fault("Unexpected: String[] value is null");
        }
        if (!"value-reset".equals(s[0])) {
            throw new EETest.Fault("Expected value: value-reset, but got " + s[0]);
        }
        TLogger.log("Verified local semantics");
    }

    public void multipleInterfacesTest1() throws EETest.Fault {
        String[] s = new String[]{"value"};
        boolean expected = true;
        boolean actual = false;
        try {
            actual = this.getBean1()._businessMethod1_(s);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        if (!actual) {
            throw new EETest.Fault("Expected true, actual " + actual);
        }
        this.verifyRemoteSemantics(s);
    }

    public void multipleInterfacesTest2() throws EETest.Fault {
        String[] s = new String[]{"value"};
        boolean expected = true;
        boolean actual = this.getBean2().businessMethod2(s);
        if (!actual) {
            throw new EETest.Fault("Expected true, actual " + actual);
        }
        this.verifyRemoteSemantics(s);
    }

    public void multipleInterfacesLocalTest1() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().multipleInterfacesLocalTest1(s);
        this.verifyLocalSemantics(result);
    }

    public void multipleInterfacesLocalTest2() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().multipleInterfacesLocalTest2(s);
        this.verifyLocalSemantics(result);
    }

    public void singleInterfaceLocalSerializableTest() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().singleInterfaceLocalSerializableTest(s);
        this.verifyLocalSemantics(result);
    }

    public void singleInterfaceLocalExternalizableTest() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().singleInterfaceLocalExternalizableTest(s);
        this.verifyLocalSemantics(result);
    }

    public void singleInterfaceLocalTimedObjectTest() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().singleInterfaceLocalTimedObjectTest(s);
        this.verifyLocalSemantics(result);
    }

    public void singleInterfaceLocalSessionSynchronizationTest() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().singleInterfaceLocalSessionSynchronizationTest(s);
        this.verifyLocalSemantics(result);
    }

    public void singleInterfaceLocalSessionBeanTest() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().singleInterfaceLocalSessionBeanTest(s);
        this.verifyLocalSemantics(result);
    }

    public void multipleAnnotatedInterfacesTest1() throws EETest.Fault {
        String[] s = new String[]{"value"};
        boolean expected = true;
        boolean actual = false;
        actual = this.getAnnotatedInterfaceBean1().annotatedBusinessInterfaceMethod(s);
        if (!actual) {
            throw new EETest.Fault("Expected true, actual " + actual);
        }
        this.verifyRemoteSemantics(s);
    }

    public void multipleAnnotatedInterfacesTest2() throws EETest.Fault {
        String[] s = new String[]{"value"};
        boolean expected = true;
        boolean actual = this.getAnnotatedInterfaceBean2().annotatedBusinessInterfaceMethod(s);
        if (!actual) {
            throw new EETest.Fault("Expected true, actual " + actual);
        }
        this.verifyRemoteSemantics(s);
    }

    public void multipleAnnotatedInterfacesLocalTest1() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().multipleAnnotatedInterfacesLocalTest1(s);
        this.verifyLocalSemantics(result);
    }

    public void multipleAnnotatedInterfacesLocalTest2() throws EETest.Fault {
        String[] s = new String[]{"value"};
        String[] result = this.getTestBean().multipleAnnotatedInterfacesLocalTest2(s);
        this.verifyLocalSemantics(result);
    }
}

