/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.unionexone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.unionexone.Uni1X1Person;
import com.sun.ts.tests.jpa.core.relationship.unionexone.Uni1X1Project;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uni1X1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin uni1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Uni1X1Project project = new Uni1X1Project(1L, "JavaEE", 500.0f);
            Uni1X1Person person = new Uni1X1Person(Long.valueOf(1L), "Duke");
            person.setProject(project);
            this.getEntityManager().persist((Object)person);
            TestUtil.logTrace((String)"persisted Person and Project");
            Uni1X1Person newPerson = (Uni1X1Person)this.getEntityManager().find(Uni1X1Person.class, (Object)1L);
            if (newPerson.getProject().getName().equals("JavaEE")) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("uni1X1Test1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1X1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1X1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

