/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn.DID2Dependent;
import com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn.DID2DependentId;
import com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn.DID2Employee;
import com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn.DID2EmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void didTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID2EmployeeId eId1 = new DID2EmployeeId("Java", "Duke");
            DID2EmployeeId eId2 = new DID2EmployeeId("C", "foo");
            DID2Employee employee1 = new DID2Employee(eId1);
            DID2Employee employee2 = new DID2Employee(eId2);
            DID2DependentId dId1 = new DID2DependentId("Obama", eId1);
            DID2DependentId dId2 = new DID2DependentId("Michelle", eId1);
            DID2DependentId dId3 = new DID2DependentId("John", eId2);
            DID2Dependent dep1 = new DID2Dependent(dId1, employee1);
            DID2Dependent dep2 = new DID2Dependent(dId2, employee1);
            DID2Dependent dep3 = new DID2Dependent(dId3, employee2);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            DID2Dependent newDependent = (DID2Dependent)this.getEntityManager().find(DID2Dependent.class, (Object)new DID2DependentId("Obama", new DID2EmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2Dependent d where d.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new EETest.Fault("DIDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

