/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.dao.coffee.variants;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DataSourceDAO;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPK;
import com.sun.ts.tests.common.dao.coffee.variants.CompoundPKCoffeeDAO;
import jakarta.ejb.CreateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CompoundPKDSCoffeeDAO
extends DataSourceDAO
implements CompoundPKCoffeeDAO {
    public static final String DEFAULT_TABLE_PREFIX = "COFFEE_COMPOUND_PK";
    protected static final String SQL_EXISTS = "select";
    protected static final String SQL_CREATE = "insert";
    protected static final String SQL_LOAD_PRICE = "select_price";
    protected static final String SQL_STORE_PRICE = "update_price";
    protected static final String SQL_DELETE = "delete";
    protected static final String SQL_DELETE_ALL = "delete_all";

    public CompoundPKDSCoffeeDAO(String sqlTablePrefix) throws DAOException {
        super(sqlTablePrefix);
    }

    public CompoundPKDSCoffeeDAO(String sqlTablePrefix, String user, String password) throws DAOException {
        super(sqlTablePrefix, user, password);
    }

    @Override
    public boolean exists(CompoundPK pkey) throws DAOException {
        boolean bl;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[CompoundPKDSCoffeeDAO] exists(" + pkey + ")"));
            pStmt = this.getStmt(SQL_EXISTS);
            pStmt.setInt(1, pkey.pmIDInteger);
            pStmt.setString(2, pkey.pmIDString);
            pStmt.setFloat(3, pkey.pmIDFloat.floatValue());
            result = pStmt.executeQuery();
            bl = result.next();
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in keyExists: ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return bl;
    }

    @Override
    public void create(CompoundPK id, String name, float price) throws CreateException, DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[CompoundPKDSCoffeeDAO] create {" + id + ", " + name + ", " + price + "}"));
            pStmt = this.getStmt(SQL_CREATE);
            pStmt.setInt(1, id.pmIDInteger);
            pStmt.setString(2, id.pmIDString);
            pStmt.setFloat(3, id.pmIDFloat.floatValue());
            pStmt.setString(4, name);
            pStmt.setFloat(5, price);
            TestUtil.logTrace((String)("[CompoundPKDSCoffeeDAO] Execute stmt" + pStmt));
            if (1 != pStmt.executeUpdate()) {
                throw new CreateException("DB INSERT failed");
            }
        }
        catch (SQLException e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new DAOException("SQLException in createNewRow", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
        TestUtil.logTrace((String)"[CompoundPKDSCoffeeDAO] New row created !");
    }

    @Override
    public float loadPrice(CompoundPK id) throws DAOException {
        float f;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[CompoundPKDSCoffeeDAO] loadPrice(" + id + ")"));
            pStmt = this.getStmt(SQL_LOAD_PRICE);
            pStmt.setInt(1, id.pmIDInteger);
            pStmt.setString(2, id.pmIDString);
            pStmt.setFloat(3, id.pmIDFloat.floatValue());
            result = pStmt.executeQuery();
            if (!result.next()) {
                throw new SQLException("No record for PK = " + id);
            }
            f = result.getFloat(1);
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in loadPrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return f;
    }

    @Override
    public void storePrice(CompoundPK id, float price) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[CompoundPKDSCoffeeDAO] storePrice {id=" + id + ", price=" + price + "}"));
            pStmt = this.getStmt(SQL_STORE_PRICE);
            pStmt.setFloat(1, price);
            pStmt.setInt(2, id.pmIDInteger);
            pStmt.setString(3, id.pmIDString);
            pStmt.setFloat(4, id.pmIDFloat.floatValue());
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("UPDATE failed in storePrice");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in storePrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
    }

    @Override
    public void delete(CompoundPK id) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)"[CompoundPKDSCoffeeDAO] delete()");
            pStmt = this.getStmt(SQL_DELETE);
            pStmt.setInt(1, id.pmIDInteger);
            pStmt.setString(2, id.pmIDString);
            pStmt.setFloat(3, id.pmIDFloat.floatValue());
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("DELETE failed in remove()");
            }
        }
        catch (SQLException e) {
            throw new DAOException("SQLException in remove(): ", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }
}

