/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.PrefixMap;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class SDIDeskView
extends DeskView {
    private static final int MENU_INSERT_POINT = 3;
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    private JFrame console;
    private JFrame[] frames;
    private boolean visible;
    private Tool selectedTool;
    private Listener listener = new Listener();

    SDIDeskView(Desktop desktop) {
        super(desktop);
        this.initFrames();
        this.uif.setDialogParent(this.console);
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    SDIDeskView(DeskView other) {
        this(other.getDesktop());
        Tool[] tools;
        for (Tool tool : tools = other.getTools()) {
            this.addTool(tool);
        }
        this.doCascade();
        this.setVisible(other.isVisible());
    }

    private static JFrame getFrameForTool(Tool t) {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, t);
    }

    @Override
    public void dispose() {
        for (JFrame frame1 : this.frames) {
            frame1.setVisible(false);
        }
        for (JFrame frame : this.frames) {
            frame.dispose();
        }
        super.dispose();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean v) {
        if (v != this.visible) {
            for (JFrame f : this.frames) {
                Window[] ww;
                f.setVisible(v);
                if (!v) continue;
                for (Window aWw : ww = f.getOwnedWindows()) {
                    aWw.toFront();
                }
            }
            this.visible = v;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.frames.length == 1;
    }

    @Override
    public Tool[] getTools() {
        Tool[] tools = new Tool[this.frames.length - 1];
        for (int i = 0; i < tools.length; ++i) {
            tools[i] = (Tool)this.frames[i + 1].getContentPane();
        }
        return tools;
    }

    @Override
    public void addTool(final Tool t) {
        DeskView view = t.getDeskView();
        if (view == this) {
            return;
        }
        ToolDialog[] tds = t.getToolDialogs();
        boolean[] vis = new boolean[tds.length];
        for (int i = 0; i < tds.length; ++i) {
            vis[i] = tds[i].isVisible();
        }
        if (view != null) {
            view.removeTool(t);
        }
        ToolAction closeAction = new ToolAction(this.uif, "sdi.file.close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SDIDeskView.this.removeTool(t);
                t.dispose();
            }
        };
        JFrame f = this.createFrame(this.listener, closeAction, "sdi.tool");
        f.setDefaultCloseOperation(0);
        this.addToolMenuItemsToFrameMenuBar(f, t);
        f.setTitle(this.uif.getI18NString("dt.title.tool.txt", (Object)t.getTitle()));
        f.setContentPane(t);
        f.pack();
        t.addObserver(this.listener);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                if (f.getContentPane() instanceof Tool) {
                    SDIDeskView.this.selectedTool = (Tool)f.getContentPane();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SDIDeskView.this.selectedTool = null;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                if (f.getContentPane() instanceof Tool) {
                    Tool t = (Tool)f.getContentPane();
                    if (SDIDeskView.this.getDesktop().isOKToClose(t, f)) {
                        f.dispose();
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                SDIDeskView.access$202(SDIDeskView.this, DynamicArray.remove(SDIDeskView.this.frames, f));
                if (f.getContentPane() instanceof Tool) {
                    Tool t = (Tool)f.getContentPane();
                    t.removeObserver(SDIDeskView.this.listener);
                    t.dispose();
                    f.getRootPane().removeAll();
                    if (t == SDIDeskView.this.selectedTool) {
                        SDIDeskView.this.selectedTool = null;
                    }
                }
            }
        });
        Dimension size = f.getSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        f.setLocation(ge.getCenterPoint().x - size.width / 2, ge.getCenterPoint().y - size.height / 2);
        f.setVisible(this.visible);
        this.frames = DynamicArray.append(this.frames, f);
        t.setDeskView(this);
        for (int i = 0; i < tds.length; ++i) {
            tds[i].initDialog(this, vis[i]);
        }
    }

    @Override
    public void removeTool(Tool t) {
        JFrame f = SDIDeskView.getFrameForTool(t);
        this.frames = DynamicArray.remove(this.frames, f);
        f.setVisible(false);
        this.removeToolMenuItemsFromFrameMenuBar(f, t);
        f.setContentPane(new Container());
        f.dispose();
        t.setDeskView(null);
    }

    @Override
    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    @Override
    public void setSelectedTool(Tool t) {
        JFrame f = SDIDeskView.getFrameForTool(t);
        if (f.getState() == 1) {
            f.setState(0);
        }
        f.setVisible(this.visible);
    }

    @Override
    public int getStyle() {
        return 2;
    }

    @Override
    public JFrame[] getFrames() {
        return this.frames;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        for (int i = 1; i < this.frames.length; ++i) {
            Rectangle r = this.frames[i].getBounds();
            bounds = bounds == null ? r : bounds.union(r);
        }
        return bounds == null ? SDIDeskView.getDefaultBounds() : bounds;
    }

    @Override
    public boolean isToolOwnerForDialog(Tool tool, Container dialog) {
        if (dialog == null) {
            return false;
        }
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tool);
        return dialog.getParent() == f;
    }

    @Override
    public Container createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds, int type) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tool);
        UIFactory uif = tool.uif;
        JDialog d = uif.createDialog(uiKey, f, title, body);
        if (menuBar != null) {
            d.setJMenuBar(menuBar);
        }
        if (bounds == null) {
            d.pack();
            d.pack();
            d.setLocationRelativeTo(f);
        } else {
            d.setBounds(bounds);
        }
        return d;
    }

    @Override
    protected void saveDesktop(Map<String, String> m) {
        SDIDeskView.saveBounds(this.console, new PrefixMap<String>(m, "dt.console"));
        this.saveTools(m);
    }

    @Override
    protected void restoreDesktop(Map<String, String> m) {
        SDIDeskView.restoreBounds(this.console, new PrefixMap<String>(m, "dt.console"));
        this.restoreTools(m);
    }

    @Override
    protected void saveTool(Map<String, String> m, Tool t) {
        super.saveTool(m, t);
        SDIDeskView.saveBounds(SDIDeskView.getFrameForTool(t), new PrefixMap<String>(m, "dt"));
    }

    @Override
    protected Tool restoreTool(Map<String, String> m, String name) throws DeskView.Fault, ToolManager.Fault {
        Tool t = super.restoreTool(m, name);
        SDIDeskView.restoreBounds(SDIDeskView.getFrameForTool(t), new PrefixMap<String>(m, "dt"));
        return t;
    }

    private void initFrames() {
        this.console = this.createFrame(this.listener, "sdi.console");
        this.console.setTitle(this.uif.getI18NString("dt.title.console"));
        this.console.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SDIDeskView.this.getDesktop().checkToolsAndExitIfOK(SDIDeskView.this.console);
            }
        });
        JLabel logo = new JLabel(this.getDesktop().getLogo());
        logo.setName("sdi.console");
        logo.setFocusable(false);
        logo.setOpaque(true);
        this.console.setContentPane(logo);
        this.console.pack();
        this.frames = new JFrame[]{this.console};
    }

    private void doCascade() {
        int offset = 30;
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 1; i < this.frames.length; ++i) {
            JFrame f = this.frames[i];
            Dimension fSize = f.getSize();
            maxWidth = Math.max(maxWidth, i * offset + fSize.width);
            maxHeight = Math.max(maxHeight, i * offset + fSize.height);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int offsetX = ge.getCenterPoint().x - maxWidth / 2;
        int offsetY = ge.getCenterPoint().y - maxHeight / 2;
        if (offsetX <= 0) {
            offsetX = offset;
        }
        if (offsetY <= 0) {
            offsetY = offset;
        }
        for (int i = 1; i < this.frames.length; ++i) {
            Window[] ww;
            JFrame f = this.frames[i];
            f.setLocation(offsetX + i * offset, offsetY + i * offset);
            f.toFront();
            for (Window aWw : ww = f.getOwnedWindows()) {
                aWw.toFront();
            }
        }
    }

    private void doTile() {
        int n = this.frames.length - 1;
        int cols = (int)Math.sqrt(n);
        int rows = (n + cols - 1) / cols;
        Dimension dSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension tSize = new Dimension(dSize.width / cols, dSize.height / rows);
        for (int i = 0; i < n; ++i) {
            JFrame f = this.frames[i + 1];
            int c = i % cols;
            int r = i / cols;
            f.setBounds(c * tSize.width, r * tSize.height, tSize.width, tSize.height);
        }
    }

    static /* synthetic */ JFrame[] access$202(SDIDeskView x0, JFrame[] x1) {
        x0.frames = x1;
        return x1;
    }

    private class Listener
    implements ActionListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(SDIDeskView.CASCADE)) {
                SDIDeskView.this.doCascade();
            } else if (cmd.equals(SDIDeskView.TILE)) {
                SDIDeskView.this.doTile();
            } else {
                JMenuItem mi = (JMenuItem)e.getSource();
                Object o = mi.getClientProperty(this);
                if (o instanceof Window) {
                    ((Window)o).toFront();
                } else if (o instanceof Tool) {
                    SDIDeskView.this.setSelectedTool((Tool)o);
                }
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Tool[] tools = SDIDeskView.this.getTools();
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
            JMenuItem tmi = SDIDeskView.this.uif.createMenuItem("dt.windows", SDIDeskView.TILE, this);
            tmi.setEnabled(tools.length > 0);
            m.add(tmi);
            JMenuItem cmi = SDIDeskView.this.uif.createMenuItem("dt.windows", SDIDeskView.CASCADE, this);
            cmi.setEnabled(tools.length > 0);
            m.add(cmi);
            m.addSeparator();
            int n = 0;
            for (Tool tool : tools) {
                this.addMenuItem(m, n++, tool.getTitle(), tool);
            }
            for (Container container : SDIDeskView.this.frames) {
                Window[] ownedWindows;
                for (Window w : ownedWindows = ((Window)container).getOwnedWindows()) {
                    if (!(w instanceof JDialog) || !w.isVisible()) continue;
                    this.addMenuItem(m, n++, ((JDialog)w).getTitle(), w);
                }
            }
            this.addMenuItem(m, n++, SDIDeskView.this.console.getTitle(), SDIDeskView.this.console);
        }

        private void addMenuItem(JMenu m, int n, String s, Object o) {
            JMenuItem mi = new JMenuItem(SDIDeskView.this.uif.getI18NString("dt.windows.toolX.mit", n, s));
            if (n < 10) {
                mi.setMnemonic(Character.forDigit(n, 10));
            }
            mi.addActionListener(this);
            mi.putClientProperty(this, o);
            m.add(mi);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void shortTitleChanged(Tool src, String newValue) {
        }

        @Override
        public void titleChanged(Tool src, String newValue) {
            JFrame f = SDIDeskView.getFrameForTool(src);
            f.setTitle(SDIDeskView.this.uif.getI18NString("dt.title.tool.txt", (Object)newValue));
        }

        @Override
        public void toolDisposed(Tool src) {
        }
    }
}

