/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.client.rxinvoker;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JdkLoggingFilter;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.client.rxinvoker.Resource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.client.rxinvoker.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 21L;
    protected long millis;
    protected int callbackResult = 0;
    protected Throwable callbackException = null;
    private static final String NONEXISTING_SITE = "somenonexisting.domain-site";
    static final String[] METHODS = new String[]{"DELETE", "GET", "OPTIONS"};
    static final String[] ENTITY_METHODS = new String[]{"PUT", "POST"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_jaxrs21_ee_client_rxinvoker_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/jaxrs21/ee/client/rxinvoker/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_ee_client_rxinvoker_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, TRACE.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void deleteTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        CompletableFuture<Response> future = rx.delete().toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.OK);
    }

    @Test
    public void deleteThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        CompletableFuture future = rx.delete().toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithStringClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        CompletableFuture<String> future = rx.delete(String.class).toCompletableFuture();
        this.checkFutureString(future, "delete");
    }

    @Test
    public void deleteWithResponseClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        CompletableFuture<Response> future = rx.delete(Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void deleteWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        CompletableFuture future = rx.delete(String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("deletenotok");
        CompletableFuture future = rx.delete(String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("deletenotok");
        CompletableFuture<Response> future = rx.delete(Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void deleteWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture<String> future = rx.delete(generic).toCompletableFuture();
        this.checkFutureString(future, "delete");
    }

    @Test
    public void deleteWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.delete(generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("delete");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.delete(generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("deletenotok");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.delete(generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void deleteWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("deletenotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.delete(generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        CompletableFuture<Response> future = rx.get().toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        CompletableFuture future = rx.get().toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithStringClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        CompletableFuture<String> future = rx.get(String.class).toCompletableFuture();
        this.checkFutureString(future, "get");
    }

    @Test
    public void getWithResponseClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        CompletableFuture<Response> future = rx.get(Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        CompletableFuture future = rx.get(String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("getnotok");
        CompletableFuture future = rx.get(String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("getnotok");
        CompletableFuture<Response> future = rx.get(Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture<String> future = rx.get(generic).toCompletableFuture();
        this.checkFutureString(future, "get");
    }

    @Test
    public void getWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.get(generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void getWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("get");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.get(generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("getnotok");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.get(generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void getWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("getnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.get(generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void headTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("head");
        CompletableFuture<Response> future = rx.head().toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void headThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("head");
        CompletableFuture future = rx.head().toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void methodTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletableFuture future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithStringClassTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<String> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, String.class).toCompletableFuture();
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithResponseClassTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, Response.class).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletableFuture future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, String.class).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletableFuture future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            future = rx.method(method, String.class).toCompletableFuture();
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            future = rx.method(method, Response.class).toCompletableFuture();
            this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture<String> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, generic).toCompletableFuture();
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = null;
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, generic).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletableFuture future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, generic).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletableFuture future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            future = rx.method(method, generic).toCompletableFuture();
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            future = rx.method(method, generic).toCompletableFuture();
            this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithEntityTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletableFuture future = null;
        for (String method : ENTITY_METHODS) {
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            future = rx.method(method, entity).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithStringClassWithEntityTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<String> future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, String.class).toCompletableFuture();
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithResponseClassWithEntityTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, Response.class).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletableFuture future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, String.class).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletableFuture future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, String.class).toCompletableFuture();
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithClassWithEntityThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, Response.class).toCompletableFuture();
            this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringWithEntityTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<String> future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, generic).toCompletableFuture();
            this.checkFutureString(future, method);
        }
    }

    @Test
    public void methodWithGenericTypeResponseWithEntityTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, generic).toCompletableFuture();
            this.checkFutureOkResponse(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = null;
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase());
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, generic).toCompletableFuture();
            this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletableFuture future = null;
        GenericType<String> generic = this.createGeneric(String.class);
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, generic).toCompletableFuture();
            this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
        }
    }

    @Test
    public void methodWithGenericTypeWithEntityThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletableFuture<Response> future = null;
        GenericType<Response> generic = this.createGeneric(Response.class);
        for (String method : ENTITY_METHODS) {
            CompletionStageRxInvoker rx = this.startRxInvokerForMethod(method.toLowerCase() + "notok");
            Entity entity = Entity.entity((Object)method, (MediaType)MediaType.WILDCARD_TYPE);
            future = rx.method(method, entity, generic).toCompletableFuture();
            this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void optionsTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        CompletableFuture<Response> future = rx.options().toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.OK);
    }

    @Test
    public void optionsThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        CompletableFuture future = rx.options().toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithStringClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        CompletableFuture<String> future = rx.options(String.class).toCompletableFuture();
        this.checkFutureString(future, "options");
    }

    @Test
    public void optionsWithResponseClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        CompletableFuture<Response> future = rx.options(Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void optionsWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        CompletableFuture future = rx.options(String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("optionsnotok");
        CompletableFuture future = rx.options(String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("optionsnotok");
        CompletableFuture<Response> future = rx.options(Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void optionsWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture<String> future = rx.options(generic).toCompletableFuture();
        this.checkFutureString(future, "options");
    }

    @Test
    public void optionsWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.options(generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("options");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.options(generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("optionsnotok");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.options(generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void optionsWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("optionsnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.options(generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture<Response> future = rx.post(entity).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture future = rx.post(entity).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithStringClassTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture<String> future = rx.post(entity, String.class).toCompletableFuture();
        this.checkFutureString(future, "post");
    }

    @Test
    public void postWithResponseClassTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture<Response> future = rx.post(entity, Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture future = rx.post(entity, String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("postnotok");
        CompletableFuture future = rx.post(entity, String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("postnotok");
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture<Response> future = rx.post(entity, Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture<String> future = rx.post(entity, generic).toCompletableFuture();
        this.checkFutureString(future, "post");
    }

    @Test
    public void postWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture<Response> future = rx.post(entity, generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void postWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        GenericType<String> generic = this.createGeneric(String.class);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("post");
        CompletableFuture future = rx.post(entity, generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        GenericType<String> generic = this.createGeneric(String.class);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("postnotok");
        CompletableFuture future = rx.post(entity, generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void postWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("postnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"post", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture<Response> future = rx.post(entity, generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture<Response> future = rx.put(entity).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletableFuture future = rx.put(entity).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithStringClassTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture<String> future = rx.put(entity, String.class).toCompletableFuture();
        this.checkFutureString(future, "put");
    }

    @Test
    public void putWithResponseClassTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture<Response> future = rx.put(entity, Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture future = rx.put(entity, String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("putnotok");
        CompletableFuture future = rx.put(entity, String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("putnotok");
        CompletableFuture<Response> future = rx.put(entity, Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture<String> future = rx.put(entity, generic).toCompletableFuture();
        this.checkFutureString(future, "put");
    }

    @Test
    public void putWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture<Response> future = rx.put(entity, generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void putWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("put");
        CompletableFuture future = rx.put(entity, generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("putnotok");
        CompletableFuture future = rx.put(entity, generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void putWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.entity((Object)"put", (MediaType)MediaType.WILDCARD_TYPE);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("putnotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.put(entity, generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture<Response> future = rx.trace().toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture future = rx.trace().toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithStringClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture<String> future = rx.trace(String.class).toCompletableFuture();
        this.checkFutureString(future, "trace");
    }

    @Test
    public void traceWithResponseClassTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture<Response> future = rx.trace(Response.class).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceWithClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture future = rx.trace(String.class).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("tracenotok");
        CompletableFuture future = rx.trace(String.class).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithClassThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("tracenotok");
        CompletableFuture<Response> future = rx.trace(Response.class).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = this.createGeneric(String.class);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture<String> future = rx.trace(generic).toCompletableFuture();
        this.checkFutureString(future, "trace");
    }

    @Test
    public void traceWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture<Response> future = rx.trace(generic).toCompletableFuture();
        this.checkFutureOkResponse(future);
    }

    @Test
    public void traceWithGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        this._hostname = NONEXISTING_SITE;
        GenericType<String> generic = this.createGeneric(String.class);
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("trace");
        CompletableFuture future = rx.trace(generic).toCompletableFuture();
        this.assertExceptionWithProcessingExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithGenericTypeThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("tracenotok");
        GenericType<String> generic = this.createGeneric(String.class);
        CompletableFuture future = rx.trace(generic).toCompletableFuture();
        this.assertExceptionWithWebApplicationExceptionIsThrownAndLog(future);
    }

    @Test
    public void traceWithGenericTypeThrowsNoWebApplicationExceptionForResponseTest() throws JAXRSCommonClient.Fault {
        CompletionStageRxInvoker rx = this.startRxInvokerForMethod("tracenotok");
        GenericType<Response> generic = this.createGeneric(Response.class);
        CompletableFuture<Response> future = rx.trace(generic).toCompletableFuture();
        this.checkFutureResponseStatus(future, Response.Status.NOT_ACCEPTABLE);
    }

    protected CompletionStageRxInvoker startRxInvokerForMethod(String methodName) {
        return this.startBuilderForMethod(methodName).rx();
    }

    protected Invocation.Builder startBuilderForMethod(String methodName) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(false));
        WebTarget target = client.target(this.getAbsoluteUrl(methodName));
        Invocation.Builder ib = target.request();
        return ib;
    }

    protected void assertOkAndLog(Response response, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((response.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Returned unexpected status" + response.getStatus()));
        String msg = "Returned status " + status.getStatusCode() + " (" + status.name() + ")";
        TestUtil.logMsg(msg);
    }

    protected void checkFutureResponseStatus(Future<Response> future, Response.Status status) throws JAXRSCommonClient.Fault {
        Response response = null;
        try {
            response = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        this.assertOkAndLog(response, status);
    }

    protected void checkFutureOkResponse(Future<Response> future) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((!future.isDone() ? 1 : 0) != 0, (String)"Future cannot be done, yet!");
        this.checkFutureResponseStatus(future, Response.Status.OK);
    }

    protected void checkFutureString(Future<String> future, String expectedValue) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((!future.isDone() ? 1 : 0) != 0, (String)"Future cannot be done, yet!");
        String value = null;
        try {
            value = future.get();
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        Assertions.assertTrue((boolean)expectedValue.equalsIgnoreCase(value), (String)("expected value" + expectedValue + "differes from acquired value" + value));
    }

    protected void assertExceptionWithWebApplicationExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertWebApplicationExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertExceptionWithProcessingExceptionIsThrownAndLog(Future<?> future) throws JAXRSCommonClient.Fault {
        try {
            future.get();
            throw new JAXRSCommonClient.Fault("ExecutionException has not been thrown");
        }
        catch (ExecutionException e) {
            this.assertProcessingExceptionIsCauseAndLog(e);
        }
        catch (InterruptedException e) {
            throw new JAXRSCommonClient.Fault("Unexpected exception thrown", e);
        }
    }

    protected void assertProcessingExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        JAXRSClientIT.assertCause(e, ProcessingException.class, "ExecutionException wrapped", e.getCause(), "rather then ProcessingException");
        JAXRSClientIT.logMsg("ExecutionException.getCause is ProcessingException as expected");
    }

    protected void assertWebApplicationExceptionIsCauseAndLog(ExecutionException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("ExecutionException has been thrown as expected", e);
        JAXRSClientIT.assertCause(e, WebApplicationException.class, "ExecutionException wrapped", e.getCause(), "rather then WebApplicationException");
        JAXRSClientIT.logMsg("ExecutionException.getCause is WebApplicationException as expected");
    }

    protected <T> GenericType<T> createGeneric(Class<T> clazz) {
        return new GenericType(clazz);
    }
}

