/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.ext.interceptor;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InterceptorCallbackMethods;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.ws.rs.ext.InterceptorContext;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class TemplateInterceptorBody<CONTEXT extends InterceptorContext> {
    public static final String OPERATION = "OPERATION";
    public static final String ENTITY = "Entity";
    public static final String ENTITY2 = "Other Entity";
    public static final String PROPERTY = "Property";
    public static final String NULL = "None";
    public static final String NPE = "NullPointerException has been thrown as expected";
    public static final String IOE = "IOException has been thrown as expected";
    public static final String WAE = "WebApplicationException has been thrown as expected";
    protected CONTEXT context;
    protected InterceptorCallbackMethods callback;

    public Object executeMethod(CONTEXT context, InterceptorCallbackMethods callback) throws IOException {
        Method[] methods;
        this.context = context;
        this.callback = callback;
        String operation = this.getHeaderString();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!operation.equalsIgnoreCase(method.getName())) continue;
            try {
                Object ret = method.invoke((Object)this, new Object[0]);
                if (ret == null) {
                    return this.proceed();
                }
                return ret;
            }
            catch (Exception e) {
                if (IOException.class.isInstance(e.getCause())) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                TemplateInterceptorBody.throwIOEAndLog(operation, e);
            }
        }
        return this.operationMethodNotFound(operation);
    }

    private static void throwIOEAndLog(String operation, Throwable e) throws IOException {
        System.out.println("Error while invoking method " + operation);
        e.printStackTrace();
        throw new IOException(e);
    }

    protected Object operationMethodNotFound(String operation) throws IOException {
        throw new IOException("Operation " + operation + " not implemented");
    }

    protected void assertTrue(boolean conditionTrue, Object ... msg) {
        if (conditionTrue) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            for (Object str : msg) {
                sb.append(str).append(" ");
            }
        }
        throw new RuntimeException(new IOException(sb.toString()));
    }

    protected <T> void setEntity(T ... entity) {
        this.setSeparatedEntity(" ", entity);
    }

    protected <T> void setSeparatedEntity(String separator, T ... entity) {
        String complete = JaxrsUtil.iterableToString(separator, entity);
        this.writeEntity(complete);
    }

    protected void writeEntity(String entity) {
        this.callback.writeEntity(entity);
    }

    protected Object proceed() throws IOException {
        return this.callback.proceed();
    }

    protected String getHeaderString() {
        return this.callback.getHeaderString();
    }
}

