/*
 * Copyright (c) 2009, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.servlet.api.jakarta_servlet.servletrequestwrapper30;

import java.io.IOException;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;

public class TestServletWrapper extends
    com.sun.ts.tests.servlet.api.jakarta_servlet.servletrequest30.TestServlet {

  public void init(ServletConfig servletConfig) throws ServletException {
    super.init(servletConfig);
  }

  public void service(ServletRequest servletRequest,
      ServletResponse servletResponse) throws ServletException, IOException {
    ServletRequestWrapper wrapper = new ServletRequestWrapper(servletRequest);
    super.service(wrapper, servletResponse);
  }

  public void getServletContext(ServletRequest request,
      ServletResponse response) throws ServletException, IOException {

    ServletContext actual = request.getServletContext();
    ServletContext expected = this.getServletConfig().getServletContext();

    if (actual != expected) {
      response.getWriter().println(
          "getServletContext() returned inconsistent result.  Test FAILED.");
    } else {
      response.getWriter().println(
          "getServletContext() returned inconsistent result.  Test ED.");
    }
  }

}
