/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class ActiveConnectionFactory
implements ConnectionFactory {
    private String host;
    private int port;

    public ActiveConnectionFactory(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Cannot start active agent connection - empty value for hostname.");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Cannot start active agent connection - port number must be non-negative.");
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            return new SocketConnection(new Socket(this.host, this.port));
        }
        catch (UnknownHostException e) {
            throw new ConnectionFactory.Fault(e, true);
        }
        catch (IOException e) {
            throw new ConnectionFactory.Fault(e, false);
        }
    }

    @Override
    public void close() {
    }
}

