/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;

public class ReverseTestFinder
extends TestFinder {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TagTestFinder.class);
    private TestFinder delegate;

    public ReverseTestFinder() {
    }

    public ReverseTestFinder(TestFinder delegate) {
        this();
        this.delegate = delegate;
    }

    @Override
    public synchronized void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        String delegateClassName = args[0];
        try {
            Class<TestFinder> delegateClass = Class.forName(delegateClassName, true, ClassLoader.getSystemClassLoader()).asSubclass(TestFinder.class);
            this.delegate = delegateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            args = this.shift(args, 1);
            this.delegate.init(args, testSuiteRoot, env);
        }
        catch (Throwable t) {
            throw new TestFinder.Fault(i18n, "reverse.cantInitDelegate", (Object)t);
        }
    }

    @Override
    public File getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public File getRootDir() {
        return this.delegate.getRootDir();
    }

    @Override
    public void read(File file) {
        this.delegate.read(file);
    }

    @Override
    public TestDescription[] getTests() {
        TestDescription[] tds = this.delegate.getTests();
        if (tds != null) {
            int n = tds.length;
            for (int i = 0; i < n / 2; ++i) {
                TestDescription temp = tds[i];
                tds[i] = tds[n - 1 - i];
                tds[n - 1 - i] = temp;
            }
        }
        return tds;
    }

    @Override
    public File[] getFiles() {
        File[] fs = this.delegate.getFiles();
        if (fs != null) {
            int n = fs.length;
            for (int i = 0; i < n / 2; ++i) {
                File temp = fs[i];
                fs[i] = fs[n - 1 - i];
                fs[n - 1 - i] = temp;
            }
        }
        return fs;
    }

    @Override
    protected void scan(File file) {
        throw new Error("should not be called!");
    }

    private String[] shift(String[] args, int n) {
        String[] result = new String[args.length - n];
        System.arraycopy(args, n, result, 0, result.length);
        return result;
    }
}

