/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.sebootstrap;

import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=1L, unit=TimeUnit.HOURS)
public final class SeBootstrapIT {
    private static Client client;

    @Test
    public final void shouldBootInstanceUsingDefaults() throws InterruptedException, ExecutionException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)"HTTP"));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)"/"));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceUsingProperties() throws InterruptedException, ExecutionException, IOException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.property("jakarta.ws.rs.SeBootstrap.Protocol", (Object)"HTTP").property("jakarta.ws.rs.SeBootstrap.Host", (Object)"localhost").property("jakarta.ws.rs.SeBootstrap.Port", (Object)SeBootstrapIT.someFreeIpPort()).property("jakarta.ws.rs.SeBootstrap.RootPath", (Object)"/root/path").build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Object)requestedConfiguration.port()));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceUsingConvenienceMethods() throws InterruptedException, ExecutionException, IOException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.protocol("HTTP").host("localhost").port(Integer.valueOf(SeBootstrapIT.someFreeIpPort())).rootPath("/root/path").build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Object)requestedConfiguration.port()));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceUsingExternalConfiguration() throws InterruptedException, ExecutionException, IOException {
        int someFreeIpPort = SeBootstrapIT.someFreeIpPort();
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.from((property, type) -> {
            switch (property) {
                case "jakarta.ws.rs.SeBootstrap.Protocol": {
                    return Optional.of("HTTP");
                }
                case "jakarta.ws.rs.SeBootstrap.Host": {
                    return Optional.of("localhost");
                }
                case "jakarta.ws.rs.SeBootstrap.Port": {
                    return Optional.of(someFreeIpPort);
                }
                case "jakarta.ws.rs.SeBootstrap.RootPath": {
                    return Optional.of("/root/path");
                }
            }
            return Optional.empty();
        }).build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Object)requestedConfiguration.port()));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceDespiteUnknownConfigurationParameters() throws InterruptedException, ExecutionException, IOException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.protocol("HTTP").host("localhost").port(Integer.valueOf(SeBootstrapIT.someFreeIpPort())).rootPath("/root/path").from((property, type) -> {
            switch (property) {
                case "ee.jakarta.tck.ws.rs.sebootstrap.SeBootstrapIT$Unknown_1": {
                    return Optional.of("Silently ignored value A");
                }
            }
            return Optional.empty();
        }).property("ee.jakarta.tck.ws.rs.sebootstrap.SeBootstrapIT$Unknown_2", (Object)"Silently ignored value B").from(new Object()).build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Object)requestedConfiguration.port()));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceUsingSelfDetectedFreeIpPort() throws InterruptedException, ExecutionException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.protocol("HTTP").host("localhost").port(Integer.valueOf(0)).rootPath("/root/path").build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @Test
    public final void shouldBootInstanceUsingImplementationsDefaultIpPort() throws InterruptedException, ExecutionException {
        int expectedResponse = SeBootstrapIT.mockInt();
        StaticApplication application = new StaticApplication(expectedResponse);
        SeBootstrap.Configuration.Builder bootstrapConfigurationBuilder = SeBootstrap.Configuration.builder();
        SeBootstrap.Configuration requestedConfiguration = bootstrapConfigurationBuilder.protocol("HTTP").host("localhost").port(Integer.valueOf(-1)).rootPath("/root/path").build();
        CompletionStage completionStage = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)requestedConfiguration);
        SeBootstrap.Instance instance = (SeBootstrap.Instance)completionStage.toCompletableFuture().get();
        SeBootstrap.Configuration actualConfiguration = instance.configuration();
        int actualResponse = (Integer)client.target(UriBuilder.newInstance().scheme(actualConfiguration.protocol()).host(actualConfiguration.host()).port(actualConfiguration.port()).path(actualConfiguration.rootPath()).path("application/resource")).request().get(Integer.TYPE);
        MatcherAssert.assertThat((Object)actualResponse, (Matcher)Matchers.is((Object)expectedResponse));
        MatcherAssert.assertThat((Object)actualConfiguration.protocol(), (Matcher)Matchers.is((Object)requestedConfiguration.protocol()));
        MatcherAssert.assertThat((Object)actualConfiguration.host(), (Matcher)Matchers.is((Object)requestedConfiguration.host()));
        MatcherAssert.assertThat((Object)actualConfiguration.port(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)actualConfiguration.rootPath(), (Matcher)Matchers.is((Object)requestedConfiguration.rootPath()));
        instance.stop().toCompletableFuture().get();
    }

    @BeforeAll
    static void createClient() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    static void disposeClient() {
        client.close();
    }

    private static final int someFreeIpPort() throws IOException {
        return JaxrsUtil.freePort();
    }

    private static final int mockInt() {
        return (int)Math.round(2.147483647E9 * Math.random());
    }

    @ApplicationPath(value="application")
    public static final class StaticApplication
    extends Application {
        private final StaticResource staticResource;

        private StaticApplication(long staticResponse) {
            this.staticResource = new StaticResource(staticResponse);
        }

        public final Set<Object> getSingletons() {
            return Collections.singleton(this.staticResource);
        }

        @Path(value="resource")
        public static final class StaticResource {
            private final long staticResponse;

            private StaticResource(long staticResponse) {
                this.staticResponse = staticResponse;
            }

            @GET
            public final long staticResponse() {
                return this.staticResponse;
            }
        }
    }
}

