/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.ASingletonBean;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.BSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.C2SingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.CSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.CommonSingletonIF;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBContext;

public class BeanBase
implements CommonSingletonIF {
    @Resource
    private EJBContext ejbContext;
    @EJB
    private ASingletonBean aSingleton;
    @EJB
    private BSingletonIF bSingleton;
    @EJB
    private CSingletonIF cSingleton;
    @EJB
    private C2SingletonIF c2Singleton;

    @Override
    public <T extends CommonSingletonIF> T getSingletonReference(Class<T> type) {
        if (ASingletonBean.class.isAssignableFrom(type)) {
            return (T)this.aSingleton;
        }
        if (BSingletonIF.class.isAssignableFrom(type)) {
            return (T)this.bSingleton;
        }
        if (C2SingletonIF.class.isAssignableFrom(type)) {
            return (T)this.c2Singleton;
        }
        if (CSingletonIF.class.isAssignableFrom(type)) {
            return (T)this.cSingleton;
        }
        throw new IllegalArgumentException("Unrecognized singleton type: " + String.valueOf(type));
    }

    @Override
    public <T extends CommonSingletonIF> T getSingletonReferenceFromEJBContext(Class<T> type) {
        String prefix = BeanBase.class.getName();
        if (ASingletonBean.class.isAssignableFrom(type)) {
            return (T)((CommonSingletonIF)this.ejbContext.lookup(prefix + "/aSingleton"));
        }
        if (BSingletonIF.class.isAssignableFrom(type)) {
            return (T)((CommonSingletonIF)this.ejbContext.lookup(prefix + "/bSingleton"));
        }
        if (C2SingletonIF.class.isAssignableFrom(type)) {
            return (T)((CommonSingletonIF)this.ejbContext.lookup(prefix + "/c2Singleton"));
        }
        if (CSingletonIF.class.isAssignableFrom(type)) {
            return (T)((CommonSingletonIF)this.ejbContext.lookup(prefix + "/cSingleton"));
        }
        throw new IllegalArgumentException("Unrecognized singleton type: " + String.valueOf(type));
    }

    @Override
    public void error() throws RuntimeException {
        throw new RuntimeException("System exception from tests, but the single bean should not be destroyed.");
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this);
    }

    @PreDestroy
    private void preDestroy() {
        Helper.getLogger().info("In BeanBase.preDestroy()");
    }
}

