/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.expire;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.JsfClientBase;
import com.sun.ts.tests.ejb30.timer.common.ScheduleValues;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.lite.timer.schedule.expire.ScheduleBean;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

@Named(value="client")
@RequestScoped
public class JsfClient
extends JsfClientBase {
    private static final int WAIT_YEARS = 6;
    @EJB(beanName="ScheduleBean")
    private ScheduleBean scheduleBean;

    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.scheduleBean.cancelAllTimers();
    }

    private void incrementSecond0(String increment, long timeRemainingTillNextTimeout) {
        ScheduleExpression exp = new ScheduleExpression().hour("*").minute("*").second(increment);
        TimerInfo info = new TimerInfo(this.getTestName());
        info.setLongVar(Long.valueOf(timeRemainingTillNextTimeout));
        Timer timer = this.createTimer(exp, info);
        this.passIfRecurringTimeout(new long[0]);
        this.scheduleBean.cancelTimer(new Timer[]{timer});
    }

    private void incrementMinute0(String increment, Date expectedTimeout, Date ... starts) {
        ScheduleExpression exp = new ScheduleExpression().hour("*").minute(increment);
        if (starts.length > 0) {
            exp = exp.start(starts[0]);
        }
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.verifyNextTimeout(expectedTimeout, timer);
        this.scheduleBean.cancelTimer(new Timer[]{timer});
    }

    private void incrementHour0(String increment, Date expectedTimeout, Date ... starts) {
        ScheduleExpression exp = new ScheduleExpression().hour(increment);
        if (starts.length > 0) {
            exp = exp.start(starts[0]);
        }
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.verifyNextTimeout(expectedTimeout, timer);
        this.scheduleBean.cancelTimer(new Timer[]{timer});
    }

    private void dayOfWeek0(ScheduleExpression exp, Date expectedNextTimeout, String ... dayOfWeeks) {
        if (exp == null) {
            exp = new ScheduleExpression();
        }
        for (String day : dayOfWeeks) {
            exp = exp.year("*").month("*").dayOfMonth("*").dayOfWeek(day);
            Timer timer = this.createTimer(exp, new TimerInfo[0]);
            this.verifyNextTimeout(expectedNextTimeout, timer);
        }
    }

    private void month0(ScheduleExpression exp, Date expectedNextTimeout, String ... months) {
        if (exp == null) {
            exp = new ScheduleExpression();
        }
        for (String month : months) {
            exp = exp.year("*").month(month);
            Timer timer = this.createTimer(exp, new TimerInfo[0]);
            this.verifyNextTimeout(expectedNextTimeout, timer);
        }
    }

    private void year0(ScheduleExpression exp, Date expectedNextTimeout, String ... years) {
        if (exp == null) {
            exp = new ScheduleExpression();
        }
        for (String year : years) {
            exp = exp.year(year);
            Timer timer = this.createTimer(exp, new TimerInfo[0]);
            this.verifyNextTimeout(expectedNextTimeout, timer);
        }
    }

    private void dayOfMonth0(String[] dayOfMonths, int[] expectedDayOfMonths, Calendar cal) {
        for (int i = 0; i < dayOfMonths.length; ++i) {
            ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}).dayOfMonth(dayOfMonths[i]);
            Date expectedNextTimeout = cal.getTime();
            expectedNextTimeout = DateUtils.setDays((Date)expectedNextTimeout, (int)expectedDayOfMonths[i]);
            Timer timer = this.createTimer(exp, new TimerInfo[0]);
            this.verifyNextTimeout(expectedNextTimeout, timer);
        }
    }

    protected void verifyNextTimeout(Date expected, Timer timer) throws RuntimeException {
        long ignoreableMillis = 60000L;
        Date actual = this.scheduleBean.getNextTimeout(timer);
        long actualTimeRemaining = this.scheduleBean.getTimeRemaining(timer);
        Helper.getLogger().fine("About to compare expected and actual nextTimeout and actualTimeRemaining:" + String.valueOf(expected) + "; " + String.valueOf(actual) + "; " + actualTimeRemaining);
        this.appendReason(new Object[]{"Compare expected nextTimeout " + String.valueOf(expected) + ", and actual nextTimeout " + String.valueOf(actual)});
        try {
            this.assertEquals(null, true, DateUtils.isSameInstant((Date)DateUtils.round((Date)expected, (int)12), (Date)DateUtils.round((Date)actual, (int)12)));
        }
        catch (RuntimeException e) {
            this.appendReason(new Object[]{"Rounded dates are not equal; next check if they are close."});
            long dif = Math.abs(expected.getTime() - actual.getTime());
            if (dif <= 60000L) {
                this.appendReason(new Object[]{"The time diff " + dif + " <= ignoreableMillis 60000"});
            }
            throw new RuntimeException("The time diff " + dif + " > 60000");
        }
        Helper.assertCloseEnough((String)"Check timeRemaining", (long)(expected.getTime() - System.currentTimeMillis()), (long)actualTimeRemaining, (long)60000L, (StringBuilder)this.getReasonBuffer());
    }

    protected Timer createTimer(ScheduleExpression exp, TimerInfo ... infos) {
        Timer timer = null;
        timer = infos.length == 0 ? this.scheduleBean.createTimer(exp, new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false)) : this.scheduleBean.createTimer(exp, new TimerConfig((Serializable)infos[0], false));
        this.appendReason(new Object[]{TestUtil.NEW_LINE + "Created a timer with expression " + TimerUtil.toString((ScheduleExpression)exp)});
        return timer;
    }

    public void startNeverExpires() {
        Calendar cal = Calendar.getInstance();
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(13, 10);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date start = TimerUtil.getCurrentDatePlus((int)1, (int)6);
        exp.start(start);
        exp.year(currentYear + " - " + (currentYear + 1));
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoMoreTimeouts(timer)});
        this.passIfNoTimeout(new long[0]);
    }

    public void endNeverExpires() {
        Calendar cal = Calendar.getInstance();
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(13, 10);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date end = DateUtils.setYears((Date)cal.getTime(), (int)(cal.get(1) - 1));
        exp.end(end);
        exp.year(currentYear + " - " + (currentYear + 1));
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoMoreTimeouts(timer)});
        this.passIfNoTimeout(new long[0]);
    }

    public void endBeforeActualValues() {
        int plusMinutes = 5;
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[0]);
        Date end = TimerUtil.getCurrentDatePlus((int)1, (int)plusMinutes);
        end = DateUtils.setYears((Date)end, (int)(currentYear + 6));
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)13, (int)(plusMinutes * 2));
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        exp.year(currentYear + 6 + "-" + (currentYear + 12));
        exp.end(end);
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoMoreTimeouts(timer)});
    }

    public void startBeforeActualValues() {
        Date start = TimerUtil.getCurrentDatePlus((int)13, (int)5);
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[0]);
        Calendar cal = Calendar.getInstance();
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        exp.year(currentYear + 6 + " - " + (currentYear + 12));
        exp.start(start);
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        Date expectedNextTimeout = DateUtils.setYears((Date)cal.getTime(), (int)(currentYear + 6));
        this.verifyNextTimeout(expectedNextTimeout, timer);
        this.passIfNoTimeout(new long[0]);
    }

    public void startInTheFuture() {
        Calendar cal = Calendar.getInstance();
        Date currentDate = cal.getTime();
        Date start = DateUtils.truncate((Date)currentDate, (int)1);
        start = DateUtils.setYears((Date)start, (int)(cal.get(1) + 6));
        ScheduleExpression exp = new ScheduleExpression().start(start);
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        this.verifyNextTimeout(start, timer);
        exp.start(currentDate);
        this.verifyNextTimeout(start, timer);
        this.passIfNoTimeout(new long[0]);
    }

    public void startAfterActualValues() {
        Calendar cal = Calendar.getInstance();
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(13, 10);
        Date currentDatePlus10Sec = cal.getTime();
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date start = DateUtils.addYears((Date)currentDatePlus10Sec, (int)6);
        start = DateUtils.addSeconds((Date)start, (int)1);
        exp.start(start);
        exp.year(currentYear + " - " + (currentYear + 12));
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        int startYear = TimerUtil.getDateField((int)1, (Date[])new Date[]{start});
        Date expectedNextTimeout = DateUtils.setYears((Date)currentDatePlus10Sec, (int)(startYear + 1));
        this.verifyNextTimeout(expectedNextTimeout, timer);
        this.passIfNoTimeout(new long[0]);
    }

    public void startAfterActualValues2() {
        int plusMinutes = 10;
        Calendar cal = Calendar.getInstance();
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        Date currentDate = cal.getTime();
        cal.add(12, plusMinutes);
        Date currentDatePlus = cal.getTime();
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date start = DateUtils.addYears((Date)currentDate, (int)6);
        exp.start(start);
        exp.year(currentYear + " - " + (currentYear + 12));
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        int startYear = TimerUtil.getDateField((int)1, (Date[])new Date[]{start});
        Date expectedNextTimeout = DateUtils.setYears((Date)currentDatePlus, (int)startYear);
        this.verifyNextTimeout(expectedNextTimeout, timer);
        this.passIfNoTimeout(new long[0]);
    }

    public void allDefaults() {
        ScheduleExpression exp = new ScheduleExpression();
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        Date expectedNextTimeout = Calendar.getInstance().getTime();
        expectedNextTimeout = DateUtils.addDays((Date)expectedNextTimeout, (int)1);
        expectedNextTimeout = DateUtils.truncate((Date)expectedNextTimeout, (int)5);
        this.verifyNextTimeout(expectedNextTimeout, timer);
        this.scheduleBean.cancelTimer(new Timer[]{timer});
    }

    public void timerAccessInTimeoutMethod() {
        this.scheduleBean.cancelAllTimers();
        Timer timer = this.scheduleBean.createSecondLaterTimer(new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false), 2);
        TestUtil.sleepMsec((int)30000);
        this.passIfTimeout(new long[0]);
    }

    public void cancelInTimeoutMethod() {
        Date end = TimerUtil.getCurrentDatePlus((int)12, (int)5);
        ScheduleExpression exp = new ScheduleExpression().second("*").minute("*").hour("*").end(end);
        Timer timer = this.scheduleBean.createTimer(exp, new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false));
        this.passIfTimeout(new long[0]);
        this.removeStatusAndRecords(new String[0]);
        this.appendReason(new Object[]{this.scheduleBean.passIfNoSuchObjectLocalException(timer)});
    }

    public void leapYears() {
        this.scheduleBean.cancelAllTimers();
        int nextNextLeapYear = TimerUtil.getNextLeapYear((int[])new int[]{TimerUtil.getNextLeapYear((int[])new int[0])});
        int[] leapYears = new int[]{nextNextLeapYear, 2104, 2104};
        String[] yearRange = new String[]{leapYears[0] - 3 + "-" + leapYears[0], leapYears[1] - 6 + "-" + leapYears[1], String.valueOf(leapYears[2])};
        String[] dayOfMonths = new String[]{"29, 29", "29, 29", "last, last"};
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        cal.set(5, 1);
        for (int i = 0; i < leapYears.length; ++i) {
            ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}).dayOfMonth(dayOfMonths[i]).month(2).year(yearRange[i]).timezone(utc.getID());
            Calendar cal2 = Calendar.getInstance(utc);
            cal2.set(leapYears[i], 1, 29);
            Date expectedNextTimeout = cal2.getTime();
            Timer timer = this.createTimer(exp, new TimerInfo[0]);
            this.verifyNextTimeout(expectedNextTimeout, timer);
        }
        this.assertEquals("Check # of timers", 3, this.scheduleBean.getTimers().size());
    }

    public void dayOfMonth() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)2, (int)1);
        int lastDayOfMonth = cal.getActualMaximum(5);
        String[] dayOfMonths = new String[]{String.valueOf(1), String.valueOf(lastDayOfMonth), "last, last"};
        int[] expectedDayOfMonths = new int[]{1, lastDayOfMonth, lastDayOfMonth};
        this.dayOfMonth0(dayOfMonths, expectedDayOfMonths, cal);
    }

    public void dayOfMonthNegative() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)2, (int)1);
        int lastDayOfMonth = cal.getActualMaximum(5);
        int[] dayOfMonthsInt = ScheduleValues.getSequenceIntArray((int)-7, (int)-1);
        String[] dayOfMonths = ScheduleValues.intArrayToStringArray((int[])dayOfMonthsInt);
        int[] expectedDayOfMonths = new int[dayOfMonths.length];
        for (int i = 0; i < expectedDayOfMonths.length; ++i) {
            expectedDayOfMonths[i] = lastDayOfMonth + dayOfMonthsInt[i];
        }
        this.dayOfMonth0(dayOfMonths, expectedDayOfMonths, cal);
    }

    public void dayOfMonthNthDayFeb() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2100);
        cal.set(5, 1);
        cal.set(2, 1);
        String[] dayOfMonths = new String[]{"1st Mon", "1st Tue", "1st Wed", "1st Thu", "1st Fri", "1st Sat", "1st Sun", "2nd Mon", "2nd Tue", "2nd Wed", "2nd Thu", "2nd Fri", "2nd Sat", "2nd Sun", "3rd Mon", "3rd Tue", "3rd Wed", "3rd Thu", "3rd Fri", "3rd Sat", "3rd Sun", "4th Mon", "4th Tue", "4th Wed", "4th Thu", "4th Fri", "4th Sat", "4th Sun"};
        int[] expectedDayOfMonths = ScheduleValues.getSequenceIntArray((int)1, (int)28);
        this.dayOfMonth0(dayOfMonths, expectedDayOfMonths, cal);
        dayOfMonths = null;
        expectedDayOfMonths = null;
        String[] dayOfMonths2 = new String[]{"Last Mon", "Last Tue", "Last Wed", "Last Thu", "Last Fri", "Last Sat", "Last Sun"};
        int[] expectedDayOfMonths2 = ScheduleValues.getSequenceIntArray((int)22, (int)28);
        this.dayOfMonth0(dayOfMonths2, expectedDayOfMonths2, cal);
    }

    public void dayOfMonthNthDayJan() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2100);
        cal.set(2, 0);
        String[] dayOfMonths = new String[]{"1st Fri-1st Mon", "1st Sat", "1st Sun", "1st Mon", "1st Tue", "1st Wed", "1st Thu", "2nd Fri", "2nd Sat", "2nd Sun", "2nd Mon", "2nd Tue", "2nd Wed", "2nd Thu", "3rd Fri", "3rd Sat", "3rd Sun", "3rd Mon", "3rd Tue", "3rd Wed", "3rd Thu", "4th Fri", "4th Sat", "4th Sun", "4th Mon", "4th Tue", "4th Wed", "4th Thu", "5th Fri", "5th Sat-5th Sat", "5th Sun-Last Sun"};
        int[] expectedDayOfMonths = ScheduleValues.getSequenceIntArray((int)1, (int)31);
        this.dayOfMonth0(dayOfMonths, expectedDayOfMonths, cal);
        dayOfMonths = null;
        expectedDayOfMonths = null;
        String[] dayOfMonths2 = new String[]{"Last Mon", "Last Tue", "Last Wed", "Last Thu", "Last Fri", "Last Sat", "Last Sun, 5th Sun"};
        int[] expectedDayOfMonths2 = ScheduleValues.getSequenceIntArray((int)25, (int)31);
        this.dayOfMonth0(dayOfMonths2, expectedDayOfMonths2, cal);
    }

    public void dayOfWeekAll() {
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < 7; ++i) {
            cal.add(7, 1);
            int targetDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
            String[] targetDayOfWeeks = new String[]{String.valueOf(targetDayOfWeek), ScheduleValues.dayOfWeekIntToString((int)targetDayOfWeek)};
            Date expectedNextTimeout = cal.getTime();
            this.dayOfWeek0(TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}), expectedNextTimeout, targetDayOfWeeks);
        }
    }

    public void dayOfWeekSunday() {
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = 0;
        do {
            cal.add(7, 1);
        } while ((currentDayOfWeek = cal.get(7)) != 1);
        Date nextSun = cal.getTime();
        this.dayOfWeek0(TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}), nextSun, "0", "7", "SUn");
    }

    public void dayOfWeekSunday0To7() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)13, (int)5);
        Date expectedNextTimeout = cal.getTime();
        this.dayOfWeek0(TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}), expectedNextTimeout, "0-7");
    }

    public void dayOfWeekSunday2() {
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = 0;
        do {
            cal.add(7, 1);
        } while ((currentDayOfWeek = cal.get(7)) != 1);
        Date nextSun = cal.getTime();
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        cal.add(7, 1);
        exp = exp.start(cal.getTime());
        this.dayOfWeek0(exp, DateUtils.addDays((Date)nextSun, (int)7), "7");
    }

    public void dayOfWeekNow() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)13, (int)10);
        int targetDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        exp = exp.dayOfMonth("*").dayOfWeek(targetDayOfWeek);
        Timer timer = this.createTimer(exp, new TimerInfo[0]);
        int currentMonth = cal.get(2);
        cal.add(7, 7);
        int nextWeekMonth = cal.get(2);
        this.appendReason(new Object[]{"currentMonth=" + currentMonth + ", nextWeekMonth=" + nextWeekMonth});
        this.passIfTimeout(new long[0]);
        if (currentMonth == nextWeekMonth) {
            Date expectedNextTimeout = cal.getTime();
            this.verifyNextTimeout(expectedNextTimeout, timer);
        } else {
            try {
                Date nextTimeout = this.scheduleBean.getNextTimeout(timer);
                throw new RuntimeException("Expecting EJBException, but got " + String.valueOf(nextTimeout));
            }
            catch (NoSuchObjectLocalException e) {
                this.appendReason(new Object[]{"Got the expected " + String.valueOf((Object)e)});
            }
            catch (NoMoreTimeoutsException e) {
                this.appendReason(new Object[]{"Got the expected " + String.valueOf((Object)e)});
            }
            catch (EJBException e) {
                Throwable c = e.getCause();
                if (c instanceof NoSuchObjectLocalException || c instanceof NoMoreTimeoutsException) {
                    this.appendReason(new Object[]{"Got the (wrapped) expected " + String.valueOf(c)});
                }
                throw new RuntimeException("Expecting (wrapped) NoSuchObjectLocalException or NoMoreTimeoutsException, but actual " + String.valueOf(c));
            }
        }
    }

    public void dayOfWeekList() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int currentDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        cal.add(7, 1);
        int nextDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        cal.add(7, -2);
        int previosDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        int[] dayOfWeeks = new int[]{nextDayOfWeek, previosDayOfWeek, currentDayOfWeek};
        Object[] dayOfWeeksAsNumber = ScheduleValues.intArrayToStringArray((int[])dayOfWeeks);
        Object[] dayOfWeeksAsText = ScheduleValues.dayOfWeekIntToString((int[])dayOfWeeks);
        this.dayOfWeek0(exp, expectedTimeout, StringUtils.join((Object[])dayOfWeeksAsNumber, (char)','), StringUtils.join((Object[])dayOfWeeksAsText, (char)','));
    }

    public void dayOfWeekListComplex() {
        String[][] combinedDayOfWeeks;
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(7, -3);
        int[] dayOfWeeks = new int[5];
        for (int i = 0; i < dayOfWeeks.length; ++i) {
            cal.add(7, 1);
            dayOfWeeks[i] = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        }
        String[] dayOfWeeksAsNumber = ScheduleValues.intArrayToStringArray((int[])dayOfWeeks);
        String[] dayOfWeeksAsText = ScheduleValues.dayOfWeekIntToString((int[])dayOfWeeks);
        for (String[] days : combinedDayOfWeeks = new String[][]{dayOfWeeksAsNumber, dayOfWeeksAsText}) {
            String dayOfWeekVal = days[3] + "-" + days[4] + ", " + days[0] + "-" + days[1] + ", " + days[2];
            this.dayOfWeek0(exp, expectedTimeout, dayOfWeekVal);
        }
    }

    public void dayOfWeekListOverlap() {
        String[][] combinedDayOfWeeks;
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(7, -3);
        int[] dayOfWeeks = new int[5];
        for (int i = 0; i < dayOfWeeks.length; ++i) {
            cal.add(7, 1);
            dayOfWeeks[i] = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        }
        String[] dayOfWeeksAsNumber = ScheduleValues.intArrayToStringArray((int[])dayOfWeeks);
        String[] dayOfWeeksAsText = ScheduleValues.dayOfWeekIntToString((int[])dayOfWeeks);
        for (String[] days : combinedDayOfWeeks = new String[][]{dayOfWeeksAsNumber, dayOfWeeksAsText}) {
            String dayOfWeekVal = days[0] + "-" + days[3] + ", " + days[1] + "-" + days[4];
            this.dayOfWeek0(exp, expectedTimeout, dayOfWeekVal);
        }
    }

    public void dayOfWeekRange() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int thisDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        cal.add(7, -2);
        int prevPrevDayOfWeek = TimerUtil.getForSchedule((int)7, (Calendar[])new Calendar[]{cal});
        String dayOfWeeksAsNumber = prevPrevDayOfWeek + "-" + thisDayOfWeek;
        String dayOfWeeksAsText = ScheduleValues.dayOfWeekIntToString((int)prevPrevDayOfWeek) + "-" + ScheduleValues.dayOfWeekIntToString((int)thisDayOfWeek);
        this.dayOfWeek0(exp, expectedTimeout, dayOfWeeksAsNumber, dayOfWeeksAsText);
    }

    public void monthList() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int currentMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        cal.add(2, 1);
        int nextMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        cal.add(2, -2);
        int previosMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        int[] months = new int[]{nextMonth, previosMonth, currentMonth};
        Object[] monthsAsNumber = ScheduleValues.intArrayToStringArray((int[])months);
        Object[] monthsAsText = ScheduleValues.monthIntToString((int[])months);
        this.month0(exp, expectedTimeout, StringUtils.join((Object[])monthsAsNumber, (char)','), StringUtils.join((Object[])monthsAsText, (char)','));
    }

    public void monthRange() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int thisMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        cal.add(2, -2);
        int prevPrevMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        String monthsAsNumber = prevPrevMonth + "-" + thisMonth;
        String monthsAsText = ScheduleValues.monthIntToString((int)prevPrevMonth) + "-" + ScheduleValues.monthIntToString((int)thisMonth);
        this.month0(exp, expectedTimeout, monthsAsNumber, monthsAsText);
        monthsAsNumber = thisMonth + "-" + thisMonth;
        monthsAsText = ScheduleValues.monthIntToString((int)thisMonth) + "-" + ScheduleValues.monthIntToString((int)thisMonth);
        this.month0(exp, expectedTimeout, monthsAsNumber, monthsAsText);
    }

    public void monthListComplex() {
        String[][] combinedMonths;
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(2, -3);
        int[] months = new int[5];
        for (int i = 0; i < months.length; ++i) {
            cal.add(2, 1);
            months[i] = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        }
        String[] monthsAsNumber = ScheduleValues.intArrayToStringArray((int[])months);
        String[] monthsAsText = ScheduleValues.monthIntToString((int[])months);
        for (String[] m : combinedMonths = new String[][]{monthsAsNumber, monthsAsText}) {
            String monthVal = m[3] + "-" + m[4] + ", " + m[0] + "-" + m[1] + ", " + m[2];
            this.month0(exp, expectedTimeout, monthVal);
        }
    }

    public void monthListOverlap() {
        String[][] combinedMonths;
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(2, -3);
        int[] months = new int[5];
        for (int i = 0; i < months.length; ++i) {
            cal.add(2, 1);
            months[i] = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
        }
        String[] monthsAsNumber = ScheduleValues.intArrayToStringArray((int[])months);
        String[] monthsAsText = ScheduleValues.monthIntToString((int[])months);
        for (String[] m : combinedMonths = new String[][]{monthsAsNumber, monthsAsText}) {
            String monthVal = m[0] + "-" + m[3] + ", " + m[1] + "-" + m[4];
            this.month0(exp, expectedTimeout, monthVal);
        }
    }

    public void monthAll() {
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < 24; ++i) {
            cal.add(2, 1);
            int targetMonth = TimerUtil.getForSchedule((int)2, (Calendar[])new Calendar[]{cal});
            String[] targetMonths = new String[]{String.valueOf(targetMonth), ScheduleValues.monthIntToString((int)targetMonth)};
            cal.set(5, cal.getActualMaximum(5));
            Date expectedNextTimeout = cal.getTime();
            for (String month : targetMonths) {
                ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal}).month(month).dayOfMonth("last");
                Timer timer = this.createTimer(exp, new TimerInfo[0]);
                this.verifyNextTimeout(expectedNextTimeout, timer);
            }
        }
    }

    public void yearList() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int currentYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(1, 1);
        int nextYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(1, -2);
        int previosYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        int[] years = new int[]{nextYear, previosYear, currentYear};
        Object[] yearsAsNumber = ScheduleValues.intArrayToStringArray((int[])years);
        this.year0(exp, expectedTimeout, StringUtils.join((Object[])yearsAsNumber, (char)','));
    }

    public void yearRange() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        int thisYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        cal.add(1, -2);
        int prevPrevYear = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        String yearsAsNumber = prevPrevYear + "-" + thisYear;
        this.year0(exp, expectedTimeout, yearsAsNumber);
        yearsAsNumber = thisYear + "-" + thisYear;
        this.year0(exp, expectedTimeout, yearsAsNumber);
    }

    public void yearListComplex() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(1, -3);
        int[] years = new int[5];
        for (int i = 0; i < years.length; ++i) {
            cal.add(1, 1);
            years[i] = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        }
        String[] yearsAsNumber = ScheduleValues.intArrayToStringArray((int[])years);
        String yearVal = yearsAsNumber[3] + "-" + yearsAsNumber[4] + ", " + yearsAsNumber[0] + "-" + yearsAsNumber[1] + ", " + yearsAsNumber[2];
        this.year0(exp, expectedTimeout, yearVal);
    }

    public void yearListOverlap() {
        Calendar cal = TimerUtil.getCurrentCalendarPlus((int)12, (int)5);
        ScheduleExpression exp = TimerUtil.getPreciseScheduleExpression((Calendar[])new Calendar[]{cal});
        Date expectedTimeout = cal.getTime();
        cal.add(1, -3);
        int[] years = new int[5];
        for (int i = 0; i < years.length; ++i) {
            cal.add(1, 1);
            years[i] = TimerUtil.getForSchedule((int)1, (Calendar[])new Calendar[]{cal});
        }
        String[] yearsAsNumber = ScheduleValues.intArrayToStringArray((int[])years);
        String yearVal = yearsAsNumber[0] + "-" + yearsAsNumber[3] + ", " + yearsAsNumber[1] + "-" + yearsAsNumber[4];
        this.year0(exp, expectedTimeout, yearVal);
    }

    public void incrementSecond1() {
        this.incrementSecond0("*/10", 10000L);
    }

    public void incrementSecond2() {
        this.incrementSecond0("0/10", 10000L);
    }

    public void incrementSecond3() {
        this.incrementSecond0("25/35", 60000L);
    }

    public void incrementMinute1() {
        String[] increments;
        for (String increment : increments = new String[]{"*/10", "0/10"}) {
            Calendar cal = Calendar.getInstance();
            int currentMinute = cal.get(12);
            do {
                cal.add(12, 1);
            } while ((currentMinute = cal.get(12)) % 10 != 0);
            cal.set(13, 0);
            Date expectedTimeout = cal.getTime();
            cal.add(12, -1);
            cal.set(13, 1);
            Date start = cal.getTime();
            this.incrementMinute0(increment, expectedTimeout, start);
        }
    }

    public void incrementMinute2() {
        String increment = "25/35";
        Calendar cal = Calendar.getInstance();
        int currentMinute = cal.get(12);
        do {
            cal.add(12, 1);
        } while ((currentMinute = cal.get(12)) != 25);
        cal.add(10, 1);
        cal.set(13, 0);
        Date expectedTimeout = cal.getTime();
        cal.add(10, -1);
        cal.add(12, 1);
        cal.set(13, 1);
        Date start = cal.getTime();
        this.incrementMinute0(increment, expectedTimeout, start);
    }

    public void incrementHour1() {
        String[] increments;
        for (String increment : increments = new String[]{"*/3", "0/3"}) {
            Calendar cal = Calendar.getInstance();
            int currentHour = cal.get(10);
            do {
                cal.add(10, 1);
            } while ((currentHour = cal.get(10)) % 3 != 0);
            cal.set(13, 0);
            cal.set(12, 0);
            Date expectedTimeout = cal.getTime();
            cal.add(12, -1);
            cal.set(13, 1);
            Date start = cal.getTime();
            this.incrementHour0(increment, expectedTimeout, start);
        }
    }

    public void incrementHour2() {
        String increment = "22/2";
        Calendar cal = Calendar.getInstance();
        int currentHour = cal.get(11);
        do {
            cal.add(11, 1);
        } while ((currentHour = cal.get(11)) != 22);
        cal.set(12, 0);
        cal.set(13, 0);
        Date expectedTimeout = cal.getTime();
        cal.add(12, -1);
        cal.set(13, 1);
        Date start = cal.getTime();
        this.incrementHour0(increment, expectedTimeout, start);
    }
}

