/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.pluggability.jsonbprovidertests;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.jsonb.provider.MyJsonbBuilder;
import com.sun.ts.tests.jsonb.provider.MyJsonbProvider;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@Tags(value={@Tag(value="tck-javatest"), @Tag(value="jsonb"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class ClientJspTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ClientJspTest.class.getName());
    static final String VEHICLE_ARCHIVE = "jsonbprovidertests_jsp_vehicle";
    private static String packagePath = ClientJspTest.class.getPackageName().replace(".", "/");
    private static final String providerPackagePath = MyJsonbProvider.class.getPackageName().replace(".", "/");
    private boolean providerJarDeployed = false;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir", "/tmp");
    private static final String MY_JSONBROVIDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbProvider";
    private static final String MY_JSONBBUILDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbBuilder";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="jsonbprovidertests_jsp_vehicle", testable=true)
    public static WebArchive createJspDeployment() throws Exception {
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClass(MyJsonbBuilder.class)).addClass(MyJsonbProvider.class)).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        WebArchive warArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsonbprovidertests_jsp_vehicle_web.war");
        ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)warArchive.addClass(ClientJspTest.class)).addClass(ServletVehicle.class)).addClass(VehicleRunnerFactory.class)).addClass(VehicleRunnable.class)).addClass(VehicleClient.class)).addClass(EETest.class)).addClass(EETest.Fault.class)).addClass(EETest.SetupException.class)).addClass(ServiceEETest.class)).setWebXML(ClientJspTest.class.getClassLoader().getResource(packagePath + "/jsp_vehicle_web.xml"));
        warArchive.addAsLibrary((Archive)jarArchive);
        URL resURL = ClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        warArchive.addAsWebResource(resURL, "/jsp_vehicle.jsp");
        resURL = ClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        warArchive.addAsWebResource(resURL, "/client.html");
        return warArchive;
    }

    public void removeProviderJarFromCP() throws Exception {
        if (this.providerJarDeployed) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.providerJarDeployed = false;
        }
    }

    public void createProviderJar() throws Exception {
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClass(MyJsonbBuilder.class)).addClass(MyJsonbProvider.class)).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        ((ZipExporter)jarArchive.as(ZipExporter.class)).exportTo(new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar"), true);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar").toURL()}, currentThreadClassLoader);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.providerJarDeployed = true;
    }

    public static void main(String[] args) {
        ClientJspTest theTests = new ClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.createProviderJar();
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.removeProviderJarFromCP();
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void jsonbProviderTest1() throws Exception {
        try {
            JsonbProvider provider = JsonbProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest1 Failed: ", e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void jsonbProviderTest2() throws Exception {
        boolean pass = true;
        try {
            JsonbProvider provider = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS);
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONBROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
                Iterator<JsonbProvider> it = loader.iterator();
                ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + String.valueOf(providers));
            }
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonbProviderTest2 Failed");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void jsonbProviderTest3() throws Exception {
        try {
            JsonbBuilder builder = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS).create();
            String providerClass = builder.getClass().getName();
            logger.log(System.Logger.Level.INFO, "jsonb builder class=" + providerClass);
            if (!providerClass.equals(MY_JSONBBUILDER_CLASS)) {
                logger.log(System.Logger.Level.ERROR, "Current jsonb builder is not my builder - unexpected.");
                throw new Exception("jsonbProviderTest3 Failed");
            }
            logger.log(System.Logger.Level.INFO, "Current jsonb builder is my builder - expected.");
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest3 Failed: ", e);
        }
    }
}

