/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.pagedata;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.TagLibraryValidator;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class TagFilePageDataValidator
extends TagLibraryValidator {
    private static boolean _called = false;
    private SAXParserFactory _factory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        TagFilePageDataValidator.debug("In validate()");
        _called = true;
        TagFilePageDataValidator.debug("Set _called to 'true'.");
        InputStream input = null;
        PageHandler handler = new PageHandler();
        try {
            this.initializeSaxParserFactory();
            SAXParser parser = this._factory.newSAXParser();
            TagFilePageDataValidator.displayXmlView(page.getInputStream());
            input = page.getInputStream();
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            ValidationMessage[] validationMessageArray = JspTestUtil.getValidationMessage(null, "Test Setup FAILED: " + t.toString());
            return validationMessageArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    TagFilePageDataValidator.debug("IOException caught when closing steam.");
                }
            }
        }
        return handler.getParsingResults();
    }

    public void release() {
        this._factory = null;
        super.release();
    }

    public static boolean wasCalled() {
        return _called;
    }

    public static void reset() {
        _called = false;
        TagFilePageDataValidator.debug("Set _called to 'false'");
    }

    private void initializeSaxParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        TagFilePageDataValidator.debug("Initializing SAXParserFactory [ validating: false, NS aware: true, NS Prefixes: true ]");
        this._factory = SAXParserFactory.newInstance();
        this._factory.setValidating(false);
        this._factory.setNamespaceAware(true);
        this._factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void displayXmlView(InputStream in) {
        if (JspTestUtil.DEBUG) {
            BufferedInputStream bin = null;
            ByteArrayOutputStream out = null;
            try {
                bin = new BufferedInputStream(in);
                out = new ByteArrayOutputStream();
                int i = ((InputStream)bin).read();
                while (i != -1) {
                    out.write(i);
                    i = ((InputStream)bin).read();
                }
                TagFilePageDataValidator.debug("*************** XML View of tag file ***************");
                TagFilePageDataValidator.debug(out.toString());
                TagFilePageDataValidator.debug("****************************************************");
            }
            catch (Throwable t) {
                TagFilePageDataValidator.debug("[INFO] Unexpected exception while trying to display XML view of the tag file.");
            }
            finally {
                try {
                    ((InputStream)bin).close();
                    out.close();
                }
                catch (Throwable t) {
                    TagFilePageDataValidator.debug("[INFO] Unexpected exception closing I/O streams.");
                }
            }
        }
    }

    private static void debug(String message) {
        JspTestUtil.debug("[TagFilePageDataValidator] " + message);
    }

    private class PageHandler
    extends DefaultHandler {
        private static final String JSP_TAG_QN = "jsp:directive.tag";
        private static final String JSP_ATTRIBUTE_QN = "jsp:directive.attribute";
        private static final String JSP_VARIABLE_QN = "jsp:directive.variable";
        private short _tagDirectiveFound = 0;
        private short _attributeDirectiveFound = 0;
        private short _variableDirectiveFound = 0;
        private static final String JSP_ROOT_QN = "jsp:root";
        private static final String JSP_SCR_QN = "jsp:scriptlet";
        private static final String JSP_DECL_QN = "jsp:declaration";
        private static final String JSP_EXPR_QN = "jsp:expression";
        private static final String JSP_TEXT_QN = "jsp:text";
        private static final String TCK_TAG_QN = "pagedatatagfile:test";
        private static final String JSP_INCL_QN = "jsp:directive.include";
        private short _scrWasFound = 0;
        private short _declWasFound = 0;
        private short _exprWasFound = 0;
        private short _tagLibWasFound = 0;
        private short _tagDeclWasFound = 0;
        private short _jspRootWasFound = 0;
        private short _textWasFound = 0;
        private short _jspNameSpaceFound = 0;
        private short _includeDirectiveFound = 0;
        private short _rtExprFound = 0;
        private short _jspRootVersionFound = 0;
        private boolean _jspIdAttributesFound = true;
        private Map<String, Short> elements = new HashMap<String, Short>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            TagFilePageDataValidator.debug("Values passed to startElement[uri: " + uri + ", localname: " + localName + ", qname: " + qName + "]");
            if (qName.trim().equals(JSP_DECL_QN)) {
                TagFilePageDataValidator.debug("jsp:declaration was found!");
                this._declWasFound = (short)(this._declWasFound + 1);
                this.checkJspIdAttribute(JSP_DECL_QN, attributes);
            } else if (qName.trim().equals(JSP_EXPR_QN)) {
                TagFilePageDataValidator.debug("jsp:expression was found!");
                this._exprWasFound = (short)(this._exprWasFound + 1);
                this.checkJspIdAttribute(JSP_EXPR_QN, attributes);
            } else if (qName.trim().equals(JSP_ROOT_QN)) {
                TagFilePageDataValidator.debug("jsp:root was found!");
                this._jspRootWasFound = (short)(this._jspRootWasFound + 1);
                if (this.hasAttribute("xmlns:jsp", "http://java.sun.com/JSP/Page", attributes)) {
                    this._jspNameSpaceFound = (short)(this._jspNameSpaceFound + 1);
                }
                if (this.hasAttribute("xmlns:pagedatatagfile", "http://java.sun.com/tck/jsp/pagedatatagfile", attributes)) {
                    this._tagDeclWasFound = (short)(this._tagDeclWasFound + 1);
                }
                if (this.hasAttribute("version", "2.0", attributes)) {
                    this._jspRootVersionFound = (short)(this._jspRootVersionFound + 1);
                }
                this.checkJspIdAttribute(JSP_ROOT_QN, attributes);
            } else if (qName.equals(TCK_TAG_QN)) {
                TagFilePageDataValidator.debug("pagedatatagfile:test was found!");
                this._tagLibWasFound = (short)(this._tagLibWasFound + 1);
                this.checkJspIdAttribute(TCK_TAG_QN, attributes);
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = attributes.getLocalName(i).trim();
                    TagFilePageDataValidator.debug("pagedatatagfile:test attribute name: " + name);
                    if (!name.equals("dynAttribute")) continue;
                    String value = attributes.getValue(i).trim();
                    TagFilePageDataValidator.debug("pagedatatagfile:test attribute '" + name + "' value: " + value);
                    if (!value.startsWith("%=") || !value.endsWith("%")) continue;
                    TagFilePageDataValidator.debug("Converted JSP RT attribute expression was found!");
                    this._rtExprFound = (short)(this._rtExprFound + 1);
                }
            } else if (qName.trim().equals(JSP_SCR_QN)) {
                TagFilePageDataValidator.debug("jsp:scriptlet was found!");
                this._scrWasFound = (short)(this._scrWasFound + 1);
                this.checkJspIdAttribute(JSP_SCR_QN, attributes);
            } else if (qName.trim().equals(JSP_ATTRIBUTE_QN)) {
                TagFilePageDataValidator.debug("jsp:directive.attribute was found!");
                this._attributeDirectiveFound = (short)(this._attributeDirectiveFound + 1);
                this.checkJspIdAttribute(JSP_ATTRIBUTE_QN, attributes);
            } else if (qName.trim().equals(JSP_VARIABLE_QN)) {
                TagFilePageDataValidator.debug("jsp:directive.variable was found!");
                this._variableDirectiveFound = (short)(this._variableDirectiveFound + 1);
                this.checkJspIdAttribute(JSP_VARIABLE_QN, attributes);
            } else if (qName.trim().equals(JSP_TEXT_QN)) {
                TagFilePageDataValidator.debug("jsp:text was found!");
                this._textWasFound = (short)(this._textWasFound + 1);
                this.checkJspIdAttribute(JSP_TEXT_QN, attributes);
            } else if (qName.trim().equals(JSP_TAG_QN)) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = attributes.getLocalName(i).trim();
                    TagFilePageDataValidator.debug("jsp:directive.tag attribute name: " + name);
                    if (!name.equals("import")) continue;
                    TagFilePageDataValidator.debug("jsp:directive.tag was found!");
                    this._tagDirectiveFound = (short)(this._tagDirectiveFound + 1);
                }
                this.checkJspIdAttribute(JSP_TAG_QN, attributes);
            } else if (qName.trim().equals(JSP_INCL_QN)) {
                TagFilePageDataValidator.debug("jsp:directive.include was found!  This is a problem...");
                this._includeDirectiveFound = (short)(this._includeDirectiveFound + 1);
            }
        }

        public ValidationMessage[] getParsingResults() {
            TagFilePageDataValidator.debug("Processing the results of the parse operation...");
            ValidationMessage[] vMessages = null;
            ArrayList<Object> messageList = new ArrayList<Object>();
            if (this._attributeDirectiveFound == 0) {
                messageList.add("Unable to find the jsp:directive.attribute element in the XML view of the processed tag file.\n");
            }
            if (this._attributeDirectiveFound > 1) {
                messageList.add("Found " + this._attributeDirectiveFound + " jsp:directive.attribute elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._variableDirectiveFound == 0) {
                messageList.add("Unable to find the jsp:directive.variable element in the XML view of the processed tag file.\n");
            }
            if (this._variableDirectiveFound > 1) {
                messageList.add("Found " + this._variableDirectiveFound + " jsp:directive.variable elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._scrWasFound == 0) {
                messageList.add("Unable to find the jsp:scriptlet element in theXML view of the processed tag file.\n");
            }
            if (this._scrWasFound > 1) {
                messageList.add("Found " + this._scrWasFound + " jsp:scriplet elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._declWasFound == 0) {
                messageList.add("Unable to find the jsp:declaration element in the XML view of the processed tag file.\n");
            }
            if (this._declWasFound > 1) {
                messageList.add("Found " + this._declWasFound + " jsp:declaration elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._exprWasFound == 0) {
                messageList.add("Unable to find the jsp:expression element in the XML view of the tag file.\n");
            }
            if (this._exprWasFound > 1) {
                messageList.add("Found " + this._exprWasFound + " jsp:scriplet elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._tagLibWasFound == 0) {
                messageList.add("Unable to find the taglib call pagedatatagfile:test element in the XML view of the tag file.\n");
            }
            if (this._tagLibWasFound > 1) {
                messageList.add("Found " + this._tagLibWasFound + " pagedatatagfile:test elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._tagDeclWasFound == 0) {
                messageList.add("Unable to find the taglib declaration for uri 'http://java.sun.com/tck/jsp/pagedatatagfile' in the XML view of the tag file.\n");
            }
            if (this._tagDeclWasFound > 1) {
                messageList.add("Found " + this._tagDeclWasFound + " xmlns:pagedatatagfile attributes of the jsp:root element  in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._jspRootWasFound == 0) {
                messageList.add("Unable to find the jsp:root element in the XML view of the tag file.\n");
            }
            if (this._jspRootWasFound > 1) {
                messageList.add("Found " + this._jspRootWasFound + " jsp:root elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._textWasFound == 0) {
                messageList.add("Unable to find the jsp:text element in the XML view of the tag file.\n");
            }
            if (this._tagDirectiveFound == 0) {
                messageList.add("Unable to find the jsp:directive.tag element in the XML view of the tag file.\n");
            }
            if (this._tagDirectiveFound > 1) {
                messageList.add("Found " + this._tagDirectiveFound + " jsp:directive.tag elements in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._includeDirectiveFound != 0) {
                messageList.add("Unexpectedly found a jsp:directive.include element in the XML view of the tag file.\n");
            }
            if (this._jspNameSpaceFound == 0) {
                messageList.add("Unable to find JSP namespace xmlns:jsp with URI of 'http://java.sun.com/JSP/Page' in the XML view of the tag file.\n");
            }
            if (this._jspNameSpaceFound > 1) {
                messageList.add("Found " + this._jspNameSpaceFound + " JSP namespace attributes within the jsp:root element in the XML view of the processed tag file when 1 was expected.\n");
            }
            if (this._rtExprFound == 0) {
                messageList.add("Unable to find rt expression attribute in the 'dynAttribute' of pagedatatagfile:test tag invocation.\n");
            }
            if (this._rtExprFound > 1) {
                messageList.add("Found " + this._rtExprFound + " rt expressions in the XML view of the tag file, expected only 1.\n");
            }
            if (this._jspRootVersionFound == 0) {
                messageList.add("Unable to find the 'version' attribute with value '2.0' in the jsp:root element.\n");
            }
            if (this._jspRootVersionFound > 1) {
                messageList.add("The jsp:root element contained " + this._jspRootVersionFound + " attributes, where only 1 was expected.");
            }
            if (!this._jspIdAttributesFound) {
                messageList.add("The following elements did not contain a jsp:id attribute: " + this.getStringFromMap(this.elements));
            }
            if (messageList.size() != 0) {
                ArrayList<ValidationMessage> list = new ArrayList<ValidationMessage>();
                Iterator i = messageList.iterator();
                while (i.hasNext()) {
                    list.add(new ValidationMessage(null, (String)i.next()));
                }
                vMessages = list.toArray(new ValidationMessage[list.size()]);
            }
            return vMessages;
        }

        private void checkJspIdAttribute(String elementName, Attributes attributes) {
            if (!this.hasAttribute("jsp:id", null, attributes)) {
                Short sho = this.elements.get(elementName);
                if (sho == null) {
                    this.elements.put(elementName, (short)1);
                } else {
                    short s = sho;
                    s = (short)(s + 1);
                    this.elements.put(elementName, s);
                }
                this._jspIdAttributesFound = false;
            }
        }

        private boolean hasAttribute(String attrName, String attrValue, Attributes attributes) {
            TagFilePageDataValidator.debug("Scanning for attribute: [ " + attrName + ", " + attrValue + " ]");
            boolean found = false;
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String name = attributes.getQName(i).trim();
                String val = attributes.getValue(i).trim();
                TagFilePageDataValidator.debug("Available attribute: [ " + name + ", " + val + " ]");
                if (attrValue == null) {
                    if (!name.equals(attrName)) continue;
                    TagFilePageDataValidator.debug("Attribute found!");
                    found = true;
                    continue;
                }
                if (!name.equals(attrName) || !val.equals(attrValue)) continue;
                TagFilePageDataValidator.debug("Attribute found!");
                found = true;
            }
            return found;
        }

        private String getStringFromMap(Map<String, Short> map) {
            Iterator<Map.Entry<String, Short>> es = map.entrySet().iterator();
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            while (es.hasNext()) {
                Map.Entry<String, Short> entry = es.next();
                sb.append(entry.getKey() + " (" + entry.getValue() + ")");
                if (!es.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

