/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.el.jsp;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ELDeferredMethodStringLiteralTag
extends SimpleTagSupport {
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final String EXPECTEDSTR = "hello";
    private static final double EXPECTEDDBL = 3.1415926;
    private static final double EPSILON = 1.0E-8;
    private MethodExpression strExpr;
    private MethodExpression dblExpr;

    public void setStrExpr(MethodExpression strExpr) {
        this.strExpr = strExpr;
    }

    public void setDblExpr(MethodExpression dblExpr) {
        this.dblExpr = dblExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = this.getJspContext().getELContext();
        JspWriter out = this.getJspContext().getOut();
        boolean pass = true;
        try {
            double dblResult;
            Object objResult;
            String strResult = (String)this.strExpr.invoke(elContext, null);
            if (!strResult.equals(EXPECTEDSTR)) {
                pass = false;
                out.println("Test FAILED. Incorrect return value for strResult." + NL + "Expected value: hello" + NL + "Value returned: " + strResult);
            }
            if (!((objResult = this.dblExpr.invoke(elContext, null)) instanceof Double)) {
                pass = false;
                out.println("Test FAILED. Return value is not a Double:" + NL + objResult.getClass() + NL);
            }
            if (!(Math.abs((dblResult = ((Double)objResult).doubleValue()) - 3.1415926) < 1.0E-8)) {
                pass = false;
                out.println("Test FAILED. Incorrect value for dblResult." + NL + "Expected value: 3.1415926" + NL + "Value returned: " + dblResult);
            }
            if (pass) {
                out.println("Test PASSED.");
            }
        }
        catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "ELDeferredMethodStringLiteralTag");
        }
    }
}

