/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.StoredProcedureQuery;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee2;
import jakarta.persistence.StoredProcedureQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.AfterEach;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    List<Employee> empRef = new ArrayList<Employee>();
    List<Employee2> empRef2 = new ArrayList<Employee2>();
    Employee emp0 = null;
    Employee2 emp2 = null;
    final Date utilDate = this.getUtilDate("2000-02-14");
    final Calendar calDate = this.getCalDate(2000, 2, 14);
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        logger.log(System.Logger.Level.TRACE, "in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                logger.log(System.Logger.Level.TRACE, "Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    logger.log(System.Logger.Level.TRACE, "Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            logger.log(System.Logger.Level.TRACE, "Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Employee, instead got:" + o.getClass().getSimpleName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    logger.log(System.Logger.Level.TRACE, "rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            logger.log(System.Logger.Level.TRACE, "Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:");
                    for (Integer n : actual) {
                        logger.log(System.Logger.Level.TRACE, "id:" + n);
                    }
                    ++count;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
                for (Integer n : expected) {
                    logger.log(System.Logger.Level.ERROR, " Expected id:" + n);
                }
                for (Integer n : actual) {
                    logger.log(System.Logger.Level.ERROR, "Actual id:" + n);
                }
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + e);
            }
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
            for (Employee e : expected) {
                logger.log(System.Logger.Level.ERROR, "expected employee:" + e);
            }
            for (Employee e : actual) {
                logger.log(System.Logger.Level.ERROR, "actual employee :" + e);
            }
        }
        return result;
    }

    protected void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

