/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends Client {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = Client3.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", "ee.jakarta.tck.persistence.core.types.common.Grade"};
        return this.createDeploymentJar("jpa_core_annotations_access_field3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup3");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData3();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void createTestData3() {
        logger.log(System.Logger.Level.TRACE, "createTestData3");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 5);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transientTest() throws Exception {
        boolean pass = false;
        byte newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getTransient() == 0) {
                    logger.log(System.Logger.Level.TRACE, "First find returned expected result:" + this.d1.getTransient());
                    this.d1.setTransient(newByte);
                    this.getEntityManager().merge((Object)this.d1);
                    this.getEntityManager().flush();
                    this.clearCache();
                    this.d1 = null;
                    this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                    if (this.d1.getTransient() == 0) {
                        pass = true;
                        logger.log(System.Logger.Level.TRACE, "Second find returned expected value:" + this.d1.getTransient());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Second find expected:0, actual:" + this.d1.getTransient());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected first find to return:0, actual:" + this.d1.getTransient());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("transientTest failed");
        }
    }
}

