/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.property;

import ee.jakarta.tck.persistence.core.annotations.access.property.Client;
import ee.jakarta.tck.persistence.core.annotations.access.property.DataTypes;
import ee.jakarta.tck.persistence.core.annotations.access.property.DataTypes2;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends Client {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = Client1.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", "ee.jakarta.tck.persistence.core.types.common.Grade"};
        return this.createDeploymentJar("jpa_core_annotations_access_property1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest1() throws Exception {
        boolean pass = false;
        Character newChar = Character.valueOf('b');
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getCharacterData().equals(Character.valueOf('a'))) {
                this.d1.setCharacterData(newChar);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData().equals(newChar)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest2() throws Exception {
        boolean pass = false;
        Short newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getShortData().equals((short)100)) {
                this.d1.setShortData(newShort);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData().equals(newShort)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest3() throws Exception {
        boolean pass = false;
        Integer newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntegerData().equals(500)) {
                this.d1.setIntegerData(newInt);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntegerData().equals(newInt)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest4() throws Exception {
        boolean pass = false;
        Long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getLongData().equals(300L)) {
                this.d1.setLongData(newLong);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData().equals(newLong)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest5() throws Exception {
        boolean pass = false;
        Double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getDoubleData().equals(50.0)) {
                this.d1.setDoubleData(newDbl);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData().equals(newDbl)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest6() throws Exception {
        boolean pass = false;
        Float newFloat = Float.valueOf(3.0f);
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getFloatData().equals(Float.valueOf(1.0f))) {
                this.d1.setFloatData(newFloat);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData().equals(newFloat)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest6 failed");
        }
    }

    @Test
    public void propertyTypeTest7() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting enumData ");
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "Check results");
                if (null != this.d1 && this.d1.getEnumData().equals((Object)Grade.C)) {
                    logger.log(System.Logger.Level.TRACE, "Expected Grade of:" + this.d1.getEnumData() + "received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected C, got: " + this.d1.getEnumData());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest7 failed");
        }
    }

    @Test
    public void propertyTypeTest8() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d2 = null;
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                logger.log(System.Logger.Level.TRACE, "Check results");
                if (this.d2.getId().equals(this.dateId)) {
                    logger.log(System.Logger.Level.TRACE, "Got expected PK of:" + this.d2.getId() + "received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + this.dateId + ", got: " + this.d2.getId());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest9() throws Exception {
        boolean pass = false;
        Byte[] b = new Byte[]{(byte)31, (byte)32, (byte)33, (byte)63, (byte)64, (byte)65};
        Byte bv = 5;
        Object[] a = null;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + bv);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "Check results");
                if (null != this.d1 && Arrays.equals((Object[])this.d1.getByteArrayData(), a)) {
                    logger.log(System.Logger.Level.TRACE, "propertyTypeTest9: Expected results received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Unexpected result in array comparison.");
                    for (Object aByte : a) {
                        logger.log(System.Logger.Level.TRACE, "Array a in propertyTest9 equals: " + (Byte)aByte);
                    }
                    for (Byte bByte : b) {
                        logger.log(System.Logger.Level.TRACE, "Array b in propertyTest9 equals: " + (Byte)bByte);
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest9 failed");
        }
    }

    @Test
    public void propertyTypeTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Object[] charData = new Character[]{Character.valueOf('C'), Character.valueOf('T'), Character.valueOf('S')};
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting CharacterData ");
                this.d1.setCharArrayData((Character[])charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "propertyTypeTest10:  Check results");
                if (null != this.d1 && Arrays.equals((Object[])this.d1.getCharArrayData(), charData)) {
                    logger.log(System.Logger.Level.TRACE, "propertyTypeTest10: Expected Results Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString((Object[])this.d1.getCharArrayData()));
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest11() throws Exception {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d2 = null;
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "propertyTypeTest11:  Check results");
                if (null != this.d2 && this.d2.getTimeData().equals(timeValue)) {
                    logger.log(System.Logger.Level.TRACE, "propertyTypeTest11: Expected Time Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + timeValue + " , got: " + this.d2.getTimeData());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest12() throws Exception {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d2 = null;
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "propertyTypeTest12:  Check results");
                if (null != this.d2 && this.d2.getTsData().equals(tsValue)) {
                    logger.log(System.Logger.Level.TRACE, "propertyTypeTest12: Expected Timestamp Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + tsValue + " , got: " + this.d2.getTsData());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propertyTypeTest13() throws Exception {
        boolean pass = false;
        Boolean newBoolean = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.d1 = null;
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getBooleanData().equals(true)) {
                this.d1.setBooleanData(newBoolean);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getBooleanData().equals(newBoolean)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest13 failed");
        }
    }

    public void createTestData() {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            Character[] cArray = new Character[]{Character.valueOf('a')};
            Byte[] bArray = new Byte[]{(byte)100};
            this.d1 = new DataTypes(1, true, Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f), cArray, bArray);
            this.d2 = new DataTypes2(this.dateId);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

