/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.manyXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.manyXone.A;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_detach_manyXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detachMX1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detachMX1Test1");
        boolean pass = false;
        A aRef = new A("3", "a3", 3);
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            logger.log(System.Logger.Level.TRACE, "Call EntityManager.clear()");
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Call getEntityManager.contains to determine if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                logger.log(System.Logger.Level.TRACE, "entity is not detached, unexpected cannot proceed with test.");
            } else {
                try {
                    logger.log(System.Logger.Level.TRACE, "Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                    logger.log(System.Logger.Level.INFO, "Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.INFO, "received expected IllegalArgumentException when trying to persist a detached entity");
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    logger.log(System.Logger.Level.INFO, "EntityExistsException thrown trying to persist an existing entity");
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "or, Transaction commit will fail.   Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                logger.log(System.Logger.Level.INFO, "Received exception TransactionRolledbackException or PersistenceException");
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("detachMX1Test1 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

