/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidironexmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidironexmany.BiDir1XMPerson;
import ee.jakarta.tck.persistence.core.relationship.bidironexmany.BiDir1XMProject;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "BiDir1XMPerson", pkgName + "BiDir1XMProject"};
        return this.createDeploymentJar("jpa_core_relationship_bidironexmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void biDir1XMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin BiDir1X1Test1");
        boolean pass = false;
        try {
            BiDir1XMProject newProject2;
            this.getEntityTransaction().begin();
            BiDir1XMProject project1 = new BiDir1XMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDir1XMProject project2 = new BiDir1XMProject(2L, "Identity", Float.valueOf(500.0f));
            BiDir1XMPerson person = new BiDir1XMPerson(1L, "Duke");
            logger.log(System.Logger.Level.TRACE, "persisted Person Entity");
            Vector<BiDir1XMProject> projects = new Vector<BiDir1XMProject>();
            projects.add(project1);
            projects.add(project2);
            logger.log(System.Logger.Level.TRACE, "set Projects to Person");
            person.setProjects(projects);
            logger.log(System.Logger.Level.TRACE, "set Person to Projects");
            project1.setBiDir1XMPerson(person);
            project2.setBiDir1XMPerson(person);
            this.getEntityManager().persist((Object)person);
            logger.log(System.Logger.Level.TRACE, "persisted Person Entity");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            boolean pass1 = false;
            boolean pass2 = false;
            BiDir1XMProject newProject1 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)1L);
            if (newProject1 != null) {
                if (newProject1.getName().equals("JavaEE")) {
                    BiDir1XMPerson newPerson = newProject1.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            logger.log(System.Logger.Level.TRACE, "Found Expected Person Entity");
                            pass1 = true;
                        }
                    } else {
                        logger.log(System.Logger.Level.TRACE, "searched Person not Found");
                    }
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "searched Project not Found");
            }
            if ((newProject2 = (BiDir1XMProject)this.getEntityManager().find(BiDir1XMProject.class, (Object)2L)) != null) {
                if (newProject2.getName().equals("Identity")) {
                    BiDir1XMPerson newPerson = newProject2.getBiDir1XMPerson();
                    if (newPerson != null) {
                        if (newPerson.getName().equals("Duke")) {
                            logger.log(System.Logger.Level.TRACE, "Found Expected Person Entity");
                            pass2 = true;
                        }
                    } else {
                        logger.log(System.Logger.Level.TRACE, "searched Person not Found");
                    }
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "searched Project not Found");
            }
            if (pass1 && pass2) {
                logger.log(System.Logger.Level.TRACE, "biDir1X1Test1: Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("biDir1XMTest1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1XMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

