/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unionexmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unionexmany.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.relationship.unionexmany.Uni1XMProject;
import java.util.Collection;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Uni1XMPerson", pkgName + "Uni1XMProject"};
        return this.createDeploymentJar("jpa_core_relationship_unionexmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uni1XMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin uni1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Uni1XMProject project1 = new Uni1XMProject(1L, "JavaEE", Float.valueOf(500.0f));
            Uni1XMProject project2 = new Uni1XMProject(2L, "Identity", Float.valueOf(500.0f));
            Uni1XMPerson person = new Uni1XMPerson(1L, "Duke");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person);
            logger.log(System.Logger.Level.TRACE, "persisted Person and Projects");
            Vector<Uni1XMProject> projects = new Vector<Uni1XMProject>();
            projects.add(project1);
            projects.add(project2);
            person.setProjects(projects);
            this.getEntityManager().merge((Object)person);
            logger.log(System.Logger.Level.TRACE, "merged Contents of Person Entity");
            Uni1XMPerson newPerson = (Uni1XMPerson)this.getEntityManager().find(Uni1XMPerson.class, (Object)1L);
            boolean pass1 = false;
            boolean pass2 = false;
            if (newPerson != null) {
                Collection<Uni1XMProject> newProjects = newPerson.getProjects();
                for (Uni1XMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    pass2 = true;
                }
            }
            if (pass1 && pass2) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("uni1XMTest1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPERSON_UNI1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

