/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client.WSCCloseClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client.WSCEchoServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client.WSCErrorClientEndpoint;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 5511697770152558944L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_endpoint_client_web.war");
        archive.addClasses(new Class[]{OPS.class, WSCEchoServer.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_endpoint_client_web");
    }

    @Test
    public void onErrorWorksTest() throws Exception {
        WSCErrorClientEndpoint endpoint = new WSCErrorClientEndpoint();
        this.setClientEndpointInstance(endpoint);
        this.invoke("echo", OPS.ECHO_MSG, OPS.ECHO_MSG);
        WSClientIT.assertFalse(endpoint.onErrorCalled, "@OnError has been unexpectedly called");
        this.setCountDownLatchCount(2);
        this.setClientEndpointInstance(endpoint);
        this.invoke("echo", OPS.THROW, OPS.THROW);
        WSClientIT.assertTrue(endpoint.onErrorCalled, "@OnError has NOT been called after RuntimeException is thrown on @OnMessage");
        WSClientIT.logMsg("@OnError has been called after RuntimeException is thrown on @OnMessage as expected");
    }

    @Test
    public void onCloseWorksTest() throws Exception {
        WSCCloseClientEndpoint endpoint = new WSCCloseClientEndpoint();
        this.setClientEndpointInstance(endpoint);
        this.invoke("echo", (Object)OPS.ECHO_MSG.name(), OPS.ECHO_MSG.name(), false);
        WSClientIT.assertFalse(endpoint.onCloseCalled, "@OnClose has been unexpectedly called");
        this.cleanup();
        endpoint.waitForClose(this._ws_wait);
        WSClientIT.assertTrue(endpoint.onCloseCalled, "@OnClose has NOT been called after session.close()");
        WSClientIT.logMsg("@OnClose has been called after session.close() as expected");
    }
}

