/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.stmt.stmt3;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class stmtClient3
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.stmt.stmt3";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        stmtClient3 theTests = new stmtClient3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSetFetchSize05() throws Exception {
        int maxFetchSizeVal = 0;
        String sMaxFetchSizeVal = null;
        boolean sqlExceptFlag = false;
        try {
            sMaxFetchSizeVal = this.sqlp.getProperty("Max_Set_Val", "");
            maxFetchSizeVal = Integer.parseInt(sMaxFetchSizeVal);
            this.msg.setMsg("Maximum Value to be set as Fetch Size " + (maxFetchSizeVal *= -1));
            this.msg.setMsg("Calling setFetchSize method");
            try {
                this.stmt.setFetchSize(maxFetchSizeVal);
            }
            catch (SQLException sqle) {
                TestUtil.printStackTrace((Throwable)sqle);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("setFetchSize method does not set the invalid value ");
            } else {
                this.msg.printTestError("setFetchSize method sets the Invalid value ", "Call to setFetchSize is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setFetchSize is Failed!");
        }
    }

    public void testSetMaxFieldSize01() throws Exception {
        int maxFieldSizeVal = 0;
        String sMaxFieldSizeVal = null;
        int retVal = 0;
        try {
            sMaxFieldSizeVal = this.sqlp.getProperty("Max_Set_Val", "");
            maxFieldSizeVal = Integer.parseInt(sMaxFieldSizeVal);
            this.msg.setMsg("Maximum Field Size Value to be set " + (maxFieldSizeVal *= 256));
            this.msg.setMsg("Calling maxFieldSize method ");
            this.stmt.setMaxFieldSize(maxFieldSizeVal);
            this.msg.setMsg("invoke on the getMaxFieldSize");
            retVal = this.stmt.getMaxFieldSize();
            if (maxFieldSizeVal == retVal) {
                this.msg.setMsg("setMaxFieldSize method sets the value for Maximum Field Size");
            } else {
                this.msg.printTestError("setMaxFieldSize method does not set the value for Maximum Field Size", "Call to setMaxFieldSize is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setMaxFieldSize is Failed!");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setMaxFieldSize is Failed!");
        }
    }

    public void testSetMaxFieldSize02() throws Exception {
        int maxFieldSizeVal = 0;
        String sMaxFieldSizeVal = null;
        boolean sqlExceptFlag = false;
        try {
            sMaxFieldSizeVal = this.sqlp.getProperty("Max_Set_Val", "");
            maxFieldSizeVal = Integer.parseInt(sMaxFieldSizeVal);
            this.msg.setMsg("Rows Value to be set " + (maxFieldSizeVal *= -1));
            this.msg.setMsg("Calling the setMaxFieldSize method");
            try {
                this.stmt.setMaxFieldSize(maxFieldSizeVal);
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("setMaxFieldSize method does not set the Invalid value ");
            } else {
                this.msg.printTestError("setMaxFieldSize method sets the Invalid value", "Call to setMaxFieldSize is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setMaxFieldSize is Failed!");
        }
    }

    public void testSetMaxRows01() throws Exception {
        int maxRowsVal = 0;
        String sMaxRowsVal = null;
        int retVal = 0;
        try {
            sMaxRowsVal = this.sqlp.getProperty("Max_Set_Val", "");
            this.msg.setMsg("sMaxRowsVal = " + sMaxRowsVal);
            maxRowsVal = Integer.parseInt(sMaxRowsVal);
            this.msg.setMsg("Maximum Rows Value to be set " + maxRowsVal);
            this.msg.setMsg("Calling setMaxRows method");
            this.stmt.setMaxRows(maxRowsVal);
            this.msg.setMsg("invoke getMaxRows");
            retVal = this.stmt.getMaxRows();
            String str1 = "maxRowsVal = " + maxRowsVal + ".   retVal = " + retVal + ".";
            this.msg.setMsg(str1);
            if (maxRowsVal == retVal) {
                this.msg.setMsg("setMaxRows method sets the value for Maximum Rows");
            } else {
                this.msg.printTestError("setMaxRows method does not set the value for Maximum Rows", "Call to setMaxRows is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setMaxRows is Failed!");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setMaxRows is Failed!");
        }
    }

    public void testSetMaxRows02() throws Exception {
        int maxRowsVal = 0;
        String sMaxRowsVal = null;
        boolean sqlExceptFlag = false;
        try {
            sMaxRowsVal = this.sqlp.getProperty("Max_Set_Val", "");
            maxRowsVal = Integer.parseInt(sMaxRowsVal);
            this.msg.setMsg("Rows Value to be set " + (maxRowsVal *= -1));
            this.msg.setMsg("Calling setMaxRows method");
            try {
                this.stmt.setMaxRows(maxRowsVal);
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("setMaxRows method does not set the Invalid value");
            } else {
                this.msg.printTestError("setMaxRows method sets the Invalid value", "Call to setMaxRows is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setMaxRows is Failed!");
        }
    }

    public void testSetQueryTimeout02() throws Exception {
        int maxQueryTimeVal = 0;
        String sMaxQueryTimeVal = null;
        boolean sqlExceptFlag = false;
        try {
            sMaxQueryTimeVal = this.sqlp.getProperty("Max_Set_Val", "");
            maxQueryTimeVal = Integer.parseInt(sMaxQueryTimeVal);
            this.msg.setMsg("Seconds Value to be set as QueryTimeout " + (maxQueryTimeVal *= -1));
            this.msg.setMsg("Calling maxQueryTimeout method");
            try {
                this.stmt.setQueryTimeout(maxQueryTimeVal);
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("setQueryTimeout method does not set the Invalid value");
            } else {
                this.msg.printTestError("setQueryTimeout method sets the Invalid value", "Call to setQueryTimeout is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg.printError(e, "Call to setQueryTimeout is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.conn.close();
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

