/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet41;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient41
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet41";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient41 theTests = new resultSetClient41();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBoolean67() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Bit_Query_Max", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getBoolean(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getBoolean Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            boolean oRetVal = oRes.getBoolean(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            boolean oExtVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getBoolean returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getBoolean did not return the Maximum Value", "test getBoolean Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBoolean is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBoolean68() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Bit_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getBoolean(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getBoolean Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            boolean oRetVal = oRes.getBoolean(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            boolean oExtVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getBoolean returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getBoolean did not return the Minimum Value", "test getBoolean Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBoolean is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBoolean69() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Bit_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getBoolean(NullValue)");
            this.msg.setMsg("get the Null value from the table using getBoolean Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            boolean oRetVal = oRes.getBoolean(sColName);
            if (!oRetVal) {
                this.msg.setMsg("Calling getBoolean method on a SQL Null column returns boolean " + oRetVal);
            } else {
                this.msg.printTestError("getBoolean did not return the boolean value false", "test getBoolean Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBoolean is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

