/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.permissiondd;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.work.WorkManager;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.PropertyPermission;
import javax.transaction.xa.Xid;

public class PermissionDDWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private Xid myxid;
    private Xid mynestxid;

    public PermissionDDWorkManager(BootstrapContext val) {
        this.debug("enterred constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("enterred runTests");
        this.validateRequiredPermSet();
        this.validateRestrictedLocalPerm();
        this.debug("leaving runTests");
    }

    public void validateRequiredPermSet() {
        try {
            RuntimePermission rtperm = new RuntimePermission("loadLibrary.*");
            this.doCheckPermission(rtperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm.toString());
            RuntimePermission rtperm2 = new RuntimePermission("queuePrintJob");
            this.doCheckPermission(rtperm2);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm2.toString());
            SocketPermission socperm = new SocketPermission("*", "connect");
            this.doCheckPermission(socperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + socperm.toString());
            FilePermission fperm = new FilePermission("*", "read");
            this.doCheckPermission(fperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + fperm.toString());
            PropertyPermission pperm = new PropertyPermission("*", "read");
            this.doCheckPermission(pperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + pperm.toString());
            this.debug("SUCCESS:  validateRequiredPermSet passed.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateRequiredPermSet passed.");
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRequiredPermSet had unexpected Exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRequiredPermSet had unexpected Exception.");
            Debug.printDebugStack(ex);
        }
        this.debug("returning from validateRequiredPermSet()");
    }

    public void validateRestrictedLocalPerm() {
        try {
            PropertyPermission readPropertyPerm = new PropertyPermission("TestPropertyPerm", "read");
            this.doCheckPermission(readPropertyPerm);
            this.debug("SUCCESS:  validateRestrictedLocalPerm() has grant for read of TestPropertyPerm");
            this.debug("SUCCESS:  validateRestrictedLocalPerm passed.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateRestrictedLocalPerm passed.");
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRestrictedLocalPerm had unexpected exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRestrictedLocalPerm had unexpected exception.");
            Debug.printDebugStack(ex);
        }
        this.debug("returning from validateRestrictedLocalPerm()");
    }

    public void doCheckPermission(Permission pp) throws Exception {
    }

    public void setXid(Xid xid) {
        this.myxid = xid;
    }

    public Xid getXid() {
        return this.myxid;
    }

    public void setNestXid(Xid xid) {
        this.mynestxid = xid;
    }

    public Xid getNestXid() {
        return this.mynestxid;
    }

    public void debug(String out) {
        Debug.trace("PermissionDDWorkManager:  " + out);
    }
}

