/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta7;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient7
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta7";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient7 theTests = new dbMetaClient7();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsUnionAll() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsUnionAll");
            boolean retValue = this.dbmd.supportsUnionAll();
            if (retValue) {
                this.msg.setMsg("supportsUnionAll is supported");
            } else {
                this.msg.setMsg("supportsUnionAll is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsUnionAll is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsUnionAll is Failed!");
        }
    }

    public void testSupportsOpenCursorsAcrossCommit() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsOpenCursorsAcrossCommit");
            boolean retValue = this.dbmd.supportsOpenCursorsAcrossCommit();
            if (retValue) {
                this.msg.setMsg("supportsOpenCursorsAcrossCommit is supported");
            } else {
                this.msg.setMsg("supportsOpenCursorsAcrossCommit is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOpenCursorsAcrossCommit is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOpenCursorsAcrossCommit is Failed!");
        }
    }

    public void testSupportsOpenCursorsAcrossRollback() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsOpenCursorsAcrossRollback");
            boolean retValue = this.dbmd.supportsOpenCursorsAcrossRollback();
            if (retValue) {
                this.msg.setMsg("supportsOpenCursorsAcrossRollback is supported");
            } else {
                this.msg.setMsg("supportsOpenCursorsAcrossRollback is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOpenCursorsAcrossRollback is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOpenCursorsAcrossRollback is Failed!");
        }
    }

    public void testSupportsOpenStatementsAcrossCommit() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsOpenStatementsAcrossCommit");
            boolean retValue = this.dbmd.supportsOpenStatementsAcrossCommit();
            if (retValue) {
                this.msg.setMsg("supportsOpenStatementsAcrossCommit is supported");
            } else {
                this.msg.setMsg("supportsOpenStatementsAcrossCommit is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOpenStatementsAcrossCommit is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOpenStatementsAcrossCommit is Failed!");
        }
    }

    public void testSupportsOpenStatementsAcrossRollback() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsOpenStatementsAcrossRollback");
            boolean retValue = this.dbmd.supportsOpenStatementsAcrossRollback();
            if (retValue) {
                this.msg.setMsg("supportsOpenStatementsAcrossRollback is supported");
            } else {
                this.msg.setMsg("supportsOpenStatementsAcrossRollback is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOpenStatementsAcrossRollback is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOpenStatementsAcrossRollback is Failed!");
        }
    }

    public void testGetMaxBinaryLiteralLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxBinaryLiteralLength");
            int nRetval = this.dbmd.getMaxBinaryLiteralLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxBinaryLiteralLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxBinaryLiteralLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxBinaryLiteralLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxBinaryLiteralLength is Failed!");
        }
    }

    public void testGetMaxCharLiteralLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxCharLiteralLength");
            int nRetval = this.dbmd.getMaxCharLiteralLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxCharLiteralLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxCharLiteralLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxCharLiteralLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxCharLiteralLength is Failed!");
        }
    }

    public void testGetMaxColumnNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnNameLength");
            int nRetval = this.dbmd.getMaxColumnNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxColumnNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxColumnNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnNameLength is Failed!");
        }
    }

    public void testGetMaxColumnsInGroupBy() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnsInGroupBy");
            int nRetval = this.dbmd.getMaxColumnsInGroupBy();
            if (nRetval < 0) {
                this.msg.printTestError("getMaxColumnsInGroupBy returns a negative value", " testGetMaxColumnsInGroupBy Failed");
            } else {
                this.msg.setMsg("getMaxColumnsInGroupBy returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnsInGroupBy is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnsInGroupBy is Failed!");
        }
    }

    public void testGetMaxColumnsInIndex() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnsInIndex");
            int nRetval = this.dbmd.getMaxColumnsInIndex();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxColumnsInIndex returns a negative value");
            } else {
                this.msg.setMsg("getMaxColumnsInIndex returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnsInIndex is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnsInIndex is Failed!");
        }
    }

    public void testGetMaxColumnsInOrderBy() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnsInOrderBy");
            int nRetval = this.dbmd.getMaxColumnsInOrderBy();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxColumnsInOrderBy returns a negative value");
            } else {
                this.msg.setMsg("getMaxColumnsInOrderBy returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnsInOrderBy is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnsInOrderBy is Failed!");
        }
    }

    public void testGetMaxColumnsInSelect() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnsInSelect");
            int nRetval = this.dbmd.getMaxColumnsInSelect();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxColumnsInSelect returns a negative value");
            } else {
                this.msg.setMsg("getMaxColumnsInSelect returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnsInSelect is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnsInSelect is Failed!");
        }
    }

    public void testGetMaxColumnsInTable() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxColumnsInTable");
            int nRetval = this.dbmd.getMaxColumnsInTable();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxColumnsInTable returns a negative value");
            } else {
                this.msg.setMsg("getMaxColumnsInTable returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxColumnsInTable is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxColumnsInTable is Failed!");
        }
    }

    public void testGetMaxConnections() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxConnections");
            int nRetval = this.dbmd.getMaxConnections();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxConnections returns a negative value");
            } else {
                this.msg.setMsg("getMaxConnections returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxConnections is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxConnections is Failed!");
        }
    }

    public void testGetMaxCursorNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxCursorNameLength");
            int nRetval = this.dbmd.getMaxCursorNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxCursorNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxCursorNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxCursorNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxCursorNameLength is Failed!");
        }
    }

    public void testGetMaxIndexLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxIndexLength");
            int nRetval = this.dbmd.getMaxIndexLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxIndexLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxIndexLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxIndexLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxIndexLength is Failed!");
        }
    }

    public void testGetMaxSchemaNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxSchemaNameLength");
            int nRetval = this.dbmd.getMaxSchemaNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxSchemaNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxSchemaNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxSchemaNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxSchemaNameLength is Failed!");
        }
    }

    public void testGetMaxProcedureNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxProcedureNameLength");
            int nRetval = this.dbmd.getMaxProcedureNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxProcedureNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxProcedureNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxProcedureNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxProcedureNameLength is Failed!");
        }
    }

    public void testGetMaxCatalogNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxCatalogNameLength");
            int nRetval = this.dbmd.getMaxCatalogNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxCatalogNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxCatalogNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxCatalogNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxCatalogNameLength is Failed!");
        }
    }

    public void testGetMaxRowSize() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxRowSize");
            int nRetval = this.dbmd.getMaxRowSize();
            if (nRetval < 0) {
                this.msg.printTestError("getMaxRowSize returns a negative value", "testGetMaxRowSize Failed!");
            } else {
                this.msg.setMsg("getMaxRowSize returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxRowSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxRowSize is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

