/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Util;
import ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery.A;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;

public class Client4
extends Util {
    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void fromGetStringIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("value").get("value2");
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: ", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!pass) {
            throw new Exception("fromGetStringIllegalStateExceptionTest failed");
        }
    }

    public void pathGetStringIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            Path path = cquery.from(A.class).get("value");
            try {
                path.get("value2");
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: ", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!pass) {
            throw new Exception("pathGetStringIllegalStateExceptionTest failed");
        }
    }

    public void fromGetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("doesnotexist");
                this.logErr("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException ise) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception: ", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!pass) {
            throw new Exception("fromGetStringIllegalArgumentExceptionTest failed");
        }
    }

    public void fromGetModelTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String expected = "ee.jakarta.tck.persistence.common.schema30.Customer";
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            EntityType bind = cquery.from(Customer.class).getModel();
            String name = bind.getBindableJavaType().getName();
            if (name.equals(expected)) {
                this.logTrace("Received expected name:" + name);
                pass = true;
            } else {
                this.logErr("Expected:" + expected + ", actual:" + name);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!pass) {
            throw new Exception("fromGetModelTest failed");
        }
    }

    public void pathGetIllegalArgumentException() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            customer.get("doesnotexist");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
        }
        if (!pass) {
            throw new Exception("pathGetIllegalArgumentException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdateIllegalStateException1Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cb.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cb.equal((Expression)order.get("id"), (Object)"1"));
            this.getEntityManager().createQuery(cquery).executeUpdate();
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("executeUpdateIllegalStateException1Test failed");
        }
    }
}

