/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.schema30;

import ee.jakarta.tck.persistence.common.schema30.CreditCard;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.LineItemException;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Entity
@Table(name="ORDER_TABLE")
public class Order
implements Serializable,
Comparable<Order> {
    private String id;
    private double totalPrice;
    private Customer customer;
    private CreditCard creditCard;
    private LineItem sampleLineItem;
    private Collection<LineItem> lineItemsCollection = new ArrayList<LineItem>();
    private List<LineItem> lineItemsList = new ArrayList<LineItem>();
    private Set<LineItem> lineItemsSet = new HashSet<LineItem>();

    public Order() {
    }

    public Order(String id, double totalPrice) {
        this.id = id;
        this.totalPrice = totalPrice;
    }

    public Order(String id, Customer customer) {
        this.id = id;
        this.customer = customer;
    }

    public Order(String id) {
        this.id = id;
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="TOTALPRICE")
    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double price) {
        this.totalPrice = price;
    }

    @ManyToOne
    @JoinColumn(name="FK4_FOR_CUSTOMER_TABLE")
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @OneToOne(mappedBy="order")
    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(CreditCard cc) {
        this.creditCard = cc;
    }

    @OneToOne(cascade={CascadeType.REMOVE})
    @JoinColumn(name="FK0_FOR_LINEITEM_TABLE")
    public LineItem getSampleLineItem() {
        return this.sampleLineItem;
    }

    public void setSampleLineItem(LineItem l) {
        this.sampleLineItem = l;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="order")
    public Collection<LineItem> getLineItemsCollection() {
        return this.lineItemsCollection;
    }

    public void setLineItemsCollection(Collection<LineItem> c) {
        this.lineItemsCollection = c;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="order")
    public List<LineItem> getLineItemsList() {
        return this.lineItemsList;
    }

    public void setLineItemsList(List<LineItem> l) {
        this.lineItemsList = l;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="order")
    public Set<LineItem> getLineItemsSet() {
        return this.lineItemsSet;
    }

    public void setLineItemsSet(Set<LineItem> s) {
        this.lineItemsSet = s;
    }

    public void addLineItem(LineItem p) throws LineItemException {
        this.getLineItemsCollection().add(p);
    }

    public void addSampleLineItem(LineItem p) throws LineItemException {
        this.setSampleLineItem(p);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", totalPrice: " + this.getTotalPrice());
        result.append(", lineitem.id[");
        boolean found = false;
        StringBuilder tmp = new StringBuilder();
        for (LineItem li : this.getLineItemsCollection()) {
            found = true;
            tmp.append(li.getId() + ",");
        }
        if (found) {
            result.append(tmp.toString().substring(0, tmp.length() - 1));
        }
        result.append("]");
        if (this.getCustomer() != null) {
            result.append(", custId: " + this.getCustomer().getId());
            result.append(", custName: " + this.getCustomer().getName());
        } else {
            result.append(", custId: null");
            result.append(", custName: null");
        }
        if (this.getCreditCard() != null) {
            result.append(", cc: " + this.getCreditCard().getId());
            result.append(", type: " + this.getCreditCard().getType());
        } else {
            result.append(", cc: null");
            result.append(", type: null");
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof Order)) {
            return result;
        }
        Order other = (Order)o;
        if (this.getId().equals(other.getId()) && this.getCreditCard().getId().equals(other.getCreditCard().getId()) && this.getCustomer().getId().equals(other.getCustomer().getId())) {
            result = true;
        }
        return result;
    }

    @Override
    public int compareTo(Order order) {
        int lastCmp = Integer.valueOf(this.getId()).compareTo(Integer.valueOf(order.getId()));
        return lastCmp != 0 ? lastCmp : Integer.valueOf(this.getId()).compareTo(Integer.valueOf(order.getId()));
    }
}

