/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.datasource.global;

import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.ComponentBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.DataSourceIF;
import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.DataSourceTest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.UserTransaction;
import javax.sql.DataSource;

@Singleton
@Startup
@TransactionManagement(value=TransactionManagementType.BEAN)
@Local(value={DataSourceIF.class})
@DataSourceDefinition(name="java:global/jdbc/DB3", className="org.apache.derby.jdbc.ClientDataSource", portNumber=1527, serverName="localhost", databaseName="derbyDB", user="cts1", transactional=false, password="cts1", properties={})
public class DataSourceBean
extends ComponentBase {
    @Resource(lookup="java:global/jdbc/DB3")
    private DataSource db3;
    @Resource
    private UserTransaction ut;

    @PostConstruct
    private void postConstruct() {
        boolean c = true;
        this.getPostConstructRecords().append(String.format("In postConstruct of %s%n", this));
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, "java:global/jdbc/DB3");
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, this.db3);
    }

    @Override
    public StringBuilder getConnection() {
        StringBuilder sb = new StringBuilder();
        try {
            this.ut.begin();
            DataSourceTest.verifyDataSource(this.getPostConstructRecords(), true, this.db3);
            this.ut.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb;
    }
}

