/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.elprocessor;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "elprocessor_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="elprocessor_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"elprocessor_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ELClientServletTest.class, BareBonesELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elProcessorDefineFunctionNPETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        try {
            Method meth = elp.getClass().getMethod("toString", new Class[0]);
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(null, function, meth)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{null, "function", meth});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(prefix, null, meth)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{"prefix", null, meth});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(prefix, function, null)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{"prefix", "function", null});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(prefix, function, className, null)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "className", null});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(prefix, function, null, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", null, "method"});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(prefix, null, className, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", null, "className", "method"});
            TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(null, function, className, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{null, "function", "className", "method"});
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elProcessorDefineFunctionCNFETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(null, function, className, method)");
        ELTestUtil.checkForCNFE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "bogus", "method"});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elProcessorDefineFunctionNSMETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        TestUtil.logMsg((String)"Testing: ELProcessor.defineFunction(null, function, className, method)");
        ELTestUtil.checkForCNFE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "java.util.String", "bogus"});
    }
}

