/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.valueexpression;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.api.jakarta_el.valueexpression.Worker;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "valueexpression_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private Hashtable<Class<?>, Object> testValueTable;
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="valueexpression_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"valueexpression_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ExpressionTest.class, BarELResolver.class, ResolverTest.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TCKFunctionMapper.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class, FunctionELResolver.class, Worker.class, ELClientServletTest.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public ELClientServletTest() {
        this.initializeTable();
        this.testProps = System.getProperties();
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
        this.initializeTable();
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void positiveValueExpressionTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            ELResolver resolver = context.getELResolver();
            resolver.setValue(context, null, (Object)"foo", (Object)"bar");
            buf.append("Testing expression 1 " + TestUtil.NEW_LINE);
            String exprStr1 = "${foo}";
            ValueExpression vexp1 = expFactory.createValueExpression(context, exprStr1, String.class);
            pass1 = ExpressionTest.testValueExpression((ValueExpression)vexp1, (ELContext)context, (String)exprStr1, String.class, (Object)"bar", (boolean)false, (boolean)false, (StringBuffer)buf);
            buf.append("Testing expression 2 " + TestUtil.NEW_LINE);
            String exprStr2 = "foo";
            ValueExpression vexp2 = expFactory.createValueExpression(context, exprStr2, String.class);
            pass2 = ExpressionTest.testValueExpression((ValueExpression)vexp2, (ELContext)context, (String)exprStr2, String.class, (Object)"foo", (boolean)true, (boolean)true, (StringBuffer)buf);
            buf.append("Testing expression 3 " + TestUtil.NEW_LINE);
            String exprStr3 = "#{1 + 1}";
            ValueExpression vexp3 = expFactory.createValueExpression(context, exprStr3, Integer.class);
            pass3 = ExpressionTest.testValueExpression((ValueExpression)vexp3, (ELContext)context, (String)exprStr3, Integer.class, (Object)2, (boolean)true, (boolean)false, (StringBuffer)buf);
            buf.append("Testing expression 4 " + TestUtil.NEW_LINE);
            pass4 = true;
            VRContext contextTwo = new VRContext(this.testProps);
            String exprStr4 = "#{worker.lastName}";
            ValueExpression vexp4 = expFactory.createValueExpression((ELContext)contextTwo, exprStr4, String.class);
            ValueReference vr = vexp4.getValueReference((ELContext)contextTwo);
            if (vr == null) {
                pass4 = false;
                buf.append("ValueRefernce should have return a non null value.");
            } else {
                String baseName;
                Object base = vr.getBase();
                if (base != null && !"Worker".equals(baseName = base.getClass().getSimpleName())) {
                    buf.append("Unexpected Base Value!" + TestUtil.NEW_LINE + "Expected: Worker" + TestUtil.NEW_LINE + "Received: " + baseName);
                    pass4 = false;
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void negativeValueExpressionTest() throws Exception {
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext simpleContext = new SimpleELContext().getELContext();
        ELContext emptyContext = new BareBonesELContext().getELContext();
        ELResolver resolver = simpleContext.getELResolver();
        try {
            resolver.setValue(simpleContext, null, (Object)"foo", (Object)"bar");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        String exprStr = "${foo}";
        ValueExpression vexp = expFactory.createValueExpression(simpleContext, exprStr, String.class);
        try {
            vexp.getValue(null);
            pass = false;
            TestUtil.logErr((String)("Call to getValue() with null ELContext parameter did not" + TestUtil.NEW_LINE + " cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getValue() with null ELContext parameter caused an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + " NullPointerException: " + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.setValue(null, (Object)"foo");
            pass = false;
            TestUtil.logErr((String)("Call to setValue() with null ELContext parameter did not" + TestUtil.NEW_LINE + " cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to setValue() with null ELContext parameter caused" + TestUtil.NEW_LINE + " an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + " NullPointerException: " + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.isReadOnly(null);
            pass = false;
            TestUtil.logErr((String)("Call to isReadOTestUtil.NEW_LINEy() with null ELContext parameter did not" + TestUtil.NEW_LINE + " cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to isReadOTestUtil.NEW_LINEy() with null ELContext parameter caused" + TestUtil.NEW_LINE + "an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + "NullPointerException: " + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.getType(null);
            pass = false;
            TestUtil.logErr((String)("Call to getType() with null ELContext parameter did not" + TestUtil.NEW_LINE + "cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (NullPointerException npe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getType() with null ELContext parameter caused" + TestUtil.NEW_LINE + "an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + "NullPointerException: " + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.setValue(emptyContext, (Object)"foo");
            pass = false;
            TestUtil.logErr((String)("Call to setValue() for non-existent property did not cause" + TestUtil.NEW_LINE + "an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to setValue() for non-existent property caused an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + "PropertyNotFoundException: " + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.getValue(emptyContext);
            pass = false;
            TestUtil.logErr((String)("Call to getValue() for non-existent property did not cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getValue() for non-existent property caused an exception to be thrown, but it was not a PropertyNotFoundException: " + TestUtil.NEW_LINE + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.isReadOnly(emptyContext);
            pass = false;
            TestUtil.logErr((String)("Call to isReadOTestUtil.NEW_LINEy() for non-existent property did not cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to isReadOTestUtil.NEW_LINEy() for non-existent property caused an exception to be thrown, but it was not a PropertyNotFoundException: " + TestUtil.NEW_LINE + e.toString() + TestUtil.NEW_LINE));
        }
        try {
            vexp.getType(emptyContext);
            pass = false;
            TestUtil.logErr((String)("Call to getType() for non-existent property did not cause an exception to be thrown" + TestUtil.NEW_LINE));
        }
        catch (PropertyNotFoundException pnfe) {
            pass = true;
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Call to getType() for non-existent property caused an exception to be thrown, but it was not a" + TestUtil.NEW_LINE + " PropertyNotFoundException: " + e.toString() + TestUtil.NEW_LINE));
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void valueExpressionSerializableTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        Enumeration<Class<?>> keys = this.testValueTable.keys();
        while (keys.hasMoreElements()) {
            boolean pass = true;
            Class<?> testClass = keys.nextElement();
            Object testValue = this.testValueTable.get(testClass);
            try {
                ExpressionFactory expFactory = ExpressionFactory.newInstance();
                ELContext context = new SimpleELContext().getELContext();
                ValueExpression evalvexp = expFactory.createValueExpression(context, "${" + testValue + "}", testClass);
                TestUtil.logTrace((String)("Eval Value Expression For Testing: " + evalvexp.toString() + TestUtil.NEW_LINE));
                ValueExpression literalvexp = expFactory.createValueExpression(context, "\"" + testValue + "\"", testClass);
                TestUtil.logTrace((String)("Literal Value Expression For Testing: " + literalvexp.toString() + TestUtil.NEW_LINE));
                ValueExpression compositevexp = expFactory.createValueExpression(context, "#{" + testValue + "} " + testValue, testClass);
                TestUtil.logTrace((String)("Composite Value Expression For Testing: " + compositevexp.toString() + TestUtil.NEW_LINE));
                if (!(ExpressionTest.expressionSerializableTest((Expression)evalvexp, (StringBuffer)buf) && ExpressionTest.expressionSerializableTest((Expression)literalvexp, (StringBuffer)buf) && ExpressionTest.expressionSerializableTest((Expression)compositevexp, (StringBuffer)buf))) {
                    pass = false;
                    break;
                }
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
            if (pass) {
                TestUtil.logTrace((String)buf.toString());
                continue;
            }
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    private void initializeTable() {
        this.testValueTable = new Hashtable();
        this.testValueTable.put(String.class, "SERIAL");
        this.testValueTable.put(Integer.class, Integer.valueOf("123"));
        this.testValueTable.put(Boolean.class, Boolean.TRUE);
    }

    @Test
    @TargetVehicle(value="servlet")
    public void valueExpressionEqualsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        try {
            ValueExpression vexp10;
            ValueExpression vexp8;
            ValueExpression vexp6;
            ValueExpression vexp4;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext context = new SimpleELContext();
            ELResolver resolver = context.getELResolver();
            String exprStr1 = "${foo}";
            String exprStr2 = "${bar}";
            resolver.setValue((ELContext)context, null, (Object)"foo", (Object)"SOME VALUE");
            resolver.setValue((ELContext)context, null, (Object)"bar", (Object)"SOME VALUE");
            ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, exprStr1, String.class);
            ValueExpression vexp2 = expFactory.createValueExpression((ELContext)context, exprStr2, String.class);
            buf.append("vexp1 has value " + (String)vexp1.getValue((ELContext)context) + TestUtil.NEW_LINE);
            buf.append("vexp2 has value " + (String)vexp2.getValue((ELContext)context) + TestUtil.NEW_LINE);
            if (ExpressionTest.equalsTest((Expression)vexp1, (Expression)vexp2, (StringBuffer)buf)) {
                pass = false;
                buf.append("Failed: case 1: same type and equal value" + TestUtil.NEW_LINE);
            }
            String exprStr3 = "${A+B+C}";
            String exprStr4 = "${ A + B\t+\t\tC\t}";
            ValueExpression vexp3 = expFactory.createValueExpression((ELContext)context, exprStr3, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp3, (Expression)(vexp4 = expFactory.createValueExpression((ELContext)context, exprStr4, Object.class)), (StringBuffer)buf)) {
                buf.append("Failed: case 2: white space" + TestUtil.NEW_LINE);
                pass = false;
            }
            String exprStr5 = "${A < B}";
            String exprStr6 = "${A lt B}";
            ValueExpression vexp5 = expFactory.createValueExpression((ELContext)context, exprStr5, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp5, (Expression)(vexp6 = expFactory.createValueExpression((ELContext)context, exprStr6, Object.class)), (StringBuffer)buf)) {
                buf.append("Failed: case 3: equivalent operators" + TestUtil.NEW_LINE);
                pass = false;
            }
            String exprStr7 = "${A + B}";
            String exprStr8 = "${B + A}";
            ValueExpression vexp7 = expFactory.createValueExpression((ELContext)context, exprStr7, Object.class);
            if (ExpressionTest.equalsTest((Expression)vexp7, (Expression)(vexp8 = expFactory.createValueExpression((ELContext)context, exprStr8, Object.class)), (StringBuffer)buf)) {
                buf.append("Failed: case 4: reversed operands" + TestUtil.NEW_LINE);
                pass = false;
            }
            String exprStr9 = "${A}";
            String exprStr10 = "#{A}";
            ValueExpression vexp9 = expFactory.createValueExpression((ELContext)context, exprStr9, Object.class);
            if (!ExpressionTest.equalsTest((Expression)vexp9, (Expression)(vexp10 = expFactory.createValueExpression((ELContext)context, exprStr10, Object.class)), (StringBuffer)buf)) {
                buf.append("Failed: case 5: delimiters" + TestUtil.NEW_LINE);
                pass = false;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }
}

