/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.util;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ExprEval {
    private ExprEval() {
    }

    public static String buildElExpr(boolean deferred, String operation) {
        Object sandwich = null;
        sandwich = operation == null ? "{A}" : ("unary_minus".equals(operation) ? "{-A}" : ("unary_not".equals(operation) ? "{not A}" : ("unary_bang".equals(operation) ? "{! A}" : ("empty".equals(operation) ? "{empty A}" : ("conditional".equals(operation) ? "{A ?B: C}" : "{A " + operation + " B}")))));
        return deferred ? "#" + (String)sandwich : "$" + (String)sandwich;
    }

    public static Object evaluateValueExpression(String exprStr, NameValuePair[] nameVals, Class expectedClass, ResolverType resolverType) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(resolverType).getELContext();
        ELResolver resolver = context.getELResolver();
        ExprEval.cleanup();
        if (nameVals == null) {
            resolver.setValue(context, null, (Object)"A", null);
            TestUtil.logTrace((String)"setting var 'A' to value null");
            resolver.setValue(context, null, (Object)"B", null);
            TestUtil.logTrace((String)"setting var 'B' to value null");
        } else {
            for (int i = 0; i < nameVals.length; ++i) {
                String name = nameVals[i].getName();
                Object val = nameVals[i].getValue();
                TestUtil.logTrace((String)("setting var " + name + " to value " + val));
                resolver.setValue(context, null, (Object)name, val);
            }
        }
        TestUtil.logTrace((String)"Creating ValueExpression");
        TestUtil.logTrace((String)("context is " + context.getClass().toString()));
        TestUtil.logTrace((String)("exprStr is " + exprStr));
        TestUtil.logTrace((String)("expectedClass is " + expectedClass.toString()));
        TestUtil.logTrace((String)("resolver is " + context.getELResolver().getClass().toString()));
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        return vexp.getValue(context);
    }

    public static Object evaluateValueExpression(String exprStr, NameValuePair[] nameVals, Class expectedClass) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        return ExprEval.evaluateValueExpression(exprStr, nameVals, expectedClass, ResolverType.VARIABLE_ELRESOLVER);
    }

    public static Object evaluateMethodExpression(String exprStr, Class[] params, Class expectedClass, ResolverType resolverType) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(resolverType).getELContext();
        MethodExpression mexp = expFactory.createMethodExpression(context, exprStr, expectedClass, params);
        return mexp.invoke(context, (Object[])params);
    }

    public static Object evaluateCoerceValueExpression(String exprStr, Object exprVal, Class expectedClass) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(ResolverType.VARIABLE_ELRESOLVER).getELContext();
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        vexp.setValue(context, exprVal);
        return vexp.getValue(context);
    }

    public static boolean evaluateManyValueExpression(String exprStr, Object exprVal, Class expectedClass, Hashtable contextobj) throws ELException, PropertyNotFoundException, PropertyNotWritableException, ClassNotFoundException {
        boolean result = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(ResolverType.VARIABLE_ELRESOLVER).getELContext();
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        vexp.setValue(context, exprVal);
        Enumeration keys = contextobj.keys();
        while (keys.hasMoreElements()) {
            Class cl = (Class)keys.nextElement();
            Object value = contextobj.get(cl);
            context.putContext(cl, value);
            TestUtil.logTrace((String)("Adding value: \"" + value + "\" To Context!"));
            if (ExprEval.compareValue(exprVal, vexp.getValue(context))) continue;
            TestUtil.logErr((String)("Expression Failed! After Adding: \"" + value + "\" To Context"));
            result = false;
        }
        return result;
    }

    public static boolean compareClass(Object obj, Class expectedClass) {
        boolean isInstance = expectedClass.isInstance(obj);
        if (!isInstance) {
            TestUtil.logErr((String)"Unexpected type for expression evaluation");
            TestUtil.logErr((String)("Expected type: " + expectedClass.toString()));
            TestUtil.logErr((String)("Computed type: " + obj.getClass().toString()));
        }
        return isInstance;
    }

    public static boolean compareValue(Object val, Object expectedVal) {
        if (!val.equals(expectedVal)) {
            TestUtil.logErr((String)"Unexpected value for expression evaluation");
            TestUtil.logErr((String)("Expected value: " + expectedVal.toString()));
            TestUtil.logErr((String)("Computed value: " + val.toString()));
            return false;
        }
        return true;
    }

    public static boolean compareValue(Boolean val, Boolean expectedVal) {
        if (!val.equals(expectedVal)) {
            TestUtil.logErr((String)"Unexpected value for expression evaluation");
            TestUtil.logErr((String)("Expected value: " + expectedVal.toString()));
            TestUtil.logErr((String)("Computed value: " + val.toString()));
            return false;
        }
        return true;
    }

    public static boolean compareValue(Double val, Float expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal.floatValue());
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(Float val, Float expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val.floatValue());
        BigDecimal b = new BigDecimal(expectedVal.floatValue());
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(Long val, Long expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal);
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(BigInteger val, BigInteger expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal);
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(BigDecimal val, BigDecimal expectedVal, int eps) {
        BigDecimal b;
        MathContext mc = new MathContext(eps, RoundingMode.DOWN);
        BigDecimal a = val.abs(mc);
        if (0 != a.compareTo(b = expectedVal.abs(mc))) {
            TestUtil.logErr((String)"Unexpected value for expression evaluation");
            TestUtil.logErr((String)("Expected value: " + expectedVal));
            TestUtil.logErr((String)("Computed value: " + val));
            return false;
        }
        return true;
    }

    public static void cleanup() {
        new SimpleELContext().cleanup();
    }
}

