/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.literal;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "literal_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="literal_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"literal_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientServletTest.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elBooleanLiteralTest() throws Exception {
        boolean pass2;
        Object result;
        boolean pass1;
        Boolean expectedResult = Boolean.TRUE;
        try {
            pass1 = false;
            expectedResult = Boolean.TRUE;
            result = ExprEval.evaluateValueExpression("${true}", null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass1 = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)expectedResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        try {
            pass2 = false;
            expectedResult = Boolean.FALSE;
            result = ExprEval.evaluateValueExpression("${false}", null, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass2 = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)expectedResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: Literal true evaluated incorrectly.");
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: Literal false evaluated incorrectly.");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elIntegerLiteralTest() throws Exception {
        List ilist = this.getIntegerList();
        for (Integer tInteger : ilist) {
            boolean pass2;
            Object result;
            boolean pass1;
            Long expectedResult = (long)tInteger;
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + tInteger.toString() + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass1 = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + tInteger.toString() + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass2 = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal Integer \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal Integer \"#\" evaluated incorrectly.");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elFloatingPointLiteralTest() throws Exception {
        List flist = this.getFloatList();
        for (Float tFloat : flist) {
            boolean pass2;
            Object result;
            boolean pass1;
            Float expectedResult = Float.valueOf(tFloat.floatValue());
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + tFloat.toString() + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass1 = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult, 1);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + tFloat.toString() + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass2 = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult, 1);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal Float \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal Float \"#\" evaluated incorrectly.");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elStringLiteralTest() throws Exception {
        Hashtable sMap = this.getStringTable();
        Enumeration keys = sMap.keys();
        while (keys.hasMoreElements()) {
            boolean pass2;
            Object result;
            boolean pass1;
            String expectedResult = keys.nextElement().toString();
            String testString = sMap.get(expectedResult).toString();
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + testString + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass1 = ExprEval.compareClass(result, String.class) && ExprEval.compareValue((String)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + testString + "}", null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass2 = ExprEval.compareClass(result, String.class) && ExprEval.compareValue((String)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal String \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal String \"#\" evaluated incorrectly.");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elNullLiteralTest() throws Exception {
        boolean pass2;
        boolean pass1;
        Object result;
        try {
            result = ExprEval.evaluateValueExpression("${null}", null, Object.class);
            pass1 = result == null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        try {
            result = ExprEval.evaluateValueExpression("#{null}", null, Object.class);
            pass2 = result == null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: Literal 'null' \"$\" evaluated incorrectly.");
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: Literal 'null \"#\" evaluated incorrectly.");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void elSyntaxAsLiteralTest() throws Exception {
        boolean pass = false;
        Hashtable<String, String> testValues = new Hashtable<String, String>();
        testValues.put("${foo}", "#{'${'}foo}");
        testValues.put("${foo}", "${'${'}foo}");
        testValues.put("#{foo}", "${'#{'}foo}");
        testValues.put("#{foo}", "#{'#{'}foo}");
        Set tvalue = testValues.keySet();
        for (String expected : tvalue) {
            String exprStr = (String)testValues.get(expected);
            try {
                Object expr = ExprEval.evaluateValueExpression(exprStr, null, String.class);
                pass = ExprEval.compareClass(expr, String.class) && ExprEval.compareValue(expr, expected);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (pass) continue;
            throw new Exception("TEST FAILED!");
        }
    }

    private List getFloatList() {
        ArrayList<Float> floatList = new ArrayList<Float>();
        floatList.add(new Float("8.1F"));
        floatList.add(new Float("-70.2F"));
        floatList.add(new Float("8.1e4F"));
        floatList.add(new Float("8.1E6F"));
        floatList.add(new Float("8.1e-9F"));
        floatList.add(new Float("8.1E+3F"));
        floatList.add(new Float("-.72F"));
        floatList.add(new Float(".999F"));
        floatList.add(new Float("-.1e1F"));
        floatList.add(new Float(".234E22F"));
        floatList.add(new Float("-.3444e-2F"));
        floatList.add(new Float(".5E+7F"));
        floatList.add(new Float("-1e1F"));
        floatList.add(new Float("234E2F"));
        floatList.add(new Float("-3444e-2F"));
        floatList.add(new Float("-3444e+2F"));
        return floatList;
    }

    private List getIntegerList() {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(1);
        integerList.add(-2);
        integerList.add(Integer.MAX_VALUE);
        integerList.add(-2147483647);
        return integerList;
    }

    private Hashtable getStringTable() {
        Hashtable<String, String> testStrings = new Hashtable<String, String>();
        testStrings.put("string", "'string'");
        testStrings.put("str\\ing", "'str\\\\ing'");
        testStrings.put("\"catstring\"", "'\"catstring\"'");
        testStrings.put("'pullstring'", "'\\'pullstring\\''");
        return testStrings;
    }
}

