/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.cdi;

import ee.jakarta.tck.persistence.ee.cdi.CtsEm2Qualifier;
import ee.jakarta.tck.persistence.ee.cdi.CtsEmNoTxQualifier;
import ee.jakarta.tck.persistence.ee.cdi.CtsEmQualifier;
import ee.jakarta.tck.persistence.ee.cdi.RestActivator;
import ee.jakarta.tck.persistence.ee.cdi.RestEndpoint;
import ee.jakarta.tck.persistence.ee.cdi.TestBeanEM;
import ee.jakarta.tck.persistence.ee.cdi.TestBeanUtilities;
import ee.jakarta.tck.persistence.ee.entityManager.Order;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;

@ExtendWith(value={ArquillianExtension.class})
public class ServletEMLookupTest {
    @ArquillianResource
    URL contextPath;

    @Deployment(name="jpa-cdi-em-inject", testable=false)
    public static WebArchive deployment(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{RestActivator.class, RestEndpoint.class, TestBeanEM.class, TestBeanUtilities.class, CtsEmQualifier.class, CtsEm2Qualifier.class, CtsEmNoTxQualifier.class});
        JavaArchive jpa_ee_entityManager = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jpa_ee_entityManager.jar");
        jpa_ee_entityManager.addClasses(new Class[]{Order.class});
        URL parURL = ServletEMLookupTest.class.getResource("persistence.xml");
        jpa_ee_entityManager.addAsManifestResource(parURL, "persistence.xml");
        archiveProcessor.processParArchive(jpa_ee_entityManager, ServletEMLookupTest.class, parURL);
        war.addAsLibrary((Archive)jpa_ee_entityManager);
        archiveProcessor.processWebArchive(war, ServletEMLookupTest.class, null);
        return war;
    }

    @Test
    public void injectEmUsingQualifierTest() throws Exception {
        try (Response response = ClientBuilder.newBuilder().build().target(this.contextPath.toURI().resolve("rest/cdi-persistence/injectEntityManagerUsingQualifier")).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();){
            Assertions.assertEquals((int)200, (int)response.getStatus());
        }
    }

    @Test
    public void injectEntityManagerFactoryUsingQualifier() throws Exception {
        try (Response response = ClientBuilder.newBuilder().build().target(this.contextPath.toURI().resolve("rest/cdi-persistence/injectEntityManagerFactoryUsingQualifier")).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();){
            Assertions.assertEquals((int)200, (int)response.getStatus());
        }
    }

    @Test
    public void injectUtilitiesUsingQualifier() throws Exception {
        try (Response response = ClientBuilder.newBuilder().build().target(this.contextPath.toURI().resolve("rest/cdi-persistence/injectUtilitiesUsingQualifier")).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();){
            Assertions.assertEquals((int)200, (int)response.getStatus());
        }
    }
}

