/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient.http;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.Util;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.http.MethodFactory;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;

public class HttpRequest {
    public static int DEFAULT_HTTP_PORT;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final int NO_AUTHENTICATION = 0;
    public static final int BASIC_AUTHENTICATION = 1;
    public static final int DIGEST_AUTHENTICATION = 2;
    private HttpMethod _method = null;
    private String _host = null;
    private int _port = DEFAULT_HTTP_PORT;
    private boolean _isSecure = false;
    private HttpState _state = null;
    private String _requestLine = null;
    private int _authType = 0;
    private boolean _useCookies = false;
    private int _contentLength = 0;
    private boolean _redirect = false;
    Header[] _headers = null;
    protected HttpClient client = new HttpClient();

    public HttpRequest(String requestLine, String host, int port) {
        this._method = MethodFactory.getInstance(requestLine);
        this._method.setFollowRedirects(false);
        this._host = host;
        this._port = port;
        if (port == 443) {
            this._isSecure = true;
        }
        this._requestLine = requestLine;
    }

    public String getRequestPath() {
        return this._method.getPath();
    }

    public String getRequestMethod() {
        return this._method.getName();
    }

    public boolean isSecureRequest() {
        return this._isSecure;
    }

    public void setSecureRequest(boolean secure) {
        this._isSecure = secure;
    }

    public void setContent(String content) {
        if (this._method instanceof EntityEnclosingMethod) {
            ((EntityEnclosingMethod)this._method).setRequestEntity((RequestEntity)new StringRequestEntity(content));
        }
        this._contentLength = content.length();
    }

    public void setAuthenticationCredentials(String username, String password, int authType, String realm) {
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        AuthScope scope = new AuthScope(this._host, this._port, realm);
        this.getState().setCredentials(scope, (Credentials)cred);
        TestUtil.logTrace("[HttpRequest] Added credentials for '" + username + "' with password '" + password + "' in realm '" + realm + "'");
        this._authType = authType;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this._method.addRequestHeader(headerName, headerValue);
        TestUtil.logTrace("[HttpRequest] Added request header: " + this._method.getRequestHeader(headerName).toExternalForm());
    }

    public void addRequestHeader(String header) {
        StringTokenizer st = new StringTokenizer(header, "|");
        while (st.hasMoreTokens()) {
            String h = st.nextToken();
            if (h.toLowerCase().startsWith("cookie")) {
                this.createCookie(h);
                continue;
            }
            int col = h.indexOf(58);
            this.addRequestHeader(h.substring(0, col).trim(), h.substring(col + 1).trim());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        this._method.setRequestHeader(headerName, headerValue);
        TestUtil.logTrace("[HttpRequest] Set request header: " + this._method.getRequestHeader(headerName).toExternalForm());
    }

    public void setFollowRedirects(boolean followRedirects) {
        this._method.setFollowRedirects(followRedirects);
    }

    public boolean getFollowRedirects() {
        return this._method.getFollowRedirects();
    }

    public void setState(HttpState state) {
        this._state = state;
        this._useCookies = true;
    }

    public HttpResponse execute() throws IOException, HttpException {
        SSLProtocolSocketFactory factory;
        int defaultPort;
        String method;
        if (this._method.getFollowRedirects()) {
            SSLProtocolSocketFactory factory2;
            int defaultPort2;
            String method2;
            this.client = new HttpClient();
            if (this._isSecure) {
                method2 = "https";
                defaultPort2 = 443;
                factory2 = new SSLProtocolSocketFactory();
            } else {
                method2 = "http";
                defaultPort2 = DEFAULT_HTTP_PORT;
                factory2 = new DefaultProtocolSocketFactory();
            }
            Protocol protocol = new Protocol(method2, (ProtocolSocketFactory)factory2, defaultPort2);
            HttpConnection conn = new HttpConnection(this._host, this._port, protocol);
            if (conn.isOpen()) {
                throw new IllegalStateException("Connection incorrectly opened");
            }
            conn.open();
            TestUtil.logMsg("[HttpRequest] Dispatching request: '" + this._requestLine + "' to target server at '" + this._host + ":" + this._port + "'");
            this.addSupportHeaders();
            this._headers = this._method.getRequestHeaders();
            TestUtil.logTrace("########## The real value set: " + this._method.getFollowRedirects());
            this.client.getHostConfiguration().setHost(this._host, this._port, protocol);
            this.client.executeMethod(this._method);
            return new HttpResponse(this._host, this._port, this._isSecure, this._method, this.getState());
        }
        if (this._isSecure) {
            method = "https";
            defaultPort = 443;
            factory = new SSLProtocolSocketFactory();
        } else {
            method = "http";
            defaultPort = DEFAULT_HTTP_PORT;
            factory = new DefaultProtocolSocketFactory();
        }
        Protocol protocol = new Protocol(method, (ProtocolSocketFactory)factory, defaultPort);
        HttpConnection conn = new HttpConnection(this._host, this._port, protocol);
        if (conn.isOpen()) {
            throw new IllegalStateException("Connection incorrectly opened");
        }
        conn.open();
        TestUtil.logMsg("[HttpRequest] Dispatching request: '" + this._requestLine + "' to target server at '" + this._host + ":" + this._port + "'");
        this.addSupportHeaders();
        this._headers = this._method.getRequestHeaders();
        TestUtil.logTrace("########## The real value set: " + this._method.getFollowRedirects());
        this._method.execute(this.getState(), conn);
        return new HttpResponse(this._host, this._port, this._isSecure, this._method, this.getState());
    }

    public HttpState getState() {
        if (this._state == null) {
            this._state = new HttpState();
        }
        return this._state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(255);
        sb.append("[REQUEST LINE] -> ").append(this._requestLine).append('\n');
        if (this._headers != null && this._headers.length != 0) {
            for (Header _header : this._headers) {
                sb.append("       [REQUEST HEADER] -> ");
                sb.append(_header.toExternalForm()).append('\n');
            }
        }
        if (this._contentLength != 0) {
            sb.append("       [REQUEST BODY LENGTH] -> ").append(this._contentLength);
            sb.append('\n');
        }
        return sb.toString();
    }

    private void createCookie(String cookieHeader) {
        String cookieLine = cookieHeader.substring(cookieHeader.indexOf(58) + 1).trim();
        StringTokenizer st = new StringTokenizer(cookieLine, " ;");
        Cookie cookie = new Cookie();
        cookie.setVersion(1);
        this.getState();
        if (cookieLine.indexOf("$Version") == -1) {
            cookie.setVersion(0);
            this._method.getParams().setCookiePolicy("netscape");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) != '$' && !token.startsWith("Domain") && !token.startsWith("Path")) {
                cookie.setName(token.substring(0, token.indexOf(61)));
                cookie.setValue(token.substring(token.indexOf(61) + 1));
                continue;
            }
            if (token.indexOf("Domain") > -1) {
                cookie.setDomainAttributeSpecified(true);
                cookie.setDomain(token.substring(token.indexOf(61) + 1));
                continue;
            }
            if (token.indexOf("Path") <= -1) continue;
            cookie.setPathAttributeSpecified(true);
            cookie.setPath(token.substring(token.indexOf(61) + 1));
        }
        this._state.addCookie(cookie);
    }

    private void addSupportHeaders() {
        switch (this._authType) {
            case 0: {
                break;
            }
            case 1: {
                this.setBasicAuthorizationHeader();
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Digest Authentication is not currently supported");
            }
        }
        this.setHostHeader();
        this.setContentLengthHeader();
        this.setCookieHeader();
    }

    private void setBasicAuthorizationHeader() {
        UsernamePasswordCredentials cred = (UsernamePasswordCredentials)this.getState().getCredentials(new AuthScope(this._host, this._port, null));
        String authString = null;
        if (cred != null) {
            authString = "Basic " + Util.getBase64EncodedString(cred.getUserName() + ":" + cred.getPassword());
        } else {
            TestUtil.logTrace("[HttpRequest] NULL CREDENTIALS");
        }
        this._method.setRequestHeader("Authorization", authString);
    }

    private void setContentLengthHeader() {
        if (this._contentLength > 0) {
            this._method.setRequestHeader("Content-Length", Integer.toString(this._contentLength));
        }
    }

    private void setHostHeader() {
        if (this._port == DEFAULT_HTTP_PORT || this._port == 443) {
            this._method.setRequestHeader("Host", this._host);
        } else {
            this._method.setRequestHeader("Host", this._host + ":" + this._port);
        }
    }

    private void setCookieHeader() {
        Header cHeader;
        Cookie[] cookies;
        if (this._useCookies && (cookies = this._state.getCookies()) != null && cookies.length > 0 && (cHeader = CookiePolicy.getCookieSpec((String)"rfc2109").formatCookieHeader(this._state.getCookies())) != null) {
            this._method.setRequestHeader(cHeader);
        }
    }

    static {
        if (TestUtil.traceflag) {
            System.setProperty("org.apache.commons.logging.Log", "com.sun.ts.tests.common.webclient.log.WebLog");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
        }
        DEFAULT_HTTP_PORT = 80;
    }
}

