/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.DoneLatch;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.TextMessage;
import java.util.ArrayList;

public class TestMessageListener
implements MessageListener {
    public MessageConsumer mConsumer;
    public DoneLatch monitor;
    public ArrayList messageArray = new ArrayList();

    public TestMessageListener(MessageConsumer mc, DoneLatch dl) {
        this.mConsumer = mc;
        this.monitor = dl;
    }

    public ArrayList getMessageArray() {
        return this.messageArray;
    }

    public DoneLatch getLatch() {
        return this.monitor;
    }

    public void clearMessageArray() {
        this.messageArray.clear();
    }

    public void onMessage(Message message) {
        try {
            TestUtil.logTrace("MessageListener for " + this.mConsumer.toString() + " received message: " + message.toString());
            this.messageArray.add(message);
        }
        catch (Exception e) {
            TestUtil.logErr("Error in MessageListener: " + e.toString(), e);
        }
        if (message instanceof TextMessage) {
            this.monitor.allDone();
        }
    }
}

