/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.util;

import jakarta.el.ELException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class JspTestUtil {
    public static boolean DEBUG = true;
    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = new Class[]{HttpServletRequest.class, HttpServletResponse.class, JspWriter.class};

    private JspTestUtil() {
    }

    public static void invokeTest(Object testObject, HttpServletRequest req, HttpServletResponse res, JspWriter out) throws ServletException {
        String test = req.getParameter(TEST_HEADER);
        JspTestUtil.debug("[JspTestUtil] Test to invoke: " + test);
        try {
            Method method = testObject.getClass().getMethod(test, TEST_ARGS);
            method.invoke(testObject, req, res, out);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException().toString());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public static void handleThrowable(Throwable t, JspWriter out, String identifier) throws IOException {
        Throwable sub;
        out.println("Test FAILED.  " + identifier + " Unexpected Throwable caught");
        out.println("Type: " + t.getClass().getName());
        out.println("Message: " + t.getMessage());
        if (t instanceof ELException && (sub = ((ELException)t).getCause()) != null) {
            out.println("Root Cause: " + sub);
            out.println("Root Cause Message: " + sub.getMessage());
        }
    }

    public static boolean checkEnumeration(Enumeration e, String[] values) {
        if (e == null || values == null) {
            return false;
        }
        boolean valuesFound = true;
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            String val;
            try {
                val = (String)e.nextElement();
            }
            catch (NoSuchElementException nsee) {
                JspTestUtil.debug("[JspTestUtil] There were less elements in the Enumeration than expected");
                valuesFound = false;
                break;
            }
            JspTestUtil.debug("[JspTestUtil] Looking for '" + val + "' in values: " + JspTestUtil.getAsString(values));
            if (Arrays.binarySearch(values, val) >= 0) continue;
            JspTestUtil.debug("[JspTestUtil] Value '" + val + "' not found.");
            valuesFound = false;
            break;
        }
        if (e.hasMoreElements()) {
            JspTestUtil.debug("[JspTestUtil] There were more elements in the Enumeration than expected.");
            valuesFound = false;
        }
        return valuesFound;
    }

    public static String getAsString(String[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < sArray.length; ++i) {
            buf.append(sArray[i]);
            if (i + 1 == sArray.length) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String getAsString(Enumeration e) {
        return JspTestUtil.getAsString(JspTestUtil.getAsStringArray(e));
    }

    public static String[] getAsStringArray(Enumeration e) {
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAsStringArray(Iterator i) {
        ArrayList list = new ArrayList();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof String[]) {
                o = JspTestUtil.getAsString((String[])o);
            }
            list.add(o);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getAsStringArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static void debug(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static ValidationMessage[] getValidationMessage(String id, String message) {
        if (message == null) {
            return null;
        }
        return new ValidationMessage[]{new ValidationMessage(id, message)};
    }

    public static String getAsString(Map map) {
        StringBuffer sb = new StringBuffer(32);
        Set entrySet = map.entrySet();
        sb.append("Map Entries\n----------------\n");
        for (Map.Entry entry : entrySet) {
            sb.append(entry.getKey()).append(", ");
            sb.append((Object)(entry.getValue() instanceof Cookie ? ((Cookie)entry.getValue()).getValue() : entry.getValue()));
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String getTagStatusAsString(String method, String type, int status) {
        String value = "UNIDENTIFIED VALUE";
        if ("doStartTag".equals(method)) {
            switch (status) {
                case 1: {
                    value = "EVAL_BODY_INCLUDE";
                    break;
                }
                case 0: {
                    value = "SKIP_BODY";
                }
            }
        } else if ("doEndTag".equals(method)) {
            switch (status) {
                case 5: {
                    value = "SKIP_PAGE";
                    break;
                }
                case 6: {
                    value = "EVAL_PAGE";
                }
            }
        } else if ("doAfterBody".equals(method) && "IterationTag".equals(type)) {
            switch (status) {
                case 0: {
                    value = "SKIP_BODY";
                    break;
                }
                case 2: {
                    value = "EVAL_BODY_AGAIN";
                }
            }
        } else if ("doAfterBody".equals(method) && "BodyTag".equals(type)) {
            switch (status) {
                case 0: {
                    value = "SKIP_BODY";
                    break;
                }
                case 2: {
                    value = "EVAL_BODY_BUFFERED";
                }
            }
        }
        return value;
    }

    public static String getScopeName(int scope) {
        String UNKNOWN_SCOPE = "Unknown Scope";
        switch (scope) {
            case 1: {
                return "Page";
            }
            case 2: {
                return "Request";
            }
            case 3: {
                return "Session";
            }
            case 4: {
                return "Application";
            }
        }
        return "Unknown Scope";
    }
}

