/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.propagation.am;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.propagation.am.Member;
import ee.jakarta.tck.persistence.ee.propagation.am.Member2;
import ee.jakarta.tck.persistence.ee.propagation.am.Stateful3IF2;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import jakarta.persistence.PersistenceUnits;
import java.math.BigInteger;
import java.util.Properties;

@PersistenceUnits(value={@PersistenceUnit(name="persistence/cau", unitName="CTS-APPMANAGED-UNIT"), @PersistenceUnit(name="persistence/cau2", unitName="CTS-APPMANAGED-UNIT2")})
@Stateful(name="Stateful3Bean2")
@Remote(value={Stateful3IF2.class})
public class Stateful3Bean2
implements Stateful3IF2 {
    private static final String EMF_LOOKUP_NAME = "java:comp/env/persistence/cau";
    private static final String EMF_LOOKUP_NAME2 = "java:comp/env/persistence/cau2";
    private EntityManagerFactory entityManagerFactory;
    private EntityManagerFactory entityManagerFactory2;
    public SessionContext sessionContext;
    private EntityManager entityManager;
    private EntityManager entityManager2;
    private static final Member[] mRef = new Member[5];
    private static final Member2[] mRef2 = new Member2[5];
    public Properties p;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    private EntityManagerFactory getEMF() {
        TestUtil.logTrace((String)"In getEMF");
        if (this.entityManagerFactory == null) {
            TestUtil.logTrace((String)"Obtaining EMF");
            try {
                TSNamingContext nctx = new TSNamingContext();
                this.entityManagerFactory = (EntityManagerFactory)nctx.lookup(EMF_LOOKUP_NAME);
                if (this.entityManagerFactory == null) {
                    TestUtil.logErr((String)"EMF returned by lookup was Null");
                } else {
                    TestUtil.logTrace((String)("EMF:" + this.entityManagerFactory.toString()));
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception caught looking up EntityManagerFactory", (Throwable)e);
                System.out.println("Exception caught looking up EntityManagerFactory");
                e.printStackTrace();
            }
        }
        return this.entityManagerFactory;
    }

    private EntityManagerFactory getEMF2() {
        TestUtil.logTrace((String)"In getEMF2");
        if (this.entityManagerFactory2 == null) {
            TestUtil.logTrace((String)"Obtaining EMF");
            try {
                TSNamingContext nctx = new TSNamingContext();
                this.entityManagerFactory2 = (EntityManagerFactory)nctx.lookup(EMF_LOOKUP_NAME2);
                if (this.entityManagerFactory2 == null) {
                    TestUtil.logErr((String)"EMF returned by lookup was Null");
                } else {
                    TestUtil.logTrace((String)("EMF2:" + this.entityManagerFactory2.toString()));
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception caught looking up EntityManagerFactory", (Throwable)e);
                System.out.println("Exception caught looking up EntityManagerFactory");
                e.printStackTrace();
            }
        }
        return this.entityManagerFactory2;
    }

    @PostConstruct
    public void prepareEnvironment() {
        try {
            TestUtil.logTrace((String)"In PostContruct");
            this.getEMF();
            this.getEMF2();
            if (this.entityManagerFactory != null) {
                this.entityManager = this.entityManagerFactory.createEntityManager();
            } else {
                TestUtil.logErr((String)"EntityManagerFactory is null");
            }
            if (this.entityManagerFactory2 != null) {
                this.entityManager2 = this.entityManagerFactory2.createEntityManager();
            } else {
                TestUtil.logErr((String)"EntityManagerFactory is null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)" In PostConstruct: Exception caught while setting EntityManager", (Throwable)e);
        }
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test5() {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        try {
            this.entityManager.joinTransaction();
            this.removeTestData();
            this.createTestData();
            this.entityManager2.joinTransaction();
            this.createTestData2();
            if (this.entityManager.contains((Object)mRef[0])) {
                TestUtil.logTrace((String)("Member:" + mRef[0].getMemberId() + " exists"));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Member:" + mRef[0].getMemberId() + " does not exist"));
            }
            if (this.entityManager2.contains((Object)mRef2[0])) {
                TestUtil.logTrace((String)("Member2:" + mRef2[0].getMemberId() + " exists"));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Member2:" + mRef2[0].getMemberId() + " does not exist"));
            }
            if (!this.entityManager.contains((Object)mRef2[0])) {
                TestUtil.logTrace((String)("PU java:comp/env/persistence/cau does not contain Member2:" + mRef2[0].getMemberId() + " as expected"));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("PU java:comp/env/persistence/cau does incorrectly contain Member2:" + mRef2[0].getMemberId()));
            }
            if (!this.entityManager2.contains((Object)mRef[0])) {
                TestUtil.logTrace((String)("PU java:comp/env/persistence/cau2 does not contain Member:" + mRef[0].getMemberId() + " as expected"));
                pass4 = true;
            } else {
                TestUtil.logErr((String)("PU java:comp/env/persistence/cau2 does incorrectly contain Member:" + mRef[0].getMemberId()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        finally {
            TestUtil.logTrace((String)"Finally, removeTestData");
            this.removeTestData();
            this.closeEntityManager();
        }
        return pass1 && pass2 && pass3 && pass4;
    }

    public void checkMemberStatus(Member2 m) {
        System.out.println("checkMemberStatus - joinTransaction");
        int newDonation = 10000;
        if (null == m) {
            TestUtil.logTrace((String)"checkMemberStatus: member is NULL");
        } else {
            if (m.isDuesPaid()) {
                TestUtil.logTrace((String)"checkCustomerStatus: thisMember is not null, setDonation");
                m.setDonation(new BigInteger("10000"));
            } else {
                BigInteger currentDonation = m.getDonation();
                int convertedDonation = 0;
                if (currentDonation != null) {
                    convertedDonation = currentDonation.intValue();
                }
                m.setDonation(new BigInteger(String.valueOf(convertedDonation + newDonation)));
                m.setDuesPaid(true);
            }
            TestUtil.logTrace((String)"merge thisMember");
            this.entityManager.flush();
        }
    }

    public Member2 getMember(int memberId) {
        TestUtil.logTrace((String)"getMember");
        return (Member2)this.entityManager.find(Member2.class, (Object)memberId);
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            TestUtil.logTrace((String)"Create Member Entities");
            Stateful3Bean2.mRef[0] = new Member(7, "Jane Lam", false);
            Stateful3Bean2.mRef[1] = new Member(8, "Vinny Testa", false);
            Stateful3Bean2.mRef[2] = new Member(9, "Mario Luigi", true, new BigInteger("25000"));
            Stateful3Bean2.mRef[3] = new Member(10, "Sky Blue", false);
            Stateful3Bean2.mRef[4] = new Member(11, "Leonardi DaVinci", true, new BigInteger("100000"));
            TestUtil.logTrace((String)"Start to persist Members ");
            System.out.println("Persist Member Entities");
            for (Member m : mRef) {
                if (m == null) continue;
                this.entityManager.persist((Object)m);
                TestUtil.logTrace((String)("persisted Member " + m));
            }
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating member data:" + e));
        }
    }

    public void createTestData2() {
        TestUtil.logTrace((String)"createTestData2");
        try {
            TestUtil.logTrace((String)"Create Member2 Entities");
            Stateful3Bean2.mRef2[0] = new Member2(77, "Jane Lam", false);
            Stateful3Bean2.mRef2[1] = new Member2(88, "Vinny Testa", false);
            Stateful3Bean2.mRef2[2] = new Member2(99, "Mario Luigi", true, new BigInteger("25000"));
            Stateful3Bean2.mRef2[3] = new Member2(100, "Sky Blue", false);
            Stateful3Bean2.mRef2[4] = new Member2(111, "Leonardi DaVinci", true, new BigInteger("100000"));
            TestUtil.logTrace((String)"Start to persist Members ");
            System.out.println("Persist Member2 Entities");
            for (Member2 m : mRef2) {
                if (m == null) continue;
                this.entityManager2.persist((Object)m);
                TestUtil.logTrace((String)("persisted Member2 " + m));
            }
            this.entityManager2.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating member data:" + e));
        }
    }

    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM MEMBER").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManagerFactory.getCache().evictAll();
    }

    public void closeEntityManager() {
        try {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("closeEntityManager: Unexpected Exception caught while closing an Application-Managed EntityManager" + e));
        }
    }
}

