/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.resourcedefs.annotations;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSConnectionFactoryDefinitions;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

@JMSDestinationDefinitions(value={@JMSDestinationDefinition(description="Define Queue ServletMyTestQueue", interfaceName="jakarta.jms.Queue", name="java:global/env/ServletMyTestQueue", destinationName="ServletMyTestQueue"), @JMSDestinationDefinition(description="Define Topic ServletMyTestTopic", interfaceName="jakarta.jms.Topic", name="java:app/env/ServletMyTestTopic", destinationName="ServletMyTestTopic")})
@JMSConnectionFactoryDefinitions(value={@JMSConnectionFactoryDefinition(description="Define ConnectionFactory ServletMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/ServletMyTestConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define QueueConnectionFactory ServletMyTestQueueConnectionFactory", interfaceName="jakarta.jms.QueueConnectionFactory", name="java:app/ServletMyTestQueueConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define TopicConnectionFactory ServletMyTestTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:module/ServletMyTestTopicConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define Durable TopicConnectionFactory ServletMyTestDurableTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:comp/env/jms/ServletMyTestDurableTopicConnectionFactory", user="j2ee", password="j2ee", clientId="MyClientID", properties={"Property1=10", "Property2=20"}, transactional=false, maxPoolSize=30, minPoolSize=20)})
@WebServlet(value={"/ServletTest"})
public class ServletClient
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected transient ConnectionFactory cf = null;
    protected transient ConnectionFactory dcf = null;
    protected transient ConnectionFactory cfra = null;
    protected transient QueueConnectionFactory qcf = null;
    protected transient TopicConnectionFactory tcf = null;
    protected transient TopicConnectionFactory dtcf = null;
    protected transient Topic topic = null;
    protected transient Topic topica = null;
    protected transient Queue queue = null;
    protected transient JMSContext context = null;
    protected transient JMSConsumer consumerQ = null;
    protected transient JMSProducer producerQ = null;
    protected transient JMSConsumer consumerT = null;
    protected transient JMSProducer producerT = null;
    protected boolean queueTest = false;
    protected Properties harnessProps = null;
    protected long timeout;
    protected String user;
    protected String password;
    protected String mode;

    private void doCleanup() throws Exception {
        try {
            if (this.queueTest && this.consumerQ != null) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                Message rmsg = this.consumerQ.receive(this.timeout);
                while (rmsg != null) {
                    rmsg = this.consumerQ.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = this.consumerQ.receiveNoWait();
                }
                this.consumerQ.close();
            }
            if (this.consumerT != null) {
                this.consumerT.close();
            }
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("doCleanup failed!", e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean pass = true;
        Properties p = new Properties();
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        try {
            String test = this.harnessProps.getProperty("TEST");
            System.out.println("doGet: test to execute is: " + test);
            if (test.equals("sendAndRecvQueueTestFromServletClient")) {
                if (this.sendAndRecvQueueTestFromServletClient()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("sendAndRecvTopicTestFromServletClient")) {
                if (this.sendAndRecvTopicTestFromServletClient()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("checkClientIDTestFromServletClient")) {
                if (this.checkClientIDTestFromServletClient()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else {
                p.setProperty("TESTRESULT", "fail");
            }
            this.doCleanup();
            p.list(out);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("doGet: Exception: " + e));
            System.out.println("doGet: Exception: " + e);
            p.setProperty("TESTRESULT", "fail");
            p.list(out);
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.harnessProps = new Properties();
        Enumeration enumlist = req.getParameterNames();
        while (enumlist.hasMoreElements()) {
            String name = (String)enumlist.nextElement();
            String value = req.getParameter(name);
            this.harnessProps.setProperty(name, value);
        }
        try {
            TestUtil.init((Properties)this.harnessProps);
            this.timeout = Long.parseLong(this.harnessProps.getProperty("jms_timeout"));
            this.user = this.harnessProps.getProperty("user");
            this.password = this.harnessProps.getProperty("password");
            this.mode = this.harnessProps.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.doLookupJMSObjects();
        }
        catch (Exception e) {
            System.out.println("doPost: Exception: " + e);
            e.printStackTrace();
            throw new ServletException("unable to initialize remote logging");
        }
        this.doGet(req, res);
        this.harnessProps = null;
    }

    private void doLookupJMSObjects() throws Exception {
        try {
            TestUtil.logMsg((String)"Lookup JMS factories defined by @JMSConnectionFactoryDefinitions");
            TestUtil.logMsg((String)"Lookup JMS destinations defined by @JMSDestinationDefinitions");
            TSNamingContext namingctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup java:comp/DefaultJMSConnectionFactory");
            this.dcf = (ConnectionFactory)namingctx.lookup("java:comp/DefaultJMSConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:global/ServletMyTestConnectionFactory");
            this.cf = (ConnectionFactory)namingctx.lookup("java:global/ServletMyTestConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:app/ServletMyTestQueueConnectionFactory");
            this.qcf = (QueueConnectionFactory)namingctx.lookup("java:app/ServletMyTestQueueConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:module/ServletMyTestTopicConnectionFactory");
            this.tcf = (TopicConnectionFactory)namingctx.lookup("java:module/ServletMyTestTopicConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:comp/env/jms/ServletMyTestDurableTopicConnectionFactory");
            this.dtcf = (TopicConnectionFactory)namingctx.lookup("java:comp/env/jms/ServletMyTestDurableTopicConnectionFactory");
            TestUtil.logMsg((String)"Lookup java:global/env/ServletMyTestQueue");
            this.queue = (Queue)namingctx.lookup("java:global/env/ServletMyTestQueue");
            TestUtil.logMsg((String)"Lookup java:app/env/ServletMyTestTopic");
            this.topic = (Topic)namingctx.lookup("java:app/env/ServletMyTestTopic");
            TestUtil.logMsg((String)"Create JMSContext, JMSProducer's and JMSConsumer's");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producerQ = this.context.createProducer();
            this.consumerQ = this.context.createConsumer((Destination)this.queue);
            this.producerT = this.context.createProducer();
            this.consumerT = this.context.createConsumer((Destination)this.topic);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw e;
        }
    }

    public boolean sendAndRecvQueueTestFromServletClient() {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvQueueTestFromServletClient");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerQ.send((Destination)this.queue, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerQ.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        return pass;
    }

    public boolean sendAndRecvTopicTestFromServletClient() {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTopicTestFromServletClient");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerT.send((Destination)this.topic, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerT.receive(this.timeout);
            if (actTextMessage == null) {
                TestUtil.logErr((String)"Did not receive TextMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    TestUtil.logMsg((String)"TextMessage is correct");
                } else {
                    TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkClientIDTestFromServletClient() {
        boolean pass = true;
        JMSContext context = null;
        try {
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSContext from durable topic connection factory");
            TestUtil.logMsg((String)"Check the client id which is configured as MyClientID in the JMSConnectionFactoryDefinition annotation");
            context = this.dtcf.createContext(this.user, this.password, 1);
            String clientid = context.getClientID();
            if (clientid == null) {
                TestUtil.logErr((String)"Client ID value is null (expected MyClientID)");
                pass = false;
            } else if (clientid.equals("MyClientID")) {
                TestUtil.logMsg((String)"Client ID value is correct (MyClientID)");
            } else {
                TestUtil.logErr((String)("Client ID value is incorrect (expected MyClientID, got " + clientid + ")"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
                this.doCleanup();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Error in cleanup " + e));
            }
        }
        return pass;
    }
}

