/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.versioning;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.versioning.Member;
import java.math.BigInteger;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTest1() throws Exception {
        this.logTrace("Begin versionTest1");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass3 = true;
        BigInteger donation = new BigInteger("5000000");
        try {
            this.getEntityTransaction().begin();
            Member m = new Member(1, "Jie Leng", true);
            this.getEntityManager().persist((Object)m);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember.getVersion() == null) {
                this.logErr("version after persistence is null.");
                pass1 = false;
            } else {
                this.logTrace("Correct non-null version after create: " + newMember.getVersion());
            }
            this.getEntityTransaction().begin();
            Member newMember2 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            int oldVersion = newMember2.getVersion();
            newMember2.setDonation(donation);
            this.getEntityManager().merge((Object)newMember2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember3 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember3.getVersion() <= oldVersion) {
                this.logErr("Wrong version after update: " + newMember3.getVersion() + ", old version: " + oldVersion);
                pass2 = false;
            } else {
                this.logTrace("Correct version after update: " + newMember3.getVersion() + ", old version: " + oldVersion);
            }
            oldVersion = newMember3.getVersion();
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("SELECT m FROM Member m where m.memberName = :name").setParameter("name", (Object)"Jie Leng").getResultList();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            Member newMember4 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (newMember4.getVersion() != oldVersion) {
                this.logErr("Wrong version after query, expected " + oldVersion + ", got " + newMember4.getVersion());
                pass3 = false;
            } else {
                this.logTrace("Correct version after query, expected " + oldVersion + ", got:" + newMember4.getVersion());
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass1 = false;
            pass2 = false;
            pass3 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("versionTest1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

