/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.JakartaEESigTest;
import com.sun.ts.tests.signaturetest.SigTestEE;
import java.io.Serializable;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="signaturetest"), @Tag(value="platform"), @Tag(value="tck-appclient")})
public class ClientSignatureAppClientTest
extends JakartaEESigTest
implements Serializable {
    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="appclient", testable=true)
    public static EnterpriseArchive createDeployment(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ClientSignatureAppClientTest_client.jar");
        archive.addPackages(false, new String[]{"com.sun.ts.tests.common.vehicle"});
        archive.addPackages(true, new String[]{"com.sun.ts.lib.harness"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.signaturetest"});
        archive.addClasses(new Class[]{ClientSignatureAppClientTest.class, JakartaEESigTest.class, SigTestEE.class, EETest.Fault.class, EETest.SetupException.class, TestUtil.class});
        URL appClientUrl = ClientSignatureAppClientTest.class.getResource("application-client.xml");
        if (appClientUrl == null) {
            throw new IllegalStateException("missing application-client.xml");
        }
        archive.addAsManifestResource(appClientUrl, "application-client.xml");
        archive.addAsManifestResource((Asset)new StringAsset("Main-Class: com.sun.ts.tests.common.vehicle.VehicleClient\n"), "MANIFEST.MF");
        String[] signatureMapFiles = new String[]{"jakarta.annotation.sig", "jakarta.batch.sig", "jakarta.data.sig", "jakarta.ejb.sig", "jakarta.el.sig", "jakarta.enterprise.concurrent.sig", "jakarta.enterprise.sig", "jakarta.faces.sig", "jakarta.interceptor.sig", "jakarta.jms.sig", "jakarta.json.bind.sig", "jakarta.json.sig", "jakarta.mail.sig", "jakarta.persistence.sig", "jakarta.resource.sig", "jakarta.security.auth.message.sig", "jakarta.security.enterprise.sig", "jakarta.security.jacc.sig", "jakarta.servlet.jsp.jstl.sig", "jakarta.servlet.jsp.sig", "jakarta.servlet.sig", "jakarta.transaction.sig", "jakarta.validation.sig", "jakarta.websocket.sig", "jakarta.ws.rs.sig"};
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ClientSignatureAppClientTest_appclient_vehicle.ear");
        for (String signatureMapFile : signatureMapFiles) {
            URL signResURL = ClientSignatureAppClientTest.class.getResource("signature-repository/" + signatureMapFile);
            if (signResURL == null) {
                throw new IllegalStateException("missing " + signatureMapFile);
            }
            archive.addAsManifestResource(signResURL, signatureMapFile);
        }
        ear.addAsModule((Archive)archive);
        archiveProcessor.processEarArchive(ear, ClientSignatureAppClientTest.class, appClientUrl);
        return ear;
    }

    @Override
    @Test
    @TargetVehicle(value="appclient")
    public void signatureTest() throws Exception {
        super.signatureTest();
    }
}

