/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.jndi.earwar;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.basic.common.BasicBeanHelper;
import com.sun.ts.tests.ejb30.lite.basic.stateless.BasicBean;
import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.Context;

@WebServlet(urlPatterns={"/TestServlet"}, loadOnStartup=1)
public class TestServlet
extends HttpTCKServlet {
    @Resource(lookup="java:module/ModuleName")
    private String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private String appNameInjected;
    @EJB
    private BasicBean basicBean;

    protected String getAppName(HttpServletRequest request) {
        String s = request.getHeader("appName");
        if (s == null || s.length() == 0) {
            throw new RuntimeException("appName in header is null or empty: " + s);
        }
        return s;
    }

    protected String getModuleName(HttpServletRequest request) {
        String s = request.getHeader("moduleName");
        if (s == null || s.length() == 0) {
            throw new RuntimeException("moduleName in header is null or empty: " + s);
        }
        return s;
    }

    public void globalJNDI(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            BasicBeanHelper.globalJNDI(this.getAppName(request), this.getModuleName(request), this.basicBean.getBusinessInterface(), reason, null, null);
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void globalJNDI2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            reason.append(this.basicBean.globalJNDI(this.getAppName(request), this.getModuleName(request)));
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void appJNDI(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            BasicBeanHelper.appJNDI(this.getModuleName(request), this.basicBean.getBusinessInterface(), reason, new EJBContext[0]);
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void appJNDI2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            reason.append(this.basicBean.appJNDI(this.getModuleName(request)));
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void moduleJNDI(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            BasicBeanHelper.moduleJNDI(this.basicBean.getBusinessInterface(), reason, new EJBContext[0]);
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void moduleJNDI2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            reason.append(this.basicBean.moduleJNDI());
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void appNameModuleName(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder sb = new StringBuilder();
        try {
            String lookup = "java:module/ModuleName";
            String expected = this.getModuleName(request);
            String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
            Helper.assertEquals("Check " + lookup, expected, actual, sb);
            Helper.assertEquals("Check injected value ", expected, this.moduleNameInjected, sb);
            lookup = "java:app/AppName";
            expected = this.getAppName(request);
            actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
            Helper.assertEquals("Check " + lookup, expected, actual, sb);
            Helper.assertEquals("Check injected value ", expected, this.appNameInjected, sb);
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            sb.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(sb.toString());
    }
}

